/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.dax.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.dax.model.Cluster;
import software.amazon.awssdk.services.dax.transform.EndpointUnmarshaller;
import software.amazon.awssdk.services.dax.transform.NodeUnmarshaller;
import software.amazon.awssdk.services.dax.transform.NotificationConfigurationUnmarshaller;
import software.amazon.awssdk.services.dax.transform.ParameterGroupStatusUnmarshaller;
import software.amazon.awssdk.services.dax.transform.SecurityGroupMembershipUnmarshaller;

public class ClusterUnmarshaller
implements Unmarshaller<Cluster, JsonUnmarshallerContext> {
    private static ClusterUnmarshaller INSTANCE;

    public Cluster unmarshall(JsonUnmarshallerContext context) throws Exception {
        Cluster.Builder clusterBuilder = Cluster.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("ClusterName", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.clusterName((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Description", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.description((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ClusterArn", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.clusterArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("TotalNodes", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.totalNodes((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("ActiveNodes", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.activeNodes((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
                if (context.testExpression("NodeType", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.nodeType((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ClusterDiscoveryEndpoint", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.clusterDiscoveryEndpoint(EndpointUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("NodeIdsToRemove", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.nodeIdsToRemove(new ListUnmarshaller(context.getUnmarshaller(String.class)).unmarshall(context));
                }
                if (context.testExpression("Nodes", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.nodes(new ListUnmarshaller((Unmarshaller)NodeUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("PreferredMaintenanceWindow", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.preferredMaintenanceWindow((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("NotificationConfiguration", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.notificationConfiguration(NotificationConfigurationUnmarshaller.getInstance().unmarshall(context));
                }
                if (context.testExpression("SubnetGroup", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.subnetGroup((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("SecurityGroups", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.securityGroups(new ListUnmarshaller((Unmarshaller)SecurityGroupMembershipUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("IamRoleArn", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.iamRoleArn((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ParameterGroup", targetDepth)) {
                    context.nextToken();
                    clusterBuilder.parameterGroup(ParameterGroupStatusUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Cluster)clusterBuilder.build();
    }

    public static ClusterUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClusterUnmarshaller();
        }
        return INSTANCE;
    }
}

