/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.EventSummary;
import software.amazon.awssdk.services.datazone.model.LineageEventProcessingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineageEventSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineageEventSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(LineageEventSummary.getter(LineageEventSummary::createdAt)).setter(LineageEventSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(LineageEventSummary.getter(LineageEventSummary::createdBy)).setter(LineageEventSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(LineageEventSummary.getter(LineageEventSummary::domainId)).setter(LineageEventSummary.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<EventSummary> EVENT_SUMMARY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eventSummary").getter(LineageEventSummary.getter(LineageEventSummary::eventSummary)).setter(LineageEventSummary.setter(Builder::eventSummary)).constructor(EventSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventSummary").build()}).build();
    private static final SdkField<Instant> EVENT_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("eventTime").getter(LineageEventSummary.getter(LineageEventSummary::eventTime)).setter(LineageEventSummary.setter(Builder::eventTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventTime").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(LineageEventSummary.getter(LineageEventSummary::id)).setter(LineageEventSummary.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> PROCESSING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("processingStatus").getter(LineageEventSummary.getter(LineageEventSummary::processingStatusAsString)).setter(LineageEventSummary.setter(Builder::processingStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("processingStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DOMAIN_ID_FIELD, EVENT_SUMMARY_FIELD, EVENT_TIME_FIELD, ID_FIELD, PROCESSING_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = LineageEventSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String createdBy;
    private final String domainId;
    private final EventSummary eventSummary;
    private final Instant eventTime;
    private final String id;
    private final String processingStatus;

    private LineageEventSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.eventSummary = builder.eventSummary;
        this.eventTime = builder.eventTime;
        this.id = builder.id;
        this.processingStatus = builder.processingStatus;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final EventSummary eventSummary() {
        return this.eventSummary;
    }

    public final Instant eventTime() {
        return this.eventTime;
    }

    public final String id() {
        return this.id;
    }

    public final LineageEventProcessingStatus processingStatus() {
        return LineageEventProcessingStatus.fromValue(this.processingStatus);
    }

    public final String processingStatusAsString() {
        return this.processingStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventSummary());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.processingStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageEventSummary)) {
            return false;
        }
        LineageEventSummary other = (LineageEventSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.eventSummary(), other.eventSummary()) && Objects.equals(this.eventTime(), other.eventTime()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.processingStatusAsString(), other.processingStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LineageEventSummary").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("DomainId", (Object)this.domainId()).add("EventSummary", (Object)this.eventSummary()).add("EventTime", (Object)this.eventTime()).add("Id", (Object)this.id()).add("ProcessingStatus", (Object)this.processingStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "eventSummary": {
                return Optional.ofNullable(clazz.cast(this.eventSummary()));
            }
            case "eventTime": {
                return Optional.ofNullable(clazz.cast(this.eventTime()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "processingStatus": {
                return Optional.ofNullable(clazz.cast(this.processingStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("eventSummary", EVENT_SUMMARY_FIELD);
        map.put("eventTime", EVENT_TIME_FIELD);
        map.put("id", ID_FIELD);
        map.put("processingStatus", PROCESSING_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LineageEventSummary, T> g) {
        return obj -> g.apply((LineageEventSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String domainId;
        private EventSummary eventSummary;
        private Instant eventTime;
        private String id;
        private String processingStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageEventSummary model) {
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.domainId(model.domainId);
            this.eventSummary(model.eventSummary);
            this.eventTime(model.eventTime);
            this.id(model.id);
            this.processingStatus(model.processingStatus);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final EventSummary.Builder getEventSummary() {
            return this.eventSummary != null ? this.eventSummary.toBuilder() : null;
        }

        public final void setEventSummary(EventSummary.BuilderImpl eventSummary) {
            this.eventSummary = eventSummary != null ? eventSummary.build() : null;
        }

        @Override
        public final Builder eventSummary(EventSummary eventSummary) {
            this.eventSummary = eventSummary;
            return this;
        }

        public final Instant getEventTime() {
            return this.eventTime;
        }

        public final void setEventTime(Instant eventTime) {
            this.eventTime = eventTime;
        }

        @Override
        public final Builder eventTime(Instant eventTime) {
            this.eventTime = eventTime;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getProcessingStatus() {
            return this.processingStatus;
        }

        public final void setProcessingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
        }

        @Override
        public final Builder processingStatus(String processingStatus) {
            this.processingStatus = processingStatus;
            return this;
        }

        @Override
        public final Builder processingStatus(LineageEventProcessingStatus processingStatus) {
            this.processingStatus(processingStatus == null ? null : processingStatus.toString());
            return this;
        }

        public LineageEventSummary build() {
            return new LineageEventSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineageEventSummary> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder domainId(String var1);

        public Builder eventSummary(EventSummary var1);

        default public Builder eventSummary(Consumer<EventSummary.Builder> eventSummary) {
            return this.eventSummary((EventSummary)((EventSummary.Builder)EventSummary.builder().applyMutation(eventSummary)).build());
        }

        public Builder eventTime(Instant var1);

        public Builder id(String var1);

        public Builder processingStatus(String var1);

        public Builder processingStatus(LineageEventProcessingStatus var1);
    }
}

