/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.TimeSeriesEntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetTimeSeriesDataPointRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, GetTimeSeriesDataPointRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(GetTimeSeriesDataPointRequest.getter(GetTimeSeriesDataPointRequest::domainIdentifier)).setter(GetTimeSeriesDataPointRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityIdentifier").getter(GetTimeSeriesDataPointRequest.getter(GetTimeSeriesDataPointRequest::entityIdentifier)).setter(GetTimeSeriesDataPointRequest.setter(Builder::entityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityType").getter(GetTimeSeriesDataPointRequest.getter(GetTimeSeriesDataPointRequest::entityTypeAsString)).setter(GetTimeSeriesDataPointRequest.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()}).build();
    private static final SdkField<String> FORM_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("formName").getter(GetTimeSeriesDataPointRequest.getter(GetTimeSeriesDataPointRequest::formName)).setter(GetTimeSeriesDataPointRequest.setter(Builder::formName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("formName").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(GetTimeSeriesDataPointRequest.getter(GetTimeSeriesDataPointRequest::identifier)).setter(GetTimeSeriesDataPointRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, FORM_NAME_FIELD, IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetTimeSeriesDataPointRequest.memberNameToFieldInitializer();
    private final String domainIdentifier;
    private final String entityIdentifier;
    private final String entityType;
    private final String formName;
    private final String identifier;

    private GetTimeSeriesDataPointRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.formName = builder.formName;
        this.identifier = builder.identifier;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String entityIdentifier() {
        return this.entityIdentifier;
    }

    public final TimeSeriesEntityType entityType() {
        return TimeSeriesEntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    public final String formName() {
        return this.formName;
    }

    public final String identifier() {
        return this.identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.formName());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTimeSeriesDataPointRequest)) {
            return false;
        }
        GetTimeSeriesDataPointRequest other = (GetTimeSeriesDataPointRequest)((Object)obj);
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.entityIdentifier(), other.entityIdentifier()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString()) && Objects.equals(this.formName(), other.formName()) && Objects.equals(this.identifier(), other.identifier());
    }

    public final String toString() {
        return ToString.builder((String)"GetTimeSeriesDataPointRequest").add("DomainIdentifier", (Object)this.domainIdentifier()).add("EntityIdentifier", (Object)this.entityIdentifier()).add("EntityType", (Object)this.entityTypeAsString()).add("FormName", (Object)this.formName()).add("Identifier", (Object)this.identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "entityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.entityIdentifier()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
            case "formName": {
                return Optional.ofNullable(clazz.cast(this.formName()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("formName", FORM_NAME_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTimeSeriesDataPointRequest, T> g) {
        return obj -> g.apply((GetTimeSeriesDataPointRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private String entityIdentifier;
        private String entityType;
        private String formName;
        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTimeSeriesDataPointRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.entityIdentifier(model.entityIdentifier);
            this.entityType(model.entityType);
            this.formName(model.formName);
            this.identifier(model.identifier);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return this.entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TimeSeriesEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final String getFormName() {
            return this.formName;
        }

        public final void setFormName(String formName) {
            this.formName = formName;
        }

        @Override
        public final Builder formName(String formName) {
            this.formName = formName;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTimeSeriesDataPointRequest build() {
            return new GetTimeSeriesDataPointRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetTimeSeriesDataPointRequest> {
        public Builder domainIdentifier(String var1);

        public Builder entityIdentifier(String var1);

        public Builder entityType(String var1);

        public Builder entityType(TimeSeriesEntityType var1);

        public Builder formName(String var1);

        public Builder identifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

