/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum ResourceTagSource {
    PROJECT("PROJECT"),
    PROJECT_PROFILE("PROJECT_PROFILE"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ResourceTagSource> VALUE_MAP;
    private final String value;

    private ResourceTagSource(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static ResourceTagSource fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<ResourceTagSource> knownValues() {
        EnumSet<ResourceTagSource> knownValues = EnumSet.allOf(ResourceTagSource.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(ResourceTagSource.class, ResourceTagSource::toString);
    }
}

