/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.DataProductRevision;
import software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsRequest;
import software.amazon.awssdk.services.datazone.model.ListDataProductRevisionsResponse;

public class ListDataProductRevisionsIterable
implements SdkIterable<ListDataProductRevisionsResponse> {
    private final DataZoneClient client;
    private final ListDataProductRevisionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListDataProductRevisionsIterable(DataZoneClient client, ListDataProductRevisionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListDataProductRevisionsResponseFetcher();
    }

    public Iterator<ListDataProductRevisionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<DataProductRevision> items() {
        Function<ListDataProductRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListDataProductRevisionsResponseFetcher
    implements SyncPageFetcher<ListDataProductRevisionsResponse> {
        private ListDataProductRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(ListDataProductRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListDataProductRevisionsResponse nextPage(ListDataProductRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListDataProductRevisionsIterable.this.client.listDataProductRevisions(ListDataProductRevisionsIterable.this.firstRequest);
            }
            return ListDataProductRevisionsIterable.this.client.listDataProductRevisions((ListDataProductRevisionsRequest)((Object)ListDataProductRevisionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

