/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.ConnectionStatus;
import software.amazon.awssdk.services.datazone.model.RedshiftCredentials;
import software.amazon.awssdk.services.datazone.model.RedshiftLineageSyncConfigurationOutput;
import software.amazon.awssdk.services.datazone.model.RedshiftStorageProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftPropertiesOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftPropertiesOutput> {
    private static final SdkField<RedshiftCredentials> CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("credentials").getter(RedshiftPropertiesOutput.getter(RedshiftPropertiesOutput::credentials)).setter(RedshiftPropertiesOutput.setter(Builder::credentials)).constructor(RedshiftCredentials::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("databaseName").getter(RedshiftPropertiesOutput.getter(RedshiftPropertiesOutput::databaseName)).setter(RedshiftPropertiesOutput.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<Boolean> IS_PROVISIONED_SECRET_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isProvisionedSecret").getter(RedshiftPropertiesOutput.getter(RedshiftPropertiesOutput::isProvisionedSecret)).setter(RedshiftPropertiesOutput.setter(Builder::isProvisionedSecret)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isProvisionedSecret").build()}).build();
    private static final SdkField<String> JDBC_IAM_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jdbcIamUrl").getter(RedshiftPropertiesOutput.getter(RedshiftPropertiesOutput::jdbcIamUrl)).setter(RedshiftPropertiesOutput.setter(Builder::jdbcIamUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jdbcIamUrl").build()}).build();
    private static final SdkField<String> JDBC_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jdbcUrl").getter(RedshiftPropertiesOutput.getter(RedshiftPropertiesOutput::jdbcUrl)).setter(RedshiftPropertiesOutput.setter(Builder::jdbcUrl)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jdbcUrl").build()}).build();
    private static final SdkField<RedshiftLineageSyncConfigurationOutput> LINEAGE_SYNC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lineageSync").getter(RedshiftPropertiesOutput.getter(RedshiftPropertiesOutput::lineageSync)).setter(RedshiftPropertiesOutput.setter(Builder::lineageSync)).constructor(RedshiftLineageSyncConfigurationOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineageSync").build()}).build();
    private static final SdkField<String> REDSHIFT_TEMP_DIR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("redshiftTempDir").getter(RedshiftPropertiesOutput.getter(RedshiftPropertiesOutput::redshiftTempDir)).setter(RedshiftPropertiesOutput.setter(Builder::redshiftTempDir)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftTempDir").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(RedshiftPropertiesOutput.getter(RedshiftPropertiesOutput::statusAsString)).setter(RedshiftPropertiesOutput.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<RedshiftStorageProperties> STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("storage").getter(RedshiftPropertiesOutput.getter(RedshiftPropertiesOutput::storage)).setter(RedshiftPropertiesOutput.setter(Builder::storage)).constructor(RedshiftStorageProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD, DATABASE_NAME_FIELD, IS_PROVISIONED_SECRET_FIELD, JDBC_IAM_URL_FIELD, JDBC_URL_FIELD, LINEAGE_SYNC_FIELD, REDSHIFT_TEMP_DIR_FIELD, STATUS_FIELD, STORAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftPropertiesOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final RedshiftCredentials credentials;
    private final String databaseName;
    private final Boolean isProvisionedSecret;
    private final String jdbcIamUrl;
    private final String jdbcUrl;
    private final RedshiftLineageSyncConfigurationOutput lineageSync;
    private final String redshiftTempDir;
    private final String status;
    private final RedshiftStorageProperties storage;

    private RedshiftPropertiesOutput(BuilderImpl builder) {
        this.credentials = builder.credentials;
        this.databaseName = builder.databaseName;
        this.isProvisionedSecret = builder.isProvisionedSecret;
        this.jdbcIamUrl = builder.jdbcIamUrl;
        this.jdbcUrl = builder.jdbcUrl;
        this.lineageSync = builder.lineageSync;
        this.redshiftTempDir = builder.redshiftTempDir;
        this.status = builder.status;
        this.storage = builder.storage;
    }

    public final RedshiftCredentials credentials() {
        return this.credentials;
    }

    public final String databaseName() {
        return this.databaseName;
    }

    public final Boolean isProvisionedSecret() {
        return this.isProvisionedSecret;
    }

    public final String jdbcIamUrl() {
        return this.jdbcIamUrl;
    }

    public final String jdbcUrl() {
        return this.jdbcUrl;
    }

    public final RedshiftLineageSyncConfigurationOutput lineageSync() {
        return this.lineageSync;
    }

    public final String redshiftTempDir() {
        return this.redshiftTempDir;
    }

    public final ConnectionStatus status() {
        return ConnectionStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final RedshiftStorageProperties storage() {
        return this.storage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.credentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.isProvisionedSecret());
        hashCode = 31 * hashCode + Objects.hashCode(this.jdbcIamUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.jdbcUrl());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineageSync());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftTempDir());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.storage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftPropertiesOutput)) {
            return false;
        }
        RedshiftPropertiesOutput other = (RedshiftPropertiesOutput)obj;
        return Objects.equals(this.credentials(), other.credentials()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.isProvisionedSecret(), other.isProvisionedSecret()) && Objects.equals(this.jdbcIamUrl(), other.jdbcIamUrl()) && Objects.equals(this.jdbcUrl(), other.jdbcUrl()) && Objects.equals(this.lineageSync(), other.lineageSync()) && Objects.equals(this.redshiftTempDir(), other.redshiftTempDir()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.storage(), other.storage());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftPropertiesOutput").add("Credentials", (Object)(this.credentials() == null ? null : "*** Sensitive Data Redacted ***")).add("DatabaseName", (Object)this.databaseName()).add("IsProvisionedSecret", (Object)this.isProvisionedSecret()).add("JdbcIamUrl", (Object)this.jdbcIamUrl()).add("JdbcUrl", (Object)this.jdbcUrl()).add("LineageSync", (Object)this.lineageSync()).add("RedshiftTempDir", (Object)this.redshiftTempDir()).add("Status", (Object)this.statusAsString()).add("Storage", (Object)this.storage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "credentials": {
                return Optional.ofNullable(clazz.cast(this.credentials()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "isProvisionedSecret": {
                return Optional.ofNullable(clazz.cast(this.isProvisionedSecret()));
            }
            case "jdbcIamUrl": {
                return Optional.ofNullable(clazz.cast(this.jdbcIamUrl()));
            }
            case "jdbcUrl": {
                return Optional.ofNullable(clazz.cast(this.jdbcUrl()));
            }
            case "lineageSync": {
                return Optional.ofNullable(clazz.cast(this.lineageSync()));
            }
            case "redshiftTempDir": {
                return Optional.ofNullable(clazz.cast(this.redshiftTempDir()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "storage": {
                return Optional.ofNullable(clazz.cast(this.storage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("credentials", CREDENTIALS_FIELD);
        map.put("databaseName", DATABASE_NAME_FIELD);
        map.put("isProvisionedSecret", IS_PROVISIONED_SECRET_FIELD);
        map.put("jdbcIamUrl", JDBC_IAM_URL_FIELD);
        map.put("jdbcUrl", JDBC_URL_FIELD);
        map.put("lineageSync", LINEAGE_SYNC_FIELD);
        map.put("redshiftTempDir", REDSHIFT_TEMP_DIR_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("storage", STORAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftPropertiesOutput, T> g) {
        return obj -> g.apply((RedshiftPropertiesOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private RedshiftCredentials credentials;
        private String databaseName;
        private Boolean isProvisionedSecret;
        private String jdbcIamUrl;
        private String jdbcUrl;
        private RedshiftLineageSyncConfigurationOutput lineageSync;
        private String redshiftTempDir;
        private String status;
        private RedshiftStorageProperties storage;

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftPropertiesOutput model) {
            this.credentials(model.credentials);
            this.databaseName(model.databaseName);
            this.isProvisionedSecret(model.isProvisionedSecret);
            this.jdbcIamUrl(model.jdbcIamUrl);
            this.jdbcUrl(model.jdbcUrl);
            this.lineageSync(model.lineageSync);
            this.redshiftTempDir(model.redshiftTempDir);
            this.status(model.status);
            this.storage(model.storage);
        }

        public final RedshiftCredentials.Builder getCredentials() {
            return this.credentials != null ? this.credentials.toBuilder() : null;
        }

        public final void setCredentials(RedshiftCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(RedshiftCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final Boolean getIsProvisionedSecret() {
            return this.isProvisionedSecret;
        }

        public final void setIsProvisionedSecret(Boolean isProvisionedSecret) {
            this.isProvisionedSecret = isProvisionedSecret;
        }

        @Override
        public final Builder isProvisionedSecret(Boolean isProvisionedSecret) {
            this.isProvisionedSecret = isProvisionedSecret;
            return this;
        }

        public final String getJdbcIamUrl() {
            return this.jdbcIamUrl;
        }

        public final void setJdbcIamUrl(String jdbcIamUrl) {
            this.jdbcIamUrl = jdbcIamUrl;
        }

        @Override
        public final Builder jdbcIamUrl(String jdbcIamUrl) {
            this.jdbcIamUrl = jdbcIamUrl;
            return this;
        }

        public final String getJdbcUrl() {
            return this.jdbcUrl;
        }

        public final void setJdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
        }

        @Override
        public final Builder jdbcUrl(String jdbcUrl) {
            this.jdbcUrl = jdbcUrl;
            return this;
        }

        public final RedshiftLineageSyncConfigurationOutput.Builder getLineageSync() {
            return this.lineageSync != null ? this.lineageSync.toBuilder() : null;
        }

        public final void setLineageSync(RedshiftLineageSyncConfigurationOutput.BuilderImpl lineageSync) {
            this.lineageSync = lineageSync != null ? lineageSync.build() : null;
        }

        @Override
        public final Builder lineageSync(RedshiftLineageSyncConfigurationOutput lineageSync) {
            this.lineageSync = lineageSync;
            return this;
        }

        public final String getRedshiftTempDir() {
            return this.redshiftTempDir;
        }

        public final void setRedshiftTempDir(String redshiftTempDir) {
            this.redshiftTempDir = redshiftTempDir;
        }

        @Override
        public final Builder redshiftTempDir(String redshiftTempDir) {
            this.redshiftTempDir = redshiftTempDir;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ConnectionStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final RedshiftStorageProperties.Builder getStorage() {
            return this.storage != null ? this.storage.toBuilder() : null;
        }

        public final void setStorage(RedshiftStorageProperties.BuilderImpl storage) {
            this.storage = storage != null ? storage.build() : null;
        }

        @Override
        public final Builder storage(RedshiftStorageProperties storage) {
            this.storage = storage;
            return this;
        }

        public RedshiftPropertiesOutput build() {
            return new RedshiftPropertiesOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftPropertiesOutput> {
        public Builder credentials(RedshiftCredentials var1);

        default public Builder credentials(Consumer<RedshiftCredentials.Builder> credentials) {
            return this.credentials((RedshiftCredentials)((RedshiftCredentials.Builder)RedshiftCredentials.builder().applyMutation(credentials)).build());
        }

        public Builder databaseName(String var1);

        public Builder isProvisionedSecret(Boolean var1);

        public Builder jdbcIamUrl(String var1);

        public Builder jdbcUrl(String var1);

        public Builder lineageSync(RedshiftLineageSyncConfigurationOutput var1);

        default public Builder lineageSync(Consumer<RedshiftLineageSyncConfigurationOutput.Builder> lineageSync) {
            return this.lineageSync((RedshiftLineageSyncConfigurationOutput)((RedshiftLineageSyncConfigurationOutput.Builder)RedshiftLineageSyncConfigurationOutput.builder().applyMutation(lineageSync)).build());
        }

        public Builder redshiftTempDir(String var1);

        public Builder status(String var1);

        public Builder status(ConnectionStatus var1);

        public Builder storage(RedshiftStorageProperties var1);

        default public Builder storage(Consumer<RedshiftStorageProperties.Builder> storage) {
            return this.storage((RedshiftStorageProperties)((RedshiftStorageProperties.Builder)RedshiftStorageProperties.builder().applyMutation(storage)).build());
        }
    }
}

