/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataSourceRunType {
    PRIORITIZED("PRIORITIZED"),
    SCHEDULED("SCHEDULED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataSourceRunType> VALUE_MAP;
    private final String value;

    private DataSourceRunType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataSourceRunType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataSourceRunType> knownValues() {
        EnumSet<DataSourceRunType> knownValues = EnumSet.allOf(DataSourceRunType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataSourceRunType.class, DataSourceRunType::toString);
    }
}

