/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.EnvironmentSummary;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentsResponse;

public class ListEnvironmentsPublisher
implements SdkPublisher<ListEnvironmentsResponse> {
    private final DataZoneAsyncClient client;
    private final ListEnvironmentsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEnvironmentsPublisher(DataZoneAsyncClient client, ListEnvironmentsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEnvironmentsPublisher(DataZoneAsyncClient client, ListEnvironmentsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEnvironmentsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEnvironmentsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EnvironmentSummary> items() {
        Function<ListEnvironmentsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEnvironmentsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEnvironmentsResponseFetcher
    implements AsyncPageFetcher<ListEnvironmentsResponse> {
        private ListEnvironmentsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEnvironmentsResponse> nextPage(ListEnvironmentsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentsPublisher.this.client.listEnvironments(ListEnvironmentsPublisher.this.firstRequest);
            }
            return ListEnvironmentsPublisher.this.client.listEnvironments((ListEnvironmentsRequest)((Object)ListEnvironmentsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

