/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.GrantedEntity;
import software.amazon.awssdk.services.datazone.model.SubscribedAsset;
import software.amazon.awssdk.services.datazone.model.SubscribedAssetsCopier;
import software.amazon.awssdk.services.datazone.model.SubscriptionGrantOverallStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteSubscriptionGrantResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, DeleteSubscriptionGrantResponse> {
    private static final SdkField<List<SubscribedAsset>> ASSETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assets").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::assets)).setter(DeleteSubscriptionGrantResponse.setter(Builder::assets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubscribedAsset::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::createdAt)).setter(DeleteSubscriptionGrantResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::createdBy)).setter(DeleteSubscriptionGrantResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::domainId)).setter(DeleteSubscriptionGrantResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::environmentId)).setter(DeleteSubscriptionGrantResponse.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<GrantedEntity> GRANTED_ENTITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("grantedEntity").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::grantedEntity)).setter(DeleteSubscriptionGrantResponse.setter(Builder::grantedEntity)).constructor(GrantedEntity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantedEntity").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::id)).setter(DeleteSubscriptionGrantResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::statusAsString)).setter(DeleteSubscriptionGrantResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionId").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::subscriptionId)).setter(DeleteSubscriptionGrantResponse.setter(Builder::subscriptionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionId").build()}).build();
    private static final SdkField<String> SUBSCRIPTION_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("subscriptionTargetId").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::subscriptionTargetId)).setter(DeleteSubscriptionGrantResponse.setter(Builder::subscriptionTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscriptionTargetId").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::updatedAt)).setter(DeleteSubscriptionGrantResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(DeleteSubscriptionGrantResponse.getter(DeleteSubscriptionGrantResponse::updatedBy)).setter(DeleteSubscriptionGrantResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSETS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DOMAIN_ID_FIELD, ENVIRONMENT_ID_FIELD, GRANTED_ENTITY_FIELD, ID_FIELD, STATUS_FIELD, SUBSCRIPTION_ID_FIELD, SUBSCRIPTION_TARGET_ID_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteSubscriptionGrantResponse.memberNameToFieldInitializer();
    private final List<SubscribedAsset> assets;
    private final Instant createdAt;
    private final String createdBy;
    private final String domainId;
    private final String environmentId;
    private final GrantedEntity grantedEntity;
    private final String id;
    private final String status;
    private final String subscriptionId;
    private final String subscriptionTargetId;
    private final Instant updatedAt;
    private final String updatedBy;

    private DeleteSubscriptionGrantResponse(BuilderImpl builder) {
        super(builder);
        this.assets = builder.assets;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.domainId = builder.domainId;
        this.environmentId = builder.environmentId;
        this.grantedEntity = builder.grantedEntity;
        this.id = builder.id;
        this.status = builder.status;
        this.subscriptionId = builder.subscriptionId;
        this.subscriptionTargetId = builder.subscriptionTargetId;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final boolean hasAssets() {
        return this.assets != null && !(this.assets instanceof SdkAutoConstructList);
    }

    public final List<SubscribedAsset> assets() {
        return this.assets;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final GrantedEntity grantedEntity() {
        return this.grantedEntity;
    }

    public final String id() {
        return this.id;
    }

    public final SubscriptionGrantOverallStatus status() {
        return SubscriptionGrantOverallStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    @Deprecated
    public final String subscriptionId() {
        return this.subscriptionId;
    }

    public final String subscriptionTargetId() {
        return this.subscriptionTargetId;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssets() ? this.assets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantedEntity());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.subscriptionTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteSubscriptionGrantResponse)) {
            return false;
        }
        DeleteSubscriptionGrantResponse other = (DeleteSubscriptionGrantResponse)((Object)obj);
        return this.hasAssets() == other.hasAssets() && Objects.equals(this.assets(), other.assets()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.grantedEntity(), other.grantedEntity()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.subscriptionId(), other.subscriptionId()) && Objects.equals(this.subscriptionTargetId(), other.subscriptionTargetId()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteSubscriptionGrantResponse").add("Assets", this.hasAssets() ? this.assets() : null).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("DomainId", (Object)this.domainId()).add("EnvironmentId", (Object)this.environmentId()).add("GrantedEntity", (Object)this.grantedEntity()).add("Id", (Object)this.id()).add("Status", (Object)this.statusAsString()).add("SubscriptionId", (Object)this.subscriptionId()).add("SubscriptionTargetId", (Object)this.subscriptionTargetId()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assets": {
                return Optional.ofNullable(clazz.cast(this.assets()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "grantedEntity": {
                return Optional.ofNullable(clazz.cast(this.grantedEntity()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "subscriptionId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionId()));
            }
            case "subscriptionTargetId": {
                return Optional.ofNullable(clazz.cast(this.subscriptionTargetId()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assets", ASSETS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("environmentId", ENVIRONMENT_ID_FIELD);
        map.put("grantedEntity", GRANTED_ENTITY_FIELD);
        map.put("id", ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("subscriptionId", SUBSCRIPTION_ID_FIELD);
        map.put("subscriptionTargetId", SUBSCRIPTION_TARGET_ID_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteSubscriptionGrantResponse, T> g) {
        return obj -> g.apply((DeleteSubscriptionGrantResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private List<SubscribedAsset> assets = DefaultSdkAutoConstructList.getInstance();
        private Instant createdAt;
        private String createdBy;
        private String domainId;
        private String environmentId;
        private GrantedEntity grantedEntity;
        private String id;
        private String status;
        private String subscriptionId;
        private String subscriptionTargetId;
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteSubscriptionGrantResponse model) {
            super(model);
            this.assets(model.assets);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.domainId(model.domainId);
            this.environmentId(model.environmentId);
            this.grantedEntity(model.grantedEntity);
            this.id(model.id);
            this.status(model.status);
            this.subscriptionId(model.subscriptionId);
            this.subscriptionTargetId(model.subscriptionTargetId);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final List<SubscribedAsset.Builder> getAssets() {
            List<SubscribedAsset.Builder> result = SubscribedAssetsCopier.copyToBuilder(this.assets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssets(Collection<SubscribedAsset.BuilderImpl> assets) {
            this.assets = SubscribedAssetsCopier.copyFromBuilder(assets);
        }

        @Override
        public final Builder assets(Collection<SubscribedAsset> assets) {
            this.assets = SubscribedAssetsCopier.copy(assets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(SubscribedAsset ... assets) {
            this.assets(Arrays.asList(assets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assets(Consumer<SubscribedAsset.Builder> ... assets) {
            this.assets(Stream.of(assets).map(c -> (SubscribedAsset)((SubscribedAsset.Builder)SubscribedAsset.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final GrantedEntity.Builder getGrantedEntity() {
            return this.grantedEntity != null ? this.grantedEntity.toBuilder() : null;
        }

        public final void setGrantedEntity(GrantedEntity.BuilderImpl grantedEntity) {
            this.grantedEntity = grantedEntity != null ? grantedEntity.build() : null;
        }

        @Override
        public final Builder grantedEntity(GrantedEntity grantedEntity) {
            this.grantedEntity = grantedEntity;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionGrantOverallStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Deprecated
        public final String getSubscriptionId() {
            return this.subscriptionId;
        }

        @Deprecated
        public final void setSubscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
        }

        @Override
        @Deprecated
        public final Builder subscriptionId(String subscriptionId) {
            this.subscriptionId = subscriptionId;
            return this;
        }

        public final String getSubscriptionTargetId() {
            return this.subscriptionTargetId;
        }

        public final void setSubscriptionTargetId(String subscriptionTargetId) {
            this.subscriptionTargetId = subscriptionTargetId;
        }

        @Override
        public final Builder subscriptionTargetId(String subscriptionTargetId) {
            this.subscriptionTargetId = subscriptionTargetId;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public DeleteSubscriptionGrantResponse build() {
            return new DeleteSubscriptionGrantResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteSubscriptionGrantResponse> {
        public Builder assets(Collection<SubscribedAsset> var1);

        public Builder assets(SubscribedAsset ... var1);

        public Builder assets(Consumer<SubscribedAsset.Builder> ... var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder domainId(String var1);

        public Builder environmentId(String var1);

        public Builder grantedEntity(GrantedEntity var1);

        default public Builder grantedEntity(Consumer<GrantedEntity.Builder> grantedEntity) {
            return this.grantedEntity((GrantedEntity)((GrantedEntity.Builder)GrantedEntity.builder().applyMutation(grantedEntity)).build());
        }

        public Builder id(String var1);

        public Builder status(String var1);

        public Builder status(SubscriptionGrantOverallStatus var1);

        @Deprecated
        public Builder subscriptionId(String var1);

        public Builder subscriptionTargetId(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

