/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.EnvironmentActionSummary;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsRequest;
import software.amazon.awssdk.services.datazone.model.ListEnvironmentActionsResponse;

public class ListEnvironmentActionsIterable
implements SdkIterable<ListEnvironmentActionsResponse> {
    private final DataZoneClient client;
    private final ListEnvironmentActionsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListEnvironmentActionsIterable(DataZoneClient client, ListEnvironmentActionsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListEnvironmentActionsResponseFetcher();
    }

    public Iterator<ListEnvironmentActionsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<EnvironmentActionSummary> items() {
        Function<ListEnvironmentActionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListEnvironmentActionsResponseFetcher
    implements SyncPageFetcher<ListEnvironmentActionsResponse> {
        private ListEnvironmentActionsResponseFetcher() {
        }

        public boolean hasNextPage(ListEnvironmentActionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListEnvironmentActionsResponse nextPage(ListEnvironmentActionsResponse previousPage) {
            if (previousPage == null) {
                return ListEnvironmentActionsIterable.this.client.listEnvironmentActions(ListEnvironmentActionsIterable.this.firstRequest);
            }
            return ListEnvironmentActionsIterable.this.client.listEnvironmentActions((ListEnvironmentActionsRequest)((Object)ListEnvironmentActionsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

