/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.EnvironmentConfiguration;
import software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationsListCopier;
import software.amazon.awssdk.services.datazone.model.ProjectResourceTagParametersCopier;
import software.amazon.awssdk.services.datazone.model.ResourceTagParameter;
import software.amazon.awssdk.services.datazone.model.Status;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetProjectProfileResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetProjectProfileResponse> {
    private static final SdkField<Boolean> ALLOW_CUSTOM_PROJECT_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("allowCustomProjectResourceTags").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::allowCustomProjectResourceTags)).setter(GetProjectProfileResponse.setter(Builder::allowCustomProjectResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowCustomProjectResourceTags").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::createdAt)).setter(GetProjectProfileResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::createdBy)).setter(GetProjectProfileResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::description)).setter(GetProjectProfileResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::domainId)).setter(GetProjectProfileResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> DOMAIN_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainUnitId").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::domainUnitId)).setter(GetProjectProfileResponse.setter(Builder::domainUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitId").build()}).build();
    private static final SdkField<List<EnvironmentConfiguration>> ENVIRONMENT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("environmentConfigurations").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::environmentConfigurations)).setter(GetProjectProfileResponse.setter(Builder::environmentConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::id)).setter(GetProjectProfileResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::lastUpdatedAt)).setter(GetProjectProfileResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::name)).setter(GetProjectProfileResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<List<ResourceTagParameter>> PROJECT_RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("projectResourceTags").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::projectResourceTags)).setter(GetProjectProfileResponse.setter(Builder::projectResourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectResourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTagParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROJECT_RESOURCE_TAGS_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectResourceTagsDescription").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::projectResourceTagsDescription)).setter(GetProjectProfileResponse.setter(Builder::projectResourceTagsDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectResourceTagsDescription").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetProjectProfileResponse.getter(GetProjectProfileResponse::statusAsString)).setter(GetProjectProfileResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALLOW_CUSTOM_PROJECT_RESOURCE_TAGS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, DESCRIPTION_FIELD, DOMAIN_ID_FIELD, DOMAIN_UNIT_ID_FIELD, ENVIRONMENT_CONFIGURATIONS_FIELD, ID_FIELD, LAST_UPDATED_AT_FIELD, NAME_FIELD, PROJECT_RESOURCE_TAGS_FIELD, PROJECT_RESOURCE_TAGS_DESCRIPTION_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetProjectProfileResponse.memberNameToFieldInitializer();
    private final Boolean allowCustomProjectResourceTags;
    private final Instant createdAt;
    private final String createdBy;
    private final String description;
    private final String domainId;
    private final String domainUnitId;
    private final List<EnvironmentConfiguration> environmentConfigurations;
    private final String id;
    private final Instant lastUpdatedAt;
    private final String name;
    private final List<ResourceTagParameter> projectResourceTags;
    private final String projectResourceTagsDescription;
    private final String status;

    private GetProjectProfileResponse(BuilderImpl builder) {
        super(builder);
        this.allowCustomProjectResourceTags = builder.allowCustomProjectResourceTags;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.description = builder.description;
        this.domainId = builder.domainId;
        this.domainUnitId = builder.domainUnitId;
        this.environmentConfigurations = builder.environmentConfigurations;
        this.id = builder.id;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.name = builder.name;
        this.projectResourceTags = builder.projectResourceTags;
        this.projectResourceTagsDescription = builder.projectResourceTagsDescription;
        this.status = builder.status;
    }

    public final Boolean allowCustomProjectResourceTags() {
        return this.allowCustomProjectResourceTags;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String description() {
        return this.description;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String domainUnitId() {
        return this.domainUnitId;
    }

    public final boolean hasEnvironmentConfigurations() {
        return this.environmentConfigurations != null && !(this.environmentConfigurations instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentConfiguration> environmentConfigurations() {
        return this.environmentConfigurations;
    }

    public final String id() {
        return this.id;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String name() {
        return this.name;
    }

    public final boolean hasProjectResourceTags() {
        return this.projectResourceTags != null && !(this.projectResourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTagParameter> projectResourceTags() {
        return this.projectResourceTags;
    }

    public final String projectResourceTagsDescription() {
        return this.projectResourceTagsDescription;
    }

    public final Status status() {
        return Status.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.allowCustomProjectResourceTags());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentConfigurations() ? this.environmentConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProjectResourceTags() ? this.projectResourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.projectResourceTagsDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetProjectProfileResponse)) {
            return false;
        }
        GetProjectProfileResponse other = (GetProjectProfileResponse)((Object)obj);
        return Objects.equals(this.allowCustomProjectResourceTags(), other.allowCustomProjectResourceTags()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.domainUnitId(), other.domainUnitId()) && this.hasEnvironmentConfigurations() == other.hasEnvironmentConfigurations() && Objects.equals(this.environmentConfigurations(), other.environmentConfigurations()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.name(), other.name()) && this.hasProjectResourceTags() == other.hasProjectResourceTags() && Objects.equals(this.projectResourceTags(), other.projectResourceTags()) && Objects.equals(this.projectResourceTagsDescription(), other.projectResourceTagsDescription()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"GetProjectProfileResponse").add("AllowCustomProjectResourceTags", (Object)this.allowCustomProjectResourceTags()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("DomainUnitId", (Object)this.domainUnitId()).add("EnvironmentConfigurations", this.hasEnvironmentConfigurations() ? this.environmentConfigurations() : null).add("Id", (Object)this.id()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ProjectResourceTags", this.hasProjectResourceTags() ? this.projectResourceTags() : null).add("ProjectResourceTagsDescription", (Object)(this.projectResourceTagsDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "allowCustomProjectResourceTags": {
                return Optional.ofNullable(clazz.cast(this.allowCustomProjectResourceTags()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "domainUnitId": {
                return Optional.ofNullable(clazz.cast(this.domainUnitId()));
            }
            case "environmentConfigurations": {
                return Optional.ofNullable(clazz.cast(this.environmentConfigurations()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "projectResourceTags": {
                return Optional.ofNullable(clazz.cast(this.projectResourceTags()));
            }
            case "projectResourceTagsDescription": {
                return Optional.ofNullable(clazz.cast(this.projectResourceTagsDescription()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("allowCustomProjectResourceTags", ALLOW_CUSTOM_PROJECT_RESOURCE_TAGS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("domainUnitId", DOMAIN_UNIT_ID_FIELD);
        map.put("environmentConfigurations", ENVIRONMENT_CONFIGURATIONS_FIELD);
        map.put("id", ID_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectResourceTags", PROJECT_RESOURCE_TAGS_FIELD);
        map.put("projectResourceTagsDescription", PROJECT_RESOURCE_TAGS_DESCRIPTION_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetProjectProfileResponse, T> g) {
        return obj -> g.apply((GetProjectProfileResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Boolean allowCustomProjectResourceTags;
        private Instant createdAt;
        private String createdBy;
        private String description;
        private String domainId;
        private String domainUnitId;
        private List<EnvironmentConfiguration> environmentConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private Instant lastUpdatedAt;
        private String name;
        private List<ResourceTagParameter> projectResourceTags = DefaultSdkAutoConstructList.getInstance();
        private String projectResourceTagsDescription;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(GetProjectProfileResponse model) {
            super(model);
            this.allowCustomProjectResourceTags(model.allowCustomProjectResourceTags);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.description(model.description);
            this.domainId(model.domainId);
            this.domainUnitId(model.domainUnitId);
            this.environmentConfigurations(model.environmentConfigurations);
            this.id(model.id);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.name(model.name);
            this.projectResourceTags(model.projectResourceTags);
            this.projectResourceTagsDescription(model.projectResourceTagsDescription);
            this.status(model.status);
        }

        public final Boolean getAllowCustomProjectResourceTags() {
            return this.allowCustomProjectResourceTags;
        }

        public final void setAllowCustomProjectResourceTags(Boolean allowCustomProjectResourceTags) {
            this.allowCustomProjectResourceTags = allowCustomProjectResourceTags;
        }

        @Override
        public final Builder allowCustomProjectResourceTags(Boolean allowCustomProjectResourceTags) {
            this.allowCustomProjectResourceTags = allowCustomProjectResourceTags;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getDomainUnitId() {
            return this.domainUnitId;
        }

        public final void setDomainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
        }

        @Override
        public final Builder domainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        public final List<EnvironmentConfiguration.Builder> getEnvironmentConfigurations() {
            List<EnvironmentConfiguration.Builder> result = EnvironmentConfigurationsListCopier.copyToBuilder(this.environmentConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEnvironmentConfigurations(Collection<EnvironmentConfiguration.BuilderImpl> environmentConfigurations) {
            this.environmentConfigurations = EnvironmentConfigurationsListCopier.copyFromBuilder(environmentConfigurations);
        }

        @Override
        public final Builder environmentConfigurations(Collection<EnvironmentConfiguration> environmentConfigurations) {
            this.environmentConfigurations = EnvironmentConfigurationsListCopier.copy(environmentConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentConfigurations(EnvironmentConfiguration ... environmentConfigurations) {
            this.environmentConfigurations(Arrays.asList(environmentConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder environmentConfigurations(Consumer<EnvironmentConfiguration.Builder> ... environmentConfigurations) {
            this.environmentConfigurations(Stream.of(environmentConfigurations).map(c -> (EnvironmentConfiguration)((EnvironmentConfiguration.Builder)EnvironmentConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final List<ResourceTagParameter.Builder> getProjectResourceTags() {
            List<ResourceTagParameter.Builder> result = ProjectResourceTagParametersCopier.copyToBuilder(this.projectResourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProjectResourceTags(Collection<ResourceTagParameter.BuilderImpl> projectResourceTags) {
            this.projectResourceTags = ProjectResourceTagParametersCopier.copyFromBuilder(projectResourceTags);
        }

        @Override
        public final Builder projectResourceTags(Collection<ResourceTagParameter> projectResourceTags) {
            this.projectResourceTags = ProjectResourceTagParametersCopier.copy(projectResourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectResourceTags(ResourceTagParameter ... projectResourceTags) {
            this.projectResourceTags(Arrays.asList(projectResourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder projectResourceTags(Consumer<ResourceTagParameter.Builder> ... projectResourceTags) {
            this.projectResourceTags(Stream.of(projectResourceTags).map(c -> (ResourceTagParameter)((ResourceTagParameter.Builder)ResourceTagParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProjectResourceTagsDescription() {
            return this.projectResourceTagsDescription;
        }

        public final void setProjectResourceTagsDescription(String projectResourceTagsDescription) {
            this.projectResourceTagsDescription = projectResourceTagsDescription;
        }

        @Override
        public final Builder projectResourceTagsDescription(String projectResourceTagsDescription) {
            this.projectResourceTagsDescription = projectResourceTagsDescription;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(Status status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public GetProjectProfileResponse build() {
            return new GetProjectProfileResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetProjectProfileResponse> {
        public Builder allowCustomProjectResourceTags(Boolean var1);

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder description(String var1);

        public Builder domainId(String var1);

        public Builder domainUnitId(String var1);

        public Builder environmentConfigurations(Collection<EnvironmentConfiguration> var1);

        public Builder environmentConfigurations(EnvironmentConfiguration ... var1);

        public Builder environmentConfigurations(Consumer<EnvironmentConfiguration.Builder> ... var1);

        public Builder id(String var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder name(String var1);

        public Builder projectResourceTags(Collection<ResourceTagParameter> var1);

        public Builder projectResourceTags(ResourceTagParameter ... var1);

        public Builder projectResourceTags(Consumer<ResourceTagParameter.Builder> ... var1);

        public Builder projectResourceTagsDescription(String var1);

        public Builder status(String var1);

        public Builder status(Status var1);
    }
}

