/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationUserParameter;
import software.amazon.awssdk.services.datazone.model.EnvironmentConfigurationUserParametersListCopier;
import software.amazon.awssdk.services.datazone.model.EnvironmentDeploymentDetails;
import software.amazon.awssdk.services.datazone.model.GlossaryTermsCopier;
import software.amazon.awssdk.services.datazone.model.UpdateProjectInputResourceTagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateProjectRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, UpdateProjectRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateProjectRequest.getter(UpdateProjectRequest::description)).setter(UpdateProjectRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(UpdateProjectRequest.getter(UpdateProjectRequest::domainIdentifier)).setter(UpdateProjectRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> DOMAIN_UNIT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainUnitId").getter(UpdateProjectRequest.getter(UpdateProjectRequest::domainUnitId)).setter(UpdateProjectRequest.setter(Builder::domainUnitId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainUnitId").build()}).build();
    private static final SdkField<EnvironmentDeploymentDetails> ENVIRONMENT_DEPLOYMENT_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("environmentDeploymentDetails").getter(UpdateProjectRequest.getter(UpdateProjectRequest::environmentDeploymentDetails)).setter(UpdateProjectRequest.setter(Builder::environmentDeploymentDetails)).constructor(EnvironmentDeploymentDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentDeploymentDetails").build()}).build();
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(UpdateProjectRequest.getter(UpdateProjectRequest::glossaryTerms)).setter(UpdateProjectRequest.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateProjectRequest.getter(UpdateProjectRequest::identifier)).setter(UpdateProjectRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateProjectRequest.getter(UpdateProjectRequest::name)).setter(UpdateProjectRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROJECT_PROFILE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectProfileVersion").getter(UpdateProjectRequest.getter(UpdateProjectRequest::projectProfileVersion)).setter(UpdateProjectRequest.setter(Builder::projectProfileVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectProfileVersion").build()}).build();
    private static final SdkField<Map<String, String>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("resourceTags").getter(UpdateProjectRequest.getter(UpdateProjectRequest::resourceTags)).setter(UpdateProjectRequest.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<EnvironmentConfigurationUserParameter>> USER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userParameters").getter(UpdateProjectRequest.getter(UpdateProjectRequest::userParameters)).setter(UpdateProjectRequest.setter(Builder::userParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EnvironmentConfigurationUserParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, DOMAIN_UNIT_ID_FIELD, ENVIRONMENT_DEPLOYMENT_DETAILS_FIELD, GLOSSARY_TERMS_FIELD, IDENTIFIER_FIELD, NAME_FIELD, PROJECT_PROFILE_VERSION_FIELD, RESOURCE_TAGS_FIELD, USER_PARAMETERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateProjectRequest.memberNameToFieldInitializer();
    private final String description;
    private final String domainIdentifier;
    private final String domainUnitId;
    private final EnvironmentDeploymentDetails environmentDeploymentDetails;
    private final List<String> glossaryTerms;
    private final String identifier;
    private final String name;
    private final String projectProfileVersion;
    private final Map<String, String> resourceTags;
    private final List<EnvironmentConfigurationUserParameter> userParameters;

    private UpdateProjectRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.domainUnitId = builder.domainUnitId;
        this.environmentDeploymentDetails = builder.environmentDeploymentDetails;
        this.glossaryTerms = builder.glossaryTerms;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.projectProfileVersion = builder.projectProfileVersion;
        this.resourceTags = builder.resourceTags;
        this.userParameters = builder.userParameters;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String domainUnitId() {
        return this.domainUnitId;
    }

    public final EnvironmentDeploymentDetails environmentDeploymentDetails() {
        return this.environmentDeploymentDetails;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String name() {
        return this.name;
    }

    public final String projectProfileVersion() {
        return this.projectProfileVersion;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> resourceTags() {
        return this.resourceTags;
    }

    public final boolean hasUserParameters() {
        return this.userParameters != null && !(this.userParameters instanceof SdkAutoConstructList);
    }

    public final List<EnvironmentConfigurationUserParameter> userParameters() {
        return this.userParameters;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainUnitId());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentDeploymentDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectProfileVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserParameters() ? this.userParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateProjectRequest)) {
            return false;
        }
        UpdateProjectRequest other = (UpdateProjectRequest)((Object)obj);
        return Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.domainUnitId(), other.domainUnitId()) && Objects.equals(this.environmentDeploymentDetails(), other.environmentDeploymentDetails()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.projectProfileVersion(), other.projectProfileVersion()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags()) && this.hasUserParameters() == other.hasUserParameters() && Objects.equals(this.userParameters(), other.userParameters());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateProjectRequest").add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("DomainUnitId", (Object)this.domainUnitId()).add("EnvironmentDeploymentDetails", (Object)this.environmentDeploymentDetails()).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Identifier", (Object)this.identifier()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ProjectProfileVersion", (Object)this.projectProfileVersion()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).add("UserParameters", this.hasUserParameters() ? this.userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "domainUnitId": {
                return Optional.ofNullable(clazz.cast(this.domainUnitId()));
            }
            case "environmentDeploymentDetails": {
                return Optional.ofNullable(clazz.cast(this.environmentDeploymentDetails()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "projectProfileVersion": {
                return Optional.ofNullable(clazz.cast(this.projectProfileVersion()));
            }
            case "resourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
            case "userParameters": {
                return Optional.ofNullable(clazz.cast(this.userParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("domainUnitId", DOMAIN_UNIT_ID_FIELD);
        map.put("environmentDeploymentDetails", ENVIRONMENT_DEPLOYMENT_DETAILS_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("projectProfileVersion", PROJECT_PROFILE_VERSION_FIELD);
        map.put("resourceTags", RESOURCE_TAGS_FIELD);
        map.put("userParameters", USER_PARAMETERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateProjectRequest, T> g) {
        return obj -> g.apply((UpdateProjectRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String description;
        private String domainIdentifier;
        private String domainUnitId;
        private EnvironmentDeploymentDetails environmentDeploymentDetails;
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String identifier;
        private String name;
        private String projectProfileVersion;
        private Map<String, String> resourceTags = DefaultSdkAutoConstructMap.getInstance();
        private List<EnvironmentConfigurationUserParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateProjectRequest model) {
            super(model);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.domainUnitId(model.domainUnitId);
            this.environmentDeploymentDetails(model.environmentDeploymentDetails);
            this.glossaryTerms(model.glossaryTerms);
            this.identifier(model.identifier);
            this.name(model.name);
            this.projectProfileVersion(model.projectProfileVersion);
            this.resourceTags(model.resourceTags);
            this.userParameters(model.userParameters);
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getDomainUnitId() {
            return this.domainUnitId;
        }

        public final void setDomainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
        }

        @Override
        public final Builder domainUnitId(String domainUnitId) {
            this.domainUnitId = domainUnitId;
            return this;
        }

        public final EnvironmentDeploymentDetails.Builder getEnvironmentDeploymentDetails() {
            return this.environmentDeploymentDetails != null ? this.environmentDeploymentDetails.toBuilder() : null;
        }

        public final void setEnvironmentDeploymentDetails(EnvironmentDeploymentDetails.BuilderImpl environmentDeploymentDetails) {
            this.environmentDeploymentDetails = environmentDeploymentDetails != null ? environmentDeploymentDetails.build() : null;
        }

        @Override
        public final Builder environmentDeploymentDetails(EnvironmentDeploymentDetails environmentDeploymentDetails) {
            this.environmentDeploymentDetails = environmentDeploymentDetails;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectProfileVersion() {
            return this.projectProfileVersion;
        }

        public final void setProjectProfileVersion(String projectProfileVersion) {
            this.projectProfileVersion = projectProfileVersion;
        }

        @Override
        public final Builder projectProfileVersion(String projectProfileVersion) {
            this.projectProfileVersion = projectProfileVersion;
            return this;
        }

        public final Map<String, String> getResourceTags() {
            if (this.resourceTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.resourceTags;
        }

        public final void setResourceTags(Map<String, String> resourceTags) {
            this.resourceTags = UpdateProjectInputResourceTagsMapCopier.copy(resourceTags);
        }

        @Override
        public final Builder resourceTags(Map<String, String> resourceTags) {
            this.resourceTags = UpdateProjectInputResourceTagsMapCopier.copy(resourceTags);
            return this;
        }

        public final List<EnvironmentConfigurationUserParameter.Builder> getUserParameters() {
            List<EnvironmentConfigurationUserParameter.Builder> result = EnvironmentConfigurationUserParametersListCopier.copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<EnvironmentConfigurationUserParameter.BuilderImpl> userParameters) {
            this.userParameters = EnvironmentConfigurationUserParametersListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<EnvironmentConfigurationUserParameter> userParameters) {
            this.userParameters = EnvironmentConfigurationUserParametersListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(EnvironmentConfigurationUserParameter ... userParameters) {
            this.userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<EnvironmentConfigurationUserParameter.Builder> ... userParameters) {
            this.userParameters(Stream.of(userParameters).map(c -> (EnvironmentConfigurationUserParameter)((EnvironmentConfigurationUserParameter.Builder)EnvironmentConfigurationUserParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateProjectRequest build() {
            return new UpdateProjectRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateProjectRequest> {
        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder domainUnitId(String var1);

        public Builder environmentDeploymentDetails(EnvironmentDeploymentDetails var1);

        default public Builder environmentDeploymentDetails(Consumer<EnvironmentDeploymentDetails.Builder> environmentDeploymentDetails) {
            return this.environmentDeploymentDetails((EnvironmentDeploymentDetails)((EnvironmentDeploymentDetails.Builder)EnvironmentDeploymentDetails.builder().applyMutation(environmentDeploymentDetails)).build());
        }

        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder projectProfileVersion(String var1);

        public Builder resourceTags(Map<String, String> var1);

        public Builder userParameters(Collection<EnvironmentConfigurationUserParameter> var1);

        public Builder userParameters(EnvironmentConfigurationUserParameter ... var1);

        public Builder userParameters(Consumer<EnvironmentConfigurationUserParameter.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

