/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointFormOutput;
import software.amazon.awssdk.services.datazone.model.TimeSeriesDataPointFormOutputListCopier;
import software.amazon.awssdk.services.datazone.model.TimeSeriesEntityType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostTimeSeriesDataPointsResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, PostTimeSeriesDataPointsResponse> {
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(PostTimeSeriesDataPointsResponse.getter(PostTimeSeriesDataPointsResponse::domainId)).setter(PostTimeSeriesDataPointsResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(PostTimeSeriesDataPointsResponse.getter(PostTimeSeriesDataPointsResponse::entityId)).setter(PostTimeSeriesDataPointsResponse.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityType").getter(PostTimeSeriesDataPointsResponse.getter(PostTimeSeriesDataPointsResponse::entityTypeAsString)).setter(PostTimeSeriesDataPointsResponse.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()}).build();
    private static final SdkField<List<TimeSeriesDataPointFormOutput>> FORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("forms").getter(PostTimeSeriesDataPointsResponse.getter(PostTimeSeriesDataPointsResponse::forms)).setter(PostTimeSeriesDataPointsResponse.setter(Builder::forms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(TimeSeriesDataPointFormOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_ID_FIELD, ENTITY_ID_FIELD, ENTITY_TYPE_FIELD, FORMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PostTimeSeriesDataPointsResponse.memberNameToFieldInitializer();
    private final String domainId;
    private final String entityId;
    private final String entityType;
    private final List<TimeSeriesDataPointFormOutput> forms;

    private PostTimeSeriesDataPointsResponse(BuilderImpl builder) {
        super(builder);
        this.domainId = builder.domainId;
        this.entityId = builder.entityId;
        this.entityType = builder.entityType;
        this.forms = builder.forms;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final TimeSeriesEntityType entityType() {
        return TimeSeriesEntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    public final boolean hasForms() {
        return this.forms != null && !(this.forms instanceof SdkAutoConstructList);
    }

    public final List<TimeSeriesDataPointFormOutput> forms() {
        return this.forms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasForms() ? this.forms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostTimeSeriesDataPointsResponse)) {
            return false;
        }
        PostTimeSeriesDataPointsResponse other = (PostTimeSeriesDataPointsResponse)((Object)obj);
        return Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString()) && this.hasForms() == other.hasForms() && Objects.equals(this.forms(), other.forms());
    }

    public final String toString() {
        return ToString.builder((String)"PostTimeSeriesDataPointsResponse").add("DomainId", (Object)this.domainId()).add("EntityId", (Object)this.entityId()).add("EntityType", (Object)this.entityTypeAsString()).add("Forms", this.hasForms() ? this.forms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
            case "forms": {
                return Optional.ofNullable(clazz.cast(this.forms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainId", DOMAIN_ID_FIELD);
        map.put("entityId", ENTITY_ID_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("forms", FORMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PostTimeSeriesDataPointsResponse, T> g) {
        return obj -> g.apply((PostTimeSeriesDataPointsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String domainId;
        private String entityId;
        private String entityType;
        private List<TimeSeriesDataPointFormOutput> forms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PostTimeSeriesDataPointsResponse model) {
            super(model);
            this.domainId(model.domainId);
            this.entityId(model.entityId);
            this.entityType(model.entityType);
            this.forms(model.forms);
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(TimeSeriesEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final List<TimeSeriesDataPointFormOutput.Builder> getForms() {
            List<TimeSeriesDataPointFormOutput.Builder> result = TimeSeriesDataPointFormOutputListCopier.copyToBuilder(this.forms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setForms(Collection<TimeSeriesDataPointFormOutput.BuilderImpl> forms) {
            this.forms = TimeSeriesDataPointFormOutputListCopier.copyFromBuilder(forms);
        }

        @Override
        public final Builder forms(Collection<TimeSeriesDataPointFormOutput> forms) {
            this.forms = TimeSeriesDataPointFormOutputListCopier.copy(forms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forms(TimeSeriesDataPointFormOutput ... forms) {
            this.forms(Arrays.asList(forms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder forms(Consumer<TimeSeriesDataPointFormOutput.Builder> ... forms) {
            this.forms(Stream.of(forms).map(c -> (TimeSeriesDataPointFormOutput)((TimeSeriesDataPointFormOutput.Builder)TimeSeriesDataPointFormOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public PostTimeSeriesDataPointsResponse build() {
            return new PostTimeSeriesDataPointsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PostTimeSeriesDataPointsResponse> {
        public Builder domainId(String var1);

        public Builder entityId(String var1);

        public Builder entityType(String var1);

        public Builder entityType(TimeSeriesEntityType var1);

        public Builder forms(Collection<TimeSeriesDataPointFormOutput> var1);

        public Builder forms(TimeSeriesDataPointFormOutput ... var1);

        public Builder forms(Consumer<TimeSeriesDataPointFormOutput.Builder> ... var1);
    }
}

