/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.AccountPoolSummary;
import software.amazon.awssdk.services.datazone.model.ListAccountPoolsRequest;
import software.amazon.awssdk.services.datazone.model.ListAccountPoolsResponse;

public class ListAccountPoolsPublisher
implements SdkPublisher<ListAccountPoolsResponse> {
    private final DataZoneAsyncClient client;
    private final ListAccountPoolsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAccountPoolsPublisher(DataZoneAsyncClient client, ListAccountPoolsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAccountPoolsPublisher(DataZoneAsyncClient client, ListAccountPoolsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAccountPoolsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAccountPoolsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AccountPoolSummary> items() {
        Function<ListAccountPoolsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAccountPoolsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAccountPoolsResponseFetcher
    implements AsyncPageFetcher<ListAccountPoolsResponse> {
        private ListAccountPoolsResponseFetcher() {
        }

        public boolean hasNextPage(ListAccountPoolsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAccountPoolsResponse> nextPage(ListAccountPoolsResponse previousPage) {
            if (previousPage == null) {
                return ListAccountPoolsPublisher.this.client.listAccountPools(ListAccountPoolsPublisher.this.firstRequest);
            }
            return ListAccountPoolsPublisher.this.client.listAccountPools((ListAccountPoolsRequest)((Object)ListAccountPoolsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

