/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneEntityType;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.OwnerProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddEntityOwnerRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, AddEntityOwnerRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(AddEntityOwnerRequest.getter(AddEntityOwnerRequest::clientToken)).setter(AddEntityOwnerRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(AddEntityOwnerRequest.getter(AddEntityOwnerRequest::domainIdentifier)).setter(AddEntityOwnerRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENTITY_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityIdentifier").getter(AddEntityOwnerRequest.getter(AddEntityOwnerRequest::entityIdentifier)).setter(AddEntityOwnerRequest.setter(Builder::entityIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityIdentifier").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityType").getter(AddEntityOwnerRequest.getter(AddEntityOwnerRequest::entityTypeAsString)).setter(AddEntityOwnerRequest.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("entityType").build()}).build();
    private static final SdkField<OwnerProperties> OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("owner").getter(AddEntityOwnerRequest.getter(AddEntityOwnerRequest::owner)).setter(AddEntityOwnerRequest.setter(Builder::owner)).constructor(OwnerProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DOMAIN_IDENTIFIER_FIELD, ENTITY_IDENTIFIER_FIELD, ENTITY_TYPE_FIELD, OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AddEntityOwnerRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String domainIdentifier;
    private final String entityIdentifier;
    private final String entityType;
    private final OwnerProperties owner;

    private AddEntityOwnerRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.domainIdentifier = builder.domainIdentifier;
        this.entityIdentifier = builder.entityIdentifier;
        this.entityType = builder.entityType;
        this.owner = builder.owner;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String entityIdentifier() {
        return this.entityIdentifier;
    }

    public final DataZoneEntityType entityType() {
        return DataZoneEntityType.fromValue(this.entityType);
    }

    public final String entityTypeAsString() {
        return this.entityType;
    }

    public final OwnerProperties owner() {
        return this.owner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.owner());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddEntityOwnerRequest)) {
            return false;
        }
        AddEntityOwnerRequest other = (AddEntityOwnerRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.entityIdentifier(), other.entityIdentifier()) && Objects.equals(this.entityTypeAsString(), other.entityTypeAsString()) && Objects.equals(this.owner(), other.owner());
    }

    public final String toString() {
        return ToString.builder((String)"AddEntityOwnerRequest").add("ClientToken", (Object)this.clientToken()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EntityIdentifier", (Object)this.entityIdentifier()).add("EntityType", (Object)this.entityTypeAsString()).add("Owner", (Object)this.owner()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "entityIdentifier": {
                return Optional.ofNullable(clazz.cast(this.entityIdentifier()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityTypeAsString()));
            }
            case "owner": {
                return Optional.ofNullable(clazz.cast(this.owner()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("entityIdentifier", ENTITY_IDENTIFIER_FIELD);
        map.put("entityType", ENTITY_TYPE_FIELD);
        map.put("owner", OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddEntityOwnerRequest, T> g) {
        return obj -> g.apply((AddEntityOwnerRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String domainIdentifier;
        private String entityIdentifier;
        private String entityType;
        private OwnerProperties owner;

        private BuilderImpl() {
        }

        private BuilderImpl(AddEntityOwnerRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.domainIdentifier(model.domainIdentifier);
            this.entityIdentifier(model.entityIdentifier);
            this.entityType(model.entityType);
            this.owner(model.owner);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEntityIdentifier() {
            return this.entityIdentifier;
        }

        public final void setEntityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
        }

        @Override
        public final Builder entityIdentifier(String entityIdentifier) {
            this.entityIdentifier = entityIdentifier;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        @Override
        public final Builder entityType(DataZoneEntityType entityType) {
            this.entityType(entityType == null ? null : entityType.toString());
            return this;
        }

        public final OwnerProperties.Builder getOwner() {
            return this.owner != null ? this.owner.toBuilder() : null;
        }

        public final void setOwner(OwnerProperties.BuilderImpl owner) {
            this.owner = owner != null ? owner.build() : null;
        }

        @Override
        public final Builder owner(OwnerProperties owner) {
            this.owner = owner;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AddEntityOwnerRequest build() {
            return new AddEntityOwnerRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AddEntityOwnerRequest> {
        public Builder clientToken(String var1);

        public Builder domainIdentifier(String var1);

        public Builder entityIdentifier(String var1);

        public Builder entityType(String var1);

        public Builder entityType(DataZoneEntityType var1);

        public Builder owner(OwnerProperties var1);

        default public Builder owner(Consumer<OwnerProperties.Builder> owner) {
            return this.owner((OwnerProperties)((OwnerProperties.Builder)OwnerProperties.builder().applyMutation(owner)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

