/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration;
import software.amazon.awssdk.services.datazone.model.RelationalFilterConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlueRunConfigurationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlueRunConfigurationOutput> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountId").getter(GlueRunConfigurationOutput.getter(GlueRunConfigurationOutput::accountId)).setter(GlueRunConfigurationOutput.setter(Builder::accountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountId").build()}).build();
    private static final SdkField<Boolean> AUTO_IMPORT_DATA_QUALITY_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("autoImportDataQualityResult").getter(GlueRunConfigurationOutput.getter(GlueRunConfigurationOutput::autoImportDataQualityResult)).setter(GlueRunConfigurationOutput.setter(Builder::autoImportDataQualityResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("autoImportDataQualityResult").build()}).build();
    private static final SdkField<String> CATALOG_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("catalogName").getter(GlueRunConfigurationOutput.getter(GlueRunConfigurationOutput::catalogName)).setter(GlueRunConfigurationOutput.setter(Builder::catalogName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("catalogName").build()}).build();
    private static final SdkField<String> DATA_ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataAccessRole").getter(GlueRunConfigurationOutput.getter(GlueRunConfigurationOutput::dataAccessRole)).setter(GlueRunConfigurationOutput.setter(Builder::dataAccessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessRole").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(GlueRunConfigurationOutput.getter(GlueRunConfigurationOutput::region)).setter(GlueRunConfigurationOutput.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final SdkField<List<RelationalFilterConfiguration>> RELATIONAL_FILTER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relationalFilterConfigurations").getter(GlueRunConfigurationOutput.getter(GlueRunConfigurationOutput::relationalFilterConfigurations)).setter(GlueRunConfigurationOutput.setter(Builder::relationalFilterConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalFilterConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelationalFilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, AUTO_IMPORT_DATA_QUALITY_RESULT_FIELD, CATALOG_NAME_FIELD, DATA_ACCESS_ROLE_FIELD, REGION_FIELD, RELATIONAL_FILTER_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GlueRunConfigurationOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accountId;
    private final Boolean autoImportDataQualityResult;
    private final String catalogName;
    private final String dataAccessRole;
    private final String region;
    private final List<RelationalFilterConfiguration> relationalFilterConfigurations;

    private GlueRunConfigurationOutput(BuilderImpl builder) {
        this.accountId = builder.accountId;
        this.autoImportDataQualityResult = builder.autoImportDataQualityResult;
        this.catalogName = builder.catalogName;
        this.dataAccessRole = builder.dataAccessRole;
        this.region = builder.region;
        this.relationalFilterConfigurations = builder.relationalFilterConfigurations;
    }

    public final String accountId() {
        return this.accountId;
    }

    public final Boolean autoImportDataQualityResult() {
        return this.autoImportDataQualityResult;
    }

    public final String catalogName() {
        return this.catalogName;
    }

    public final String dataAccessRole() {
        return this.dataAccessRole;
    }

    public final String region() {
        return this.region;
    }

    public final boolean hasRelationalFilterConfigurations() {
        return this.relationalFilterConfigurations != null && !(this.relationalFilterConfigurations instanceof SdkAutoConstructList);
    }

    public final List<RelationalFilterConfiguration> relationalFilterConfigurations() {
        return this.relationalFilterConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoImportDataQualityResult());
        hashCode = 31 * hashCode + Objects.hashCode(this.catalogName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelationalFilterConfigurations() ? this.relationalFilterConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueRunConfigurationOutput)) {
            return false;
        }
        GlueRunConfigurationOutput other = (GlueRunConfigurationOutput)obj;
        return Objects.equals(this.accountId(), other.accountId()) && Objects.equals(this.autoImportDataQualityResult(), other.autoImportDataQualityResult()) && Objects.equals(this.catalogName(), other.catalogName()) && Objects.equals(this.dataAccessRole(), other.dataAccessRole()) && Objects.equals(this.region(), other.region()) && this.hasRelationalFilterConfigurations() == other.hasRelationalFilterConfigurations() && Objects.equals(this.relationalFilterConfigurations(), other.relationalFilterConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"GlueRunConfigurationOutput").add("AccountId", (Object)this.accountId()).add("AutoImportDataQualityResult", (Object)this.autoImportDataQualityResult()).add("CatalogName", (Object)this.catalogName()).add("DataAccessRole", (Object)this.dataAccessRole()).add("Region", (Object)this.region()).add("RelationalFilterConfigurations", this.hasRelationalFilterConfigurations() ? this.relationalFilterConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountId": {
                return Optional.ofNullable(clazz.cast(this.accountId()));
            }
            case "autoImportDataQualityResult": {
                return Optional.ofNullable(clazz.cast(this.autoImportDataQualityResult()));
            }
            case "catalogName": {
                return Optional.ofNullable(clazz.cast(this.catalogName()));
            }
            case "dataAccessRole": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRole()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
            case "relationalFilterConfigurations": {
                return Optional.ofNullable(clazz.cast(this.relationalFilterConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("accountId", ACCOUNT_ID_FIELD);
        map.put("autoImportDataQualityResult", AUTO_IMPORT_DATA_QUALITY_RESULT_FIELD);
        map.put("catalogName", CATALOG_NAME_FIELD);
        map.put("dataAccessRole", DATA_ACCESS_ROLE_FIELD);
        map.put("region", REGION_FIELD);
        map.put("relationalFilterConfigurations", RELATIONAL_FILTER_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlueRunConfigurationOutput, T> g) {
        return obj -> g.apply((GlueRunConfigurationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accountId;
        private Boolean autoImportDataQualityResult;
        private String catalogName;
        private String dataAccessRole;
        private String region;
        private List<RelationalFilterConfiguration> relationalFilterConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlueRunConfigurationOutput model) {
            this.accountId(model.accountId);
            this.autoImportDataQualityResult(model.autoImportDataQualityResult);
            this.catalogName(model.catalogName);
            this.dataAccessRole(model.dataAccessRole);
            this.region(model.region);
            this.relationalFilterConfigurations(model.relationalFilterConfigurations);
        }

        public final String getAccountId() {
            return this.accountId;
        }

        public final void setAccountId(String accountId) {
            this.accountId = accountId;
        }

        @Override
        public final Builder accountId(String accountId) {
            this.accountId = accountId;
            return this;
        }

        public final Boolean getAutoImportDataQualityResult() {
            return this.autoImportDataQualityResult;
        }

        public final void setAutoImportDataQualityResult(Boolean autoImportDataQualityResult) {
            this.autoImportDataQualityResult = autoImportDataQualityResult;
        }

        @Override
        public final Builder autoImportDataQualityResult(Boolean autoImportDataQualityResult) {
            this.autoImportDataQualityResult = autoImportDataQualityResult;
            return this;
        }

        public final String getCatalogName() {
            return this.catalogName;
        }

        public final void setCatalogName(String catalogName) {
            this.catalogName = catalogName;
        }

        @Override
        public final Builder catalogName(String catalogName) {
            this.catalogName = catalogName;
            return this;
        }

        public final String getDataAccessRole() {
            return this.dataAccessRole;
        }

        public final void setDataAccessRole(String dataAccessRole) {
            this.dataAccessRole = dataAccessRole;
        }

        @Override
        public final Builder dataAccessRole(String dataAccessRole) {
            this.dataAccessRole = dataAccessRole;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public final List<RelationalFilterConfiguration.Builder> getRelationalFilterConfigurations() {
            List<RelationalFilterConfiguration.Builder> result = RelationalFilterConfigurationsCopier.copyToBuilder(this.relationalFilterConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationalFilterConfigurations(Collection<RelationalFilterConfiguration.BuilderImpl> relationalFilterConfigurations) {
            this.relationalFilterConfigurations = RelationalFilterConfigurationsCopier.copyFromBuilder(relationalFilterConfigurations);
        }

        @Override
        public final Builder relationalFilterConfigurations(Collection<RelationalFilterConfiguration> relationalFilterConfigurations) {
            this.relationalFilterConfigurations = RelationalFilterConfigurationsCopier.copy(relationalFilterConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalFilterConfigurations(RelationalFilterConfiguration ... relationalFilterConfigurations) {
            this.relationalFilterConfigurations(Arrays.asList(relationalFilterConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalFilterConfigurations(Consumer<RelationalFilterConfiguration.Builder> ... relationalFilterConfigurations) {
            this.relationalFilterConfigurations(Stream.of(relationalFilterConfigurations).map(c -> (RelationalFilterConfiguration)((RelationalFilterConfiguration.Builder)RelationalFilterConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GlueRunConfigurationOutput build() {
            return new GlueRunConfigurationOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlueRunConfigurationOutput> {
        public Builder accountId(String var1);

        public Builder autoImportDataQualityResult(Boolean var1);

        public Builder catalogName(String var1);

        public Builder dataAccessRole(String var1);

        public Builder region(String var1);

        public Builder relationalFilterConfigurations(Collection<RelationalFilterConfiguration> var1);

        public Builder relationalFilterConfigurations(RelationalFilterConfiguration ... var1);

        public Builder relationalFilterConfigurations(Consumer<RelationalFilterConfiguration.Builder> ... var1);
    }
}

