/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsRequest;
import software.amazon.awssdk.services.datazone.model.ListSubscriptionRequestsResponse;
import software.amazon.awssdk.services.datazone.model.SubscriptionRequestSummary;

public class ListSubscriptionRequestsIterable
implements SdkIterable<ListSubscriptionRequestsResponse> {
    private final DataZoneClient client;
    private final ListSubscriptionRequestsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListSubscriptionRequestsIterable(DataZoneClient client, ListSubscriptionRequestsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListSubscriptionRequestsResponseFetcher();
    }

    public Iterator<ListSubscriptionRequestsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<SubscriptionRequestSummary> items() {
        Function<ListSubscriptionRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListSubscriptionRequestsResponseFetcher
    implements SyncPageFetcher<ListSubscriptionRequestsResponse> {
        private ListSubscriptionRequestsResponseFetcher() {
        }

        public boolean hasNextPage(ListSubscriptionRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListSubscriptionRequestsResponse nextPage(ListSubscriptionRequestsResponse previousPage) {
            if (previousPage == null) {
                return ListSubscriptionRequestsIterable.this.client.listSubscriptionRequests(ListSubscriptionRequestsIterable.this.firstRequest);
            }
            return ListSubscriptionRequestsIterable.this.client.listSubscriptionRequests((ListSubscriptionRequestsRequest)((Object)ListSubscriptionRequestsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

