/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.LineageEventSummary;
import software.amazon.awssdk.services.datazone.model.ListLineageEventsRequest;
import software.amazon.awssdk.services.datazone.model.ListLineageEventsResponse;

public class ListLineageEventsIterable
implements SdkIterable<ListLineageEventsResponse> {
    private final DataZoneClient client;
    private final ListLineageEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLineageEventsIterable(DataZoneClient client, ListLineageEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLineageEventsResponseFetcher();
    }

    public Iterator<ListLineageEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LineageEventSummary> items() {
        Function<ListLineageEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLineageEventsResponseFetcher
    implements SyncPageFetcher<ListLineageEventsResponse> {
        private ListLineageEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListLineageEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLineageEventsResponse nextPage(ListLineageEventsResponse previousPage) {
            if (previousPage == null) {
                return ListLineageEventsIterable.this.client.listLineageEvents(ListLineageEventsIterable.this.firstRequest);
            }
            return ListLineageEventsIterable.this.client.listLineageEvents((ListLineageEventsRequest)((Object)ListLineageEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

