/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsRequest;
import software.amazon.awssdk.services.datazone.model.ListMetadataGenerationRunsResponse;
import software.amazon.awssdk.services.datazone.model.MetadataGenerationRunItem;

public class ListMetadataGenerationRunsIterable
implements SdkIterable<ListMetadataGenerationRunsResponse> {
    private final DataZoneClient client;
    private final ListMetadataGenerationRunsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListMetadataGenerationRunsIterable(DataZoneClient client, ListMetadataGenerationRunsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListMetadataGenerationRunsResponseFetcher();
    }

    public Iterator<ListMetadataGenerationRunsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<MetadataGenerationRunItem> items() {
        Function<ListMetadataGenerationRunsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListMetadataGenerationRunsResponseFetcher
    implements SyncPageFetcher<ListMetadataGenerationRunsResponse> {
        private ListMetadataGenerationRunsResponseFetcher() {
        }

        public boolean hasNextPage(ListMetadataGenerationRunsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListMetadataGenerationRunsResponse nextPage(ListMetadataGenerationRunsResponse previousPage) {
            if (previousPage == null) {
                return ListMetadataGenerationRunsIterable.this.client.listMetadataGenerationRuns(ListMetadataGenerationRunsIterable.this.firstRequest);
            }
            return ListMetadataGenerationRunsIterable.this.client.listMetadataGenerationRuns((ListMetadataGenerationRunsRequest)((Object)ListMetadataGenerationRunsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

