/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.AssetTypesForRule;
import software.amazon.awssdk.services.datazone.model.ProjectsForRule;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RuleScope
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RuleScope> {
    private static final SdkField<AssetTypesForRule> ASSET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetType").getter(RuleScope.getter(RuleScope::assetType)).setter(RuleScope.setter(Builder::assetType)).constructor(AssetTypesForRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetType").build()}).build();
    private static final SdkField<Boolean> DATA_PRODUCT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("dataProduct").getter(RuleScope.getter(RuleScope::dataProduct)).setter(RuleScope.setter(Builder::dataProduct)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataProduct").build()}).build();
    private static final SdkField<ProjectsForRule> PROJECT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("project").getter(RuleScope.getter(RuleScope::project)).setter(RuleScope.setter(Builder::project)).constructor(ProjectsForRule::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("project").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_TYPE_FIELD, DATA_PRODUCT_FIELD, PROJECT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RuleScope.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AssetTypesForRule assetType;
    private final Boolean dataProduct;
    private final ProjectsForRule project;

    private RuleScope(BuilderImpl builder) {
        this.assetType = builder.assetType;
        this.dataProduct = builder.dataProduct;
        this.project = builder.project;
    }

    public final AssetTypesForRule assetType() {
        return this.assetType;
    }

    public final Boolean dataProduct() {
        return this.dataProduct;
    }

    public final ProjectsForRule project() {
        return this.project;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetType());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataProduct());
        hashCode = 31 * hashCode + Objects.hashCode(this.project());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleScope)) {
            return false;
        }
        RuleScope other = (RuleScope)obj;
        return Objects.equals(this.assetType(), other.assetType()) && Objects.equals(this.dataProduct(), other.dataProduct()) && Objects.equals(this.project(), other.project());
    }

    public final String toString() {
        return ToString.builder((String)"RuleScope").add("AssetType", (Object)this.assetType()).add("DataProduct", (Object)this.dataProduct()).add("Project", (Object)this.project()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetType": {
                return Optional.ofNullable(clazz.cast(this.assetType()));
            }
            case "dataProduct": {
                return Optional.ofNullable(clazz.cast(this.dataProduct()));
            }
            case "project": {
                return Optional.ofNullable(clazz.cast(this.project()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetType", ASSET_TYPE_FIELD);
        map.put("dataProduct", DATA_PRODUCT_FIELD);
        map.put("project", PROJECT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleScope, T> g) {
        return obj -> g.apply((RuleScope)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AssetTypesForRule assetType;
        private Boolean dataProduct;
        private ProjectsForRule project;

        private BuilderImpl() {
        }

        private BuilderImpl(RuleScope model) {
            this.assetType(model.assetType);
            this.dataProduct(model.dataProduct);
            this.project(model.project);
        }

        public final AssetTypesForRule.Builder getAssetType() {
            return this.assetType != null ? this.assetType.toBuilder() : null;
        }

        public final void setAssetType(AssetTypesForRule.BuilderImpl assetType) {
            this.assetType = assetType != null ? assetType.build() : null;
        }

        @Override
        public final Builder assetType(AssetTypesForRule assetType) {
            this.assetType = assetType;
            return this;
        }

        public final Boolean getDataProduct() {
            return this.dataProduct;
        }

        public final void setDataProduct(Boolean dataProduct) {
            this.dataProduct = dataProduct;
        }

        @Override
        public final Builder dataProduct(Boolean dataProduct) {
            this.dataProduct = dataProduct;
            return this;
        }

        public final ProjectsForRule.Builder getProject() {
            return this.project != null ? this.project.toBuilder() : null;
        }

        public final void setProject(ProjectsForRule.BuilderImpl project) {
            this.project = project != null ? project.build() : null;
        }

        @Override
        public final Builder project(ProjectsForRule project) {
            this.project = project;
            return this;
        }

        public RuleScope build() {
            return new RuleScope(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RuleScope> {
        public Builder assetType(AssetTypesForRule var1);

        default public Builder assetType(Consumer<AssetTypesForRule.Builder> assetType) {
            return this.assetType((AssetTypesForRule)((AssetTypesForRule.Builder)AssetTypesForRule.builder().applyMutation(assetType)).build());
        }

        public Builder dataProduct(Boolean var1);

        public Builder project(ProjectsForRule var1);

        default public Builder project(Consumer<ProjectsForRule.Builder> project) {
            return this.project((ProjectsForRule)((ProjectsForRule.Builder)ProjectsForRule.builder().applyMutation(project)).build());
        }
    }
}

