/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AuthenticationConfigurationPatch;
import software.amazon.awssdk.services.datazone.model.ConnectionPropertiesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlueConnectionPatch
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlueConnectionPatch> {
    private static final SdkField<AuthenticationConfigurationPatch> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authenticationConfiguration").getter(GlueConnectionPatch.getter(GlueConnectionPatch::authenticationConfiguration)).setter(GlueConnectionPatch.setter(Builder::authenticationConfiguration)).constructor(AuthenticationConfigurationPatch::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("connectionProperties").getter(GlueConnectionPatch.getter(GlueConnectionPatch::connectionProperties)).setter(GlueConnectionPatch.setter(Builder::connectionProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GlueConnectionPatch.getter(GlueConnectionPatch::description)).setter(GlueConnectionPatch.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHENTICATION_CONFIGURATION_FIELD, CONNECTION_PROPERTIES_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GlueConnectionPatch.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final AuthenticationConfigurationPatch authenticationConfiguration;
    private final Map<String, String> connectionProperties;
    private final String description;

    private GlueConnectionPatch(BuilderImpl builder) {
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.connectionProperties = builder.connectionProperties;
        this.description = builder.description;
    }

    public final AuthenticationConfigurationPatch authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public final boolean hasConnectionProperties() {
        return this.connectionProperties != null && !(this.connectionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> connectionProperties() {
        return this.connectionProperties;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionProperties() ? this.connectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueConnectionPatch)) {
            return false;
        }
        GlueConnectionPatch other = (GlueConnectionPatch)obj;
        return Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration()) && this.hasConnectionProperties() == other.hasConnectionProperties() && Objects.equals(this.connectionProperties(), other.connectionProperties()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"GlueConnectionPatch").add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).add("ConnectionProperties", this.hasConnectionProperties() ? this.connectionProperties() : null).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "authenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
            case "connectionProperties": {
                return Optional.ofNullable(clazz.cast(this.connectionProperties()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("authenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
        map.put("connectionProperties", CONNECTION_PROPERTIES_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GlueConnectionPatch, T> g) {
        return obj -> g.apply((GlueConnectionPatch)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AuthenticationConfigurationPatch authenticationConfiguration;
        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(GlueConnectionPatch model) {
            this.authenticationConfiguration(model.authenticationConfiguration);
            this.connectionProperties(model.connectionProperties);
            this.description(model.description);
        }

        public final AuthenticationConfigurationPatch.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfigurationPatch.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfigurationPatch authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (this.connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        public final Builder connectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public GlueConnectionPatch build() {
            return new GlueConnectionPatch(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlueConnectionPatch> {
        public Builder authenticationConfiguration(AuthenticationConfigurationPatch var1);

        default public Builder authenticationConfiguration(Consumer<AuthenticationConfigurationPatch.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((AuthenticationConfigurationPatch)((AuthenticationConfigurationPatch.Builder)AuthenticationConfigurationPatch.builder().applyMutation(authenticationConfiguration)).build());
        }

        public Builder connectionProperties(Map<String, String> var1);

        public Builder description(String var1);
    }
}

