/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.FailureCause;
import software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateSubscriptionGrantStatusRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, UpdateSubscriptionGrantStatusRequest> {
    private static final SdkField<String> ASSET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetIdentifier").getter(UpdateSubscriptionGrantStatusRequest.getter(UpdateSubscriptionGrantStatusRequest::assetIdentifier)).setter(UpdateSubscriptionGrantStatusRequest.setter(Builder::assetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetIdentifier").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(UpdateSubscriptionGrantStatusRequest.getter(UpdateSubscriptionGrantStatusRequest::domainIdentifier)).setter(UpdateSubscriptionGrantStatusRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<FailureCause> FAILURE_CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("failureCause").getter(UpdateSubscriptionGrantStatusRequest.getter(UpdateSubscriptionGrantStatusRequest::failureCause)).setter(UpdateSubscriptionGrantStatusRequest.setter(Builder::failureCause)).constructor(FailureCause::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCause").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateSubscriptionGrantStatusRequest.getter(UpdateSubscriptionGrantStatusRequest::identifier)).setter(UpdateSubscriptionGrantStatusRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(UpdateSubscriptionGrantStatusRequest.getter(UpdateSubscriptionGrantStatusRequest::statusAsString)).setter(UpdateSubscriptionGrantStatusRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetName").getter(UpdateSubscriptionGrantStatusRequest.getter(UpdateSubscriptionGrantStatusRequest::targetName)).setter(UpdateSubscriptionGrantStatusRequest.setter(Builder::targetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_IDENTIFIER_FIELD, DOMAIN_IDENTIFIER_FIELD, FAILURE_CAUSE_FIELD, IDENTIFIER_FIELD, STATUS_FIELD, TARGET_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateSubscriptionGrantStatusRequest.memberNameToFieldInitializer();
    private final String assetIdentifier;
    private final String domainIdentifier;
    private final FailureCause failureCause;
    private final String identifier;
    private final String status;
    private final String targetName;

    private UpdateSubscriptionGrantStatusRequest(BuilderImpl builder) {
        super(builder);
        this.assetIdentifier = builder.assetIdentifier;
        this.domainIdentifier = builder.domainIdentifier;
        this.failureCause = builder.failureCause;
        this.identifier = builder.identifier;
        this.status = builder.status;
        this.targetName = builder.targetName;
    }

    public final String assetIdentifier() {
        return this.assetIdentifier;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final FailureCause failureCause() {
        return this.failureCause;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final SubscriptionGrantStatus status() {
        return SubscriptionGrantStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String targetName() {
        return this.targetName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCause());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateSubscriptionGrantStatusRequest)) {
            return false;
        }
        UpdateSubscriptionGrantStatusRequest other = (UpdateSubscriptionGrantStatusRequest)((Object)obj);
        return Objects.equals(this.assetIdentifier(), other.assetIdentifier()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.failureCause(), other.failureCause()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetName(), other.targetName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateSubscriptionGrantStatusRequest").add("AssetIdentifier", (Object)this.assetIdentifier()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("FailureCause", (Object)this.failureCause()).add("Identifier", (Object)this.identifier()).add("Status", (Object)this.statusAsString()).add("TargetName", (Object)this.targetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.assetIdentifier()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "failureCause": {
                return Optional.ofNullable(clazz.cast(this.failureCause()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "targetName": {
                return Optional.ofNullable(clazz.cast(this.targetName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetIdentifier", ASSET_IDENTIFIER_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("failureCause", FAILURE_CAUSE_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("targetName", TARGET_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateSubscriptionGrantStatusRequest, T> g) {
        return obj -> g.apply((UpdateSubscriptionGrantStatusRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String assetIdentifier;
        private String domainIdentifier;
        private FailureCause failureCause;
        private String identifier;
        private String status;
        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateSubscriptionGrantStatusRequest model) {
            super(model);
            this.assetIdentifier(model.assetIdentifier);
            this.domainIdentifier(model.domainIdentifier);
            this.failureCause(model.failureCause);
            this.identifier(model.identifier);
            this.status(model.status);
            this.targetName(model.targetName);
        }

        public final String getAssetIdentifier() {
            return this.assetIdentifier;
        }

        public final void setAssetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
        }

        @Override
        public final Builder assetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final FailureCause.Builder getFailureCause() {
            return this.failureCause != null ? this.failureCause.toBuilder() : null;
        }

        public final void setFailureCause(FailureCause.BuilderImpl failureCause) {
            this.failureCause = failureCause != null ? failureCause.build() : null;
        }

        @Override
        public final Builder failureCause(FailureCause failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionGrantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetName() {
            return this.targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateSubscriptionGrantStatusRequest build() {
            return new UpdateSubscriptionGrantStatusRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateSubscriptionGrantStatusRequest> {
        public Builder assetIdentifier(String var1);

        public Builder domainIdentifier(String var1);

        public Builder failureCause(FailureCause var1);

        default public Builder failureCause(Consumer<FailureCause.Builder> failureCause) {
            return this.failureCause((FailureCause)((FailureCause.Builder)FailureCause.builder().applyMutation(failureCause)).build());
        }

        public Builder identifier(String var1);

        public Builder status(String var1);

        public Builder status(SubscriptionGrantStatus var1);

        public Builder targetName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

