/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.RedshiftCredentialConfiguration;
import software.amazon.awssdk.services.datazone.model.RedshiftStorage;
import software.amazon.awssdk.services.datazone.model.RelationalFilterConfiguration;
import software.amazon.awssdk.services.datazone.model.RelationalFilterConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RedshiftRunConfigurationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RedshiftRunConfigurationInput> {
    private static final SdkField<String> DATA_ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataAccessRole").getter(RedshiftRunConfigurationInput.getter(RedshiftRunConfigurationInput::dataAccessRole)).setter(RedshiftRunConfigurationInput.setter(Builder::dataAccessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAccessRole").build()}).build();
    private static final SdkField<RedshiftCredentialConfiguration> REDSHIFT_CREDENTIAL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redshiftCredentialConfiguration").getter(RedshiftRunConfigurationInput.getter(RedshiftRunConfigurationInput::redshiftCredentialConfiguration)).setter(RedshiftRunConfigurationInput.setter(Builder::redshiftCredentialConfiguration)).constructor(RedshiftCredentialConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftCredentialConfiguration").build()}).build();
    private static final SdkField<RedshiftStorage> REDSHIFT_STORAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("redshiftStorage").getter(RedshiftRunConfigurationInput.getter(RedshiftRunConfigurationInput::redshiftStorage)).setter(RedshiftRunConfigurationInput.setter(Builder::redshiftStorage)).constructor(RedshiftStorage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("redshiftStorage").build()}).build();
    private static final SdkField<List<RelationalFilterConfiguration>> RELATIONAL_FILTER_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("relationalFilterConfigurations").getter(RedshiftRunConfigurationInput.getter(RedshiftRunConfigurationInput::relationalFilterConfigurations)).setter(RedshiftRunConfigurationInput.setter(Builder::relationalFilterConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("relationalFilterConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RelationalFilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DATA_ACCESS_ROLE_FIELD, REDSHIFT_CREDENTIAL_CONFIGURATION_FIELD, REDSHIFT_STORAGE_FIELD, RELATIONAL_FILTER_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RedshiftRunConfigurationInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String dataAccessRole;
    private final RedshiftCredentialConfiguration redshiftCredentialConfiguration;
    private final RedshiftStorage redshiftStorage;
    private final List<RelationalFilterConfiguration> relationalFilterConfigurations;

    private RedshiftRunConfigurationInput(BuilderImpl builder) {
        this.dataAccessRole = builder.dataAccessRole;
        this.redshiftCredentialConfiguration = builder.redshiftCredentialConfiguration;
        this.redshiftStorage = builder.redshiftStorage;
        this.relationalFilterConfigurations = builder.relationalFilterConfigurations;
    }

    public final String dataAccessRole() {
        return this.dataAccessRole;
    }

    public final RedshiftCredentialConfiguration redshiftCredentialConfiguration() {
        return this.redshiftCredentialConfiguration;
    }

    public final RedshiftStorage redshiftStorage() {
        return this.redshiftStorage;
    }

    public final boolean hasRelationalFilterConfigurations() {
        return this.relationalFilterConfigurations != null && !(this.relationalFilterConfigurations instanceof SdkAutoConstructList);
    }

    public final List<RelationalFilterConfiguration> relationalFilterConfigurations() {
        return this.relationalFilterConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAccessRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftCredentialConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.redshiftStorage());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRelationalFilterConfigurations() ? this.relationalFilterConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RedshiftRunConfigurationInput)) {
            return false;
        }
        RedshiftRunConfigurationInput other = (RedshiftRunConfigurationInput)obj;
        return Objects.equals(this.dataAccessRole(), other.dataAccessRole()) && Objects.equals(this.redshiftCredentialConfiguration(), other.redshiftCredentialConfiguration()) && Objects.equals(this.redshiftStorage(), other.redshiftStorage()) && this.hasRelationalFilterConfigurations() == other.hasRelationalFilterConfigurations() && Objects.equals(this.relationalFilterConfigurations(), other.relationalFilterConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"RedshiftRunConfigurationInput").add("DataAccessRole", (Object)this.dataAccessRole()).add("RedshiftCredentialConfiguration", (Object)this.redshiftCredentialConfiguration()).add("RedshiftStorage", (Object)this.redshiftStorage()).add("RelationalFilterConfigurations", this.hasRelationalFilterConfigurations() ? this.relationalFilterConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "dataAccessRole": {
                return Optional.ofNullable(clazz.cast(this.dataAccessRole()));
            }
            case "redshiftCredentialConfiguration": {
                return Optional.ofNullable(clazz.cast(this.redshiftCredentialConfiguration()));
            }
            case "redshiftStorage": {
                return Optional.ofNullable(clazz.cast(this.redshiftStorage()));
            }
            case "relationalFilterConfigurations": {
                return Optional.ofNullable(clazz.cast(this.relationalFilterConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("dataAccessRole", DATA_ACCESS_ROLE_FIELD);
        map.put("redshiftCredentialConfiguration", REDSHIFT_CREDENTIAL_CONFIGURATION_FIELD);
        map.put("redshiftStorage", REDSHIFT_STORAGE_FIELD);
        map.put("relationalFilterConfigurations", RELATIONAL_FILTER_CONFIGURATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RedshiftRunConfigurationInput, T> g) {
        return obj -> g.apply((RedshiftRunConfigurationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String dataAccessRole;
        private RedshiftCredentialConfiguration redshiftCredentialConfiguration;
        private RedshiftStorage redshiftStorage;
        private List<RelationalFilterConfiguration> relationalFilterConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RedshiftRunConfigurationInput model) {
            this.dataAccessRole(model.dataAccessRole);
            this.redshiftCredentialConfiguration(model.redshiftCredentialConfiguration);
            this.redshiftStorage(model.redshiftStorage);
            this.relationalFilterConfigurations(model.relationalFilterConfigurations);
        }

        public final String getDataAccessRole() {
            return this.dataAccessRole;
        }

        public final void setDataAccessRole(String dataAccessRole) {
            this.dataAccessRole = dataAccessRole;
        }

        @Override
        public final Builder dataAccessRole(String dataAccessRole) {
            this.dataAccessRole = dataAccessRole;
            return this;
        }

        public final RedshiftCredentialConfiguration.Builder getRedshiftCredentialConfiguration() {
            return this.redshiftCredentialConfiguration != null ? this.redshiftCredentialConfiguration.toBuilder() : null;
        }

        public final void setRedshiftCredentialConfiguration(RedshiftCredentialConfiguration.BuilderImpl redshiftCredentialConfiguration) {
            this.redshiftCredentialConfiguration = redshiftCredentialConfiguration != null ? redshiftCredentialConfiguration.build() : null;
        }

        @Override
        public final Builder redshiftCredentialConfiguration(RedshiftCredentialConfiguration redshiftCredentialConfiguration) {
            this.redshiftCredentialConfiguration = redshiftCredentialConfiguration;
            return this;
        }

        public final RedshiftStorage.Builder getRedshiftStorage() {
            return this.redshiftStorage != null ? this.redshiftStorage.toBuilder() : null;
        }

        public final void setRedshiftStorage(RedshiftStorage.BuilderImpl redshiftStorage) {
            this.redshiftStorage = redshiftStorage != null ? redshiftStorage.build() : null;
        }

        @Override
        public final Builder redshiftStorage(RedshiftStorage redshiftStorage) {
            this.redshiftStorage = redshiftStorage;
            return this;
        }

        public final List<RelationalFilterConfiguration.Builder> getRelationalFilterConfigurations() {
            List<RelationalFilterConfiguration.Builder> result = RelationalFilterConfigurationsCopier.copyToBuilder(this.relationalFilterConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRelationalFilterConfigurations(Collection<RelationalFilterConfiguration.BuilderImpl> relationalFilterConfigurations) {
            this.relationalFilterConfigurations = RelationalFilterConfigurationsCopier.copyFromBuilder(relationalFilterConfigurations);
        }

        @Override
        public final Builder relationalFilterConfigurations(Collection<RelationalFilterConfiguration> relationalFilterConfigurations) {
            this.relationalFilterConfigurations = RelationalFilterConfigurationsCopier.copy(relationalFilterConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalFilterConfigurations(RelationalFilterConfiguration ... relationalFilterConfigurations) {
            this.relationalFilterConfigurations(Arrays.asList(relationalFilterConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder relationalFilterConfigurations(Consumer<RelationalFilterConfiguration.Builder> ... relationalFilterConfigurations) {
            this.relationalFilterConfigurations(Stream.of(relationalFilterConfigurations).map(c -> (RelationalFilterConfiguration)((RelationalFilterConfiguration.Builder)RelationalFilterConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public RedshiftRunConfigurationInput build() {
            return new RedshiftRunConfigurationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RedshiftRunConfigurationInput> {
        public Builder dataAccessRole(String var1);

        public Builder redshiftCredentialConfiguration(RedshiftCredentialConfiguration var1);

        default public Builder redshiftCredentialConfiguration(Consumer<RedshiftCredentialConfiguration.Builder> redshiftCredentialConfiguration) {
            return this.redshiftCredentialConfiguration((RedshiftCredentialConfiguration)((RedshiftCredentialConfiguration.Builder)RedshiftCredentialConfiguration.builder().applyMutation(redshiftCredentialConfiguration)).build());
        }

        public Builder redshiftStorage(RedshiftStorage var1);

        default public Builder redshiftStorage(Consumer<RedshiftStorage.Builder> redshiftStorage) {
            return this.redshiftStorage((RedshiftStorage)((RedshiftStorage.Builder)RedshiftStorage.builder().applyMutation(redshiftStorage)).build());
        }

        public Builder relationalFilterConfigurations(Collection<RelationalFilterConfiguration> var1);

        public Builder relationalFilterConfigurations(RelationalFilterConfiguration ... var1);

        public Builder relationalFilterConfigurations(Consumer<RelationalFilterConfiguration.Builder> ... var1);
    }
}

