/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.EntityOwnersCopier;
import software.amazon.awssdk.services.datazone.model.OwnerPropertiesOutput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEntityOwnersResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, ListEntityOwnersResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEntityOwnersResponse.getter(ListEntityOwnersResponse::nextToken)).setter(ListEntityOwnersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<OwnerPropertiesOutput>> OWNERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("owners").getter(ListEntityOwnersResponse.getter(ListEntityOwnersResponse::owners)).setter(ListEntityOwnersResponse.setter(Builder::owners)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("owners").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(OwnerPropertiesOutput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, OWNERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEntityOwnersResponse.memberNameToFieldInitializer();
    private final String nextToken;
    private final List<OwnerPropertiesOutput> owners;

    private ListEntityOwnersResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.owners = builder.owners;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasOwners() {
        return this.owners != null && !(this.owners instanceof SdkAutoConstructList);
    }

    public final List<OwnerPropertiesOutput> owners() {
        return this.owners;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOwners() ? this.owners() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEntityOwnersResponse)) {
            return false;
        }
        ListEntityOwnersResponse other = (ListEntityOwnersResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasOwners() == other.hasOwners() && Objects.equals(this.owners(), other.owners());
    }

    public final String toString() {
        return ToString.builder((String)"ListEntityOwnersResponse").add("NextToken", (Object)this.nextToken()).add("Owners", this.hasOwners() ? this.owners() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "owners": {
                return Optional.ofNullable(clazz.cast(this.owners()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("owners", OWNERS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEntityOwnersResponse, T> g) {
        return obj -> g.apply((ListEntityOwnersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<OwnerPropertiesOutput> owners = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListEntityOwnersResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.owners(model.owners);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<OwnerPropertiesOutput.Builder> getOwners() {
            List<OwnerPropertiesOutput.Builder> result = EntityOwnersCopier.copyToBuilder(this.owners);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOwners(Collection<OwnerPropertiesOutput.BuilderImpl> owners) {
            this.owners = EntityOwnersCopier.copyFromBuilder(owners);
        }

        @Override
        public final Builder owners(Collection<OwnerPropertiesOutput> owners) {
            this.owners = EntityOwnersCopier.copy(owners);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(OwnerPropertiesOutput ... owners) {
            this.owners(Arrays.asList(owners));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder owners(Consumer<OwnerPropertiesOutput.Builder> ... owners) {
            this.owners(Stream.of(owners).map(c -> (OwnerPropertiesOutput)((OwnerPropertiesOutput.Builder)OwnerPropertiesOutput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListEntityOwnersResponse build() {
            return new ListEntityOwnersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEntityOwnersResponse> {
        public Builder nextToken(String var1);

        public Builder owners(Collection<OwnerPropertiesOutput> var1);

        public Builder owners(OwnerPropertiesOutput ... var1);

        public Builder owners(Consumer<OwnerPropertiesOutput.Builder> ... var1);
    }
}

