/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.AssetFilterConfiguration;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateAssetFilterRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, UpdateAssetFilterRequest> {
    private static final SdkField<String> ASSET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetIdentifier").getter(UpdateAssetFilterRequest.getter(UpdateAssetFilterRequest::assetIdentifier)).setter(UpdateAssetFilterRequest.setter(Builder::assetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("assetIdentifier").build()}).build();
    private static final SdkField<AssetFilterConfiguration> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(UpdateAssetFilterRequest.getter(UpdateAssetFilterRequest::configuration)).setter(UpdateAssetFilterRequest.setter(Builder::configuration)).constructor(AssetFilterConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateAssetFilterRequest.getter(UpdateAssetFilterRequest::description)).setter(UpdateAssetFilterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(UpdateAssetFilterRequest.getter(UpdateAssetFilterRequest::domainIdentifier)).setter(UpdateAssetFilterRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(UpdateAssetFilterRequest.getter(UpdateAssetFilterRequest::identifier)).setter(UpdateAssetFilterRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateAssetFilterRequest.getter(UpdateAssetFilterRequest::name)).setter(UpdateAssetFilterRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_IDENTIFIER_FIELD, CONFIGURATION_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD, NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateAssetFilterRequest.memberNameToFieldInitializer();
    private final String assetIdentifier;
    private final AssetFilterConfiguration configuration;
    private final String description;
    private final String domainIdentifier;
    private final String identifier;
    private final String name;

    private UpdateAssetFilterRequest(BuilderImpl builder) {
        super(builder);
        this.assetIdentifier = builder.assetIdentifier;
        this.configuration = builder.configuration;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
        this.name = builder.name;
    }

    public final String assetIdentifier() {
        return this.assetIdentifier;
    }

    public final AssetFilterConfiguration configuration() {
        return this.configuration;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String name() {
        return this.name;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.assetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAssetFilterRequest)) {
            return false;
        }
        UpdateAssetFilterRequest other = (UpdateAssetFilterRequest)((Object)obj);
        return Objects.equals(this.assetIdentifier(), other.assetIdentifier()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateAssetFilterRequest").add("AssetIdentifier", (Object)this.assetIdentifier()).add("Configuration", (Object)this.configuration()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("Identifier", (Object)this.identifier()).add("Name", (Object)this.name()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.assetIdentifier()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("assetIdentifier", ASSET_IDENTIFIER_FIELD);
        map.put("configuration", CONFIGURATION_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAssetFilterRequest, T> g) {
        return obj -> g.apply((UpdateAssetFilterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String assetIdentifier;
        private AssetFilterConfiguration configuration;
        private String description;
        private String domainIdentifier;
        private String identifier;
        private String name;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAssetFilterRequest model) {
            super(model);
            this.assetIdentifier(model.assetIdentifier);
            this.configuration(model.configuration);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.identifier(model.identifier);
            this.name(model.name);
        }

        public final String getAssetIdentifier() {
            return this.assetIdentifier;
        }

        public final void setAssetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
        }

        @Override
        public final Builder assetIdentifier(String assetIdentifier) {
            this.assetIdentifier = assetIdentifier;
            return this;
        }

        public final AssetFilterConfiguration.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(AssetFilterConfiguration.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(AssetFilterConfiguration configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateAssetFilterRequest build() {
            return new UpdateAssetFilterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateAssetFilterRequest> {
        public Builder assetIdentifier(String var1);

        public Builder configuration(AssetFilterConfiguration var1);

        default public Builder configuration(Consumer<AssetFilterConfiguration.Builder> configuration) {
            return this.configuration((AssetFilterConfiguration)((AssetFilterConfiguration.Builder)AssetFilterConfiguration.builder().applyMutation(configuration)).build());
        }

        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

