/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.UserSearchType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchUserProfilesRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, SearchUserProfilesRequest> {
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(SearchUserProfilesRequest.getter(SearchUserProfilesRequest::domainIdentifier)).setter(SearchUserProfilesRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(SearchUserProfilesRequest.getter(SearchUserProfilesRequest::maxResults)).setter(SearchUserProfilesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchUserProfilesRequest.getter(SearchUserProfilesRequest::nextToken)).setter(SearchUserProfilesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> SEARCH_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("searchText").getter(SearchUserProfilesRequest.getter(SearchUserProfilesRequest::searchText)).setter(SearchUserProfilesRequest.setter(Builder::searchText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchText").build()}).build();
    private static final SdkField<String> USER_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("userType").getter(SearchUserProfilesRequest.getter(SearchUserProfilesRequest::userTypeAsString)).setter(SearchUserProfilesRequest.setter(Builder::userType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEARCH_TEXT_FIELD, USER_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SearchUserProfilesRequest.memberNameToFieldInitializer();
    private final String domainIdentifier;
    private final Integer maxResults;
    private final String nextToken;
    private final String searchText;
    private final String userType;

    private SearchUserProfilesRequest(BuilderImpl builder) {
        super(builder);
        this.domainIdentifier = builder.domainIdentifier;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.searchText = builder.searchText;
        this.userType = builder.userType;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String searchText() {
        return this.searchText;
    }

    public final UserSearchType userType() {
        return UserSearchType.fromValue(this.userType);
    }

    public final String userTypeAsString() {
        return this.userType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.searchText());
        hashCode = 31 * hashCode + Objects.hashCode(this.userTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchUserProfilesRequest)) {
            return false;
        }
        SearchUserProfilesRequest other = (SearchUserProfilesRequest)((Object)obj);
        return Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.searchText(), other.searchText()) && Objects.equals(this.userTypeAsString(), other.userTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"SearchUserProfilesRequest").add("DomainIdentifier", (Object)this.domainIdentifier()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SearchText", (Object)(this.searchText() == null ? null : "*** Sensitive Data Redacted ***")).add("UserType", (Object)this.userTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "searchText": {
                return Optional.ofNullable(clazz.cast(this.searchText()));
            }
            case "userType": {
                return Optional.ofNullable(clazz.cast(this.userTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("searchText", SEARCH_TEXT_FIELD);
        map.put("userType", USER_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchUserProfilesRequest, T> g) {
        return obj -> g.apply((SearchUserProfilesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String domainIdentifier;
        private Integer maxResults;
        private String nextToken;
        private String searchText;
        private String userType;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchUserProfilesRequest model) {
            super(model);
            this.domainIdentifier(model.domainIdentifier);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.searchText(model.searchText);
            this.userType(model.userType);
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getSearchText() {
            return this.searchText;
        }

        public final void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        @Override
        public final Builder searchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        public final String getUserType() {
            return this.userType;
        }

        public final void setUserType(String userType) {
            this.userType = userType;
        }

        @Override
        public final Builder userType(String userType) {
            this.userType = userType;
            return this;
        }

        @Override
        public final Builder userType(UserSearchType userType) {
            this.userType(userType == null ? null : userType.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchUserProfilesRequest build() {
            return new SearchUserProfilesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchUserProfilesRequest> {
        public Builder domainIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder searchText(String var1);

        public Builder userType(String var1);

        public Builder userType(UserSearchType var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

