/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CustomParameter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CustomParameter> {
    private static final SdkField<String> DEFAULT_VALUE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("defaultValue").getter(CustomParameter.getter(CustomParameter::defaultValue)).setter(CustomParameter.setter(Builder::defaultValue)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("defaultValue").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CustomParameter.getter(CustomParameter::description)).setter(CustomParameter.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> FIELD_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fieldType").getter(CustomParameter.getter(CustomParameter::fieldType)).setter(CustomParameter.setter(Builder::fieldType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldType").build()}).build();
    private static final SdkField<Boolean> IS_EDITABLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isEditable").getter(CustomParameter.getter(CustomParameter::isEditable)).setter(CustomParameter.setter(Builder::isEditable)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isEditable").build()}).build();
    private static final SdkField<Boolean> IS_OPTIONAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isOptional").getter(CustomParameter.getter(CustomParameter::isOptional)).setter(CustomParameter.setter(Builder::isOptional)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isOptional").build()}).build();
    private static final SdkField<String> KEY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("keyName").getter(CustomParameter.getter(CustomParameter::keyName)).setter(CustomParameter.setter(Builder::keyName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("keyName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEFAULT_VALUE_FIELD, DESCRIPTION_FIELD, FIELD_TYPE_FIELD, IS_EDITABLE_FIELD, IS_OPTIONAL_FIELD, KEY_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CustomParameter.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String defaultValue;
    private final String description;
    private final String fieldType;
    private final Boolean isEditable;
    private final Boolean isOptional;
    private final String keyName;

    private CustomParameter(BuilderImpl builder) {
        this.defaultValue = builder.defaultValue;
        this.description = builder.description;
        this.fieldType = builder.fieldType;
        this.isEditable = builder.isEditable;
        this.isOptional = builder.isOptional;
        this.keyName = builder.keyName;
    }

    public final String defaultValue() {
        return this.defaultValue;
    }

    public final String description() {
        return this.description;
    }

    public final String fieldType() {
        return this.fieldType;
    }

    public final Boolean isEditable() {
        return this.isEditable;
    }

    public final Boolean isOptional() {
        return this.isOptional;
    }

    public final String keyName() {
        return this.keyName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.defaultValue());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.fieldType());
        hashCode = 31 * hashCode + Objects.hashCode(this.isEditable());
        hashCode = 31 * hashCode + Objects.hashCode(this.isOptional());
        hashCode = 31 * hashCode + Objects.hashCode(this.keyName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomParameter)) {
            return false;
        }
        CustomParameter other = (CustomParameter)obj;
        return Objects.equals(this.defaultValue(), other.defaultValue()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.fieldType(), other.fieldType()) && Objects.equals(this.isEditable(), other.isEditable()) && Objects.equals(this.isOptional(), other.isOptional()) && Objects.equals(this.keyName(), other.keyName());
    }

    public final String toString() {
        return ToString.builder((String)"CustomParameter").add("DefaultValue", (Object)this.defaultValue()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("FieldType", (Object)this.fieldType()).add("IsEditable", (Object)this.isEditable()).add("IsOptional", (Object)this.isOptional()).add("KeyName", (Object)this.keyName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "defaultValue": {
                return Optional.ofNullable(clazz.cast(this.defaultValue()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "fieldType": {
                return Optional.ofNullable(clazz.cast(this.fieldType()));
            }
            case "isEditable": {
                return Optional.ofNullable(clazz.cast(this.isEditable()));
            }
            case "isOptional": {
                return Optional.ofNullable(clazz.cast(this.isOptional()));
            }
            case "keyName": {
                return Optional.ofNullable(clazz.cast(this.keyName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("defaultValue", DEFAULT_VALUE_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("fieldType", FIELD_TYPE_FIELD);
        map.put("isEditable", IS_EDITABLE_FIELD);
        map.put("isOptional", IS_OPTIONAL_FIELD);
        map.put("keyName", KEY_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomParameter, T> g) {
        return obj -> g.apply((CustomParameter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String defaultValue;
        private String description;
        private String fieldType;
        private Boolean isEditable;
        private Boolean isOptional;
        private String keyName;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomParameter model) {
            this.defaultValue(model.defaultValue);
            this.description(model.description);
            this.fieldType(model.fieldType);
            this.isEditable(model.isEditable);
            this.isOptional(model.isOptional);
            this.keyName(model.keyName);
        }

        public final String getDefaultValue() {
            return this.defaultValue;
        }

        public final void setDefaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        public final Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFieldType() {
            return this.fieldType;
        }

        public final void setFieldType(String fieldType) {
            this.fieldType = fieldType;
        }

        @Override
        public final Builder fieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        public final Boolean getIsEditable() {
            return this.isEditable;
        }

        public final void setIsEditable(Boolean isEditable) {
            this.isEditable = isEditable;
        }

        @Override
        public final Builder isEditable(Boolean isEditable) {
            this.isEditable = isEditable;
            return this;
        }

        public final Boolean getIsOptional() {
            return this.isOptional;
        }

        public final void setIsOptional(Boolean isOptional) {
            this.isOptional = isOptional;
        }

        @Override
        public final Builder isOptional(Boolean isOptional) {
            this.isOptional = isOptional;
            return this;
        }

        public final String getKeyName() {
            return this.keyName;
        }

        public final void setKeyName(String keyName) {
            this.keyName = keyName;
        }

        @Override
        public final Builder keyName(String keyName) {
            this.keyName = keyName;
            return this;
        }

        public CustomParameter build() {
            return new CustomParameter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CustomParameter> {
        public Builder defaultValue(String var1);

        public Builder description(String var1);

        public Builder fieldType(String var1);

        public Builder isEditable(Boolean var1);

        public Builder isOptional(Boolean var1);

        public Builder keyName(String var1);
    }
}

