/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.FormInput;
import software.amazon.awssdk.services.datazone.model.FormInputListCopier;
import software.amazon.awssdk.services.datazone.model.GlossaryTermsCopier;
import software.amazon.awssdk.services.datazone.model.PredictionConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAssetRevisionRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateAssetRevisionRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateAssetRevisionRequest.getter(CreateAssetRevisionRequest::clientToken)).setter(CreateAssetRevisionRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateAssetRevisionRequest.getter(CreateAssetRevisionRequest::description)).setter(CreateAssetRevisionRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateAssetRevisionRequest.getter(CreateAssetRevisionRequest::domainIdentifier)).setter(CreateAssetRevisionRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<List<FormInput>> FORMS_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("formsInput").getter(CreateAssetRevisionRequest.getter(CreateAssetRevisionRequest::formsInput)).setter(CreateAssetRevisionRequest.setter(Builder::formsInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formsInput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(CreateAssetRevisionRequest.getter(CreateAssetRevisionRequest::glossaryTerms)).setter(CreateAssetRevisionRequest.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(CreateAssetRevisionRequest.getter(CreateAssetRevisionRequest::identifier)).setter(CreateAssetRevisionRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateAssetRevisionRequest.getter(CreateAssetRevisionRequest::name)).setter(CreateAssetRevisionRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<PredictionConfiguration> PREDICTION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("predictionConfiguration").getter(CreateAssetRevisionRequest.getter(CreateAssetRevisionRequest::predictionConfiguration)).setter(CreateAssetRevisionRequest.setter(Builder::predictionConfiguration)).constructor(PredictionConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("predictionConfiguration").build()}).build();
    private static final SdkField<String> TYPE_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("typeRevision").getter(CreateAssetRevisionRequest.getter(CreateAssetRevisionRequest::typeRevision)).setter(CreateAssetRevisionRequest.setter(Builder::typeRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeRevision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, FORMS_INPUT_FIELD, GLOSSARY_TERMS_FIELD, IDENTIFIER_FIELD, NAME_FIELD, PREDICTION_CONFIGURATION_FIELD, TYPE_REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAssetRevisionRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String description;
    private final String domainIdentifier;
    private final List<FormInput> formsInput;
    private final List<String> glossaryTerms;
    private final String identifier;
    private final String name;
    private final PredictionConfiguration predictionConfiguration;
    private final String typeRevision;

    private CreateAssetRevisionRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.formsInput = builder.formsInput;
        this.glossaryTerms = builder.glossaryTerms;
        this.identifier = builder.identifier;
        this.name = builder.name;
        this.predictionConfiguration = builder.predictionConfiguration;
        this.typeRevision = builder.typeRevision;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final boolean hasFormsInput() {
        return this.formsInput != null && !(this.formsInput instanceof SdkAutoConstructList);
    }

    public final List<FormInput> formsInput() {
        return this.formsInput;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String name() {
        return this.name;
    }

    public final PredictionConfiguration predictionConfiguration() {
        return this.predictionConfiguration;
    }

    public final String typeRevision() {
        return this.typeRevision;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFormsInput() ? this.formsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.predictionConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeRevision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAssetRevisionRequest)) {
            return false;
        }
        CreateAssetRevisionRequest other = (CreateAssetRevisionRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && this.hasFormsInput() == other.hasFormsInput() && Objects.equals(this.formsInput(), other.formsInput()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.predictionConfiguration(), other.predictionConfiguration()) && Objects.equals(this.typeRevision(), other.typeRevision());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAssetRevisionRequest").add("ClientToken", (Object)this.clientToken()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("FormsInput", (Object)(this.formsInput() == null ? null : "*** Sensitive Data Redacted ***")).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Identifier", (Object)this.identifier()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("PredictionConfiguration", (Object)this.predictionConfiguration()).add("TypeRevision", (Object)this.typeRevision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "formsInput": {
                return Optional.ofNullable(clazz.cast(this.formsInput()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "predictionConfiguration": {
                return Optional.ofNullable(clazz.cast(this.predictionConfiguration()));
            }
            case "typeRevision": {
                return Optional.ofNullable(clazz.cast(this.typeRevision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
        map.put("formsInput", FORMS_INPUT_FIELD);
        map.put("glossaryTerms", GLOSSARY_TERMS_FIELD);
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("name", NAME_FIELD);
        map.put("predictionConfiguration", PREDICTION_CONFIGURATION_FIELD);
        map.put("typeRevision", TYPE_REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAssetRevisionRequest, T> g) {
        return obj -> g.apply((CreateAssetRevisionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String description;
        private String domainIdentifier;
        private List<FormInput> formsInput = DefaultSdkAutoConstructList.getInstance();
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String identifier;
        private String name;
        private PredictionConfiguration predictionConfiguration;
        private String typeRevision;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAssetRevisionRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.formsInput(model.formsInput);
            this.glossaryTerms(model.glossaryTerms);
            this.identifier(model.identifier);
            this.name(model.name);
            this.predictionConfiguration(model.predictionConfiguration);
            this.typeRevision(model.typeRevision);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final List<FormInput.Builder> getFormsInput() {
            List<FormInput.Builder> result = FormInputListCopier.copyToBuilder(this.formsInput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFormsInput(Collection<FormInput.BuilderImpl> formsInput) {
            this.formsInput = FormInputListCopier.copyFromBuilder(formsInput);
        }

        @Override
        public final Builder formsInput(Collection<FormInput> formsInput) {
            this.formsInput = FormInputListCopier.copy(formsInput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsInput(FormInput ... formsInput) {
            this.formsInput(Arrays.asList(formsInput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder formsInput(Consumer<FormInput.Builder> ... formsInput) {
            this.formsInput(Stream.of(formsInput).map(c -> (FormInput)((FormInput.Builder)FormInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PredictionConfiguration.Builder getPredictionConfiguration() {
            return this.predictionConfiguration != null ? this.predictionConfiguration.toBuilder() : null;
        }

        public final void setPredictionConfiguration(PredictionConfiguration.BuilderImpl predictionConfiguration) {
            this.predictionConfiguration = predictionConfiguration != null ? predictionConfiguration.build() : null;
        }

        @Override
        public final Builder predictionConfiguration(PredictionConfiguration predictionConfiguration) {
            this.predictionConfiguration = predictionConfiguration;
            return this;
        }

        public final String getTypeRevision() {
            return this.typeRevision;
        }

        public final void setTypeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
        }

        @Override
        public final Builder typeRevision(String typeRevision) {
            this.typeRevision = typeRevision;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAssetRevisionRequest build() {
            return new CreateAssetRevisionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAssetRevisionRequest> {
        public Builder clientToken(String var1);

        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder formsInput(Collection<FormInput> var1);

        public Builder formsInput(FormInput ... var1);

        public Builder formsInput(Consumer<FormInput.Builder> ... var1);

        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder identifier(String var1);

        public Builder name(String var1);

        public Builder predictionConfiguration(PredictionConfiguration var1);

        default public Builder predictionConfiguration(Consumer<PredictionConfiguration.Builder> predictionConfiguration) {
            return this.predictionConfiguration((PredictionConfiguration)((PredictionConfiguration.Builder)PredictionConfiguration.builder().applyMutation(predictionConfiguration)).build());
        }

        public Builder typeRevision(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

