/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.ListEntityOwnersRequest;
import software.amazon.awssdk.services.datazone.model.ListEntityOwnersResponse;
import software.amazon.awssdk.services.datazone.model.OwnerPropertiesOutput;

public class ListEntityOwnersPublisher
implements SdkPublisher<ListEntityOwnersResponse> {
    private final DataZoneAsyncClient client;
    private final ListEntityOwnersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEntityOwnersPublisher(DataZoneAsyncClient client, ListEntityOwnersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEntityOwnersPublisher(DataZoneAsyncClient client, ListEntityOwnersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEntityOwnersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEntityOwnersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OwnerPropertiesOutput> owners() {
        Function<ListEntityOwnersResponse, Iterator> getIterator = response -> {
            if (response != null && response.owners() != null) {
                return response.owners().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEntityOwnersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEntityOwnersResponseFetcher
    implements AsyncPageFetcher<ListEntityOwnersResponse> {
        private ListEntityOwnersResponseFetcher() {
        }

        public boolean hasNextPage(ListEntityOwnersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEntityOwnersResponse> nextPage(ListEntityOwnersResponse previousPage) {
            if (previousPage == null) {
                return ListEntityOwnersPublisher.this.client.listEntityOwners(ListEntityOwnersPublisher.this.firstRequest);
            }
            return ListEntityOwnersPublisher.this.client.listEntityOwners((ListEntityOwnersRequest)((Object)ListEntityOwnersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

