/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.HyperPodOrchestrator;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class HyperPodPropertiesOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, HyperPodPropertiesOutput> {
    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterArn").getter(HyperPodPropertiesOutput.getter(HyperPodPropertiesOutput::clusterArn)).setter(HyperPodPropertiesOutput.setter(Builder::clusterArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()}).build();
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clusterName").getter(HyperPodPropertiesOutput.getter(HyperPodPropertiesOutput::clusterName)).setter(HyperPodPropertiesOutput.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterName").build()}).build();
    private static final SdkField<String> ORCHESTRATOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("orchestrator").getter(HyperPodPropertiesOutput.getter(HyperPodPropertiesOutput::orchestratorAsString)).setter(HyperPodPropertiesOutput.setter(Builder::orchestrator)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("orchestrator").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_ARN_FIELD, CLUSTER_NAME_FIELD, ORCHESTRATOR_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = HyperPodPropertiesOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String clusterArn;
    private final String clusterName;
    private final String orchestrator;

    private HyperPodPropertiesOutput(BuilderImpl builder) {
        this.clusterArn = builder.clusterArn;
        this.clusterName = builder.clusterName;
        this.orchestrator = builder.orchestrator;
    }

    public final String clusterArn() {
        return this.clusterArn;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final HyperPodOrchestrator orchestrator() {
        return HyperPodOrchestrator.fromValue(this.orchestrator);
    }

    public final String orchestratorAsString() {
        return this.orchestrator;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.orchestratorAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof HyperPodPropertiesOutput)) {
            return false;
        }
        HyperPodPropertiesOutput other = (HyperPodPropertiesOutput)obj;
        return Objects.equals(this.clusterArn(), other.clusterArn()) && Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.orchestratorAsString(), other.orchestratorAsString());
    }

    public final String toString() {
        return ToString.builder((String)"HyperPodPropertiesOutput").add("ClusterArn", (Object)this.clusterArn()).add("ClusterName", (Object)this.clusterName()).add("Orchestrator", (Object)this.orchestratorAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clusterArn": {
                return Optional.ofNullable(clazz.cast(this.clusterArn()));
            }
            case "clusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "orchestrator": {
                return Optional.ofNullable(clazz.cast(this.orchestratorAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("clusterName", CLUSTER_NAME_FIELD);
        map.put("orchestrator", ORCHESTRATOR_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<HyperPodPropertiesOutput, T> g) {
        return obj -> g.apply((HyperPodPropertiesOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String clusterArn;
        private String clusterName;
        private String orchestrator;

        private BuilderImpl() {
        }

        private BuilderImpl(HyperPodPropertiesOutput model) {
            this.clusterArn(model.clusterArn);
            this.clusterName(model.clusterName);
            this.orchestrator(model.orchestrator);
        }

        public final String getClusterArn() {
            return this.clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getOrchestrator() {
            return this.orchestrator;
        }

        public final void setOrchestrator(String orchestrator) {
            this.orchestrator = orchestrator;
        }

        @Override
        public final Builder orchestrator(String orchestrator) {
            this.orchestrator = orchestrator;
            return this;
        }

        @Override
        public final Builder orchestrator(HyperPodOrchestrator orchestrator) {
            this.orchestrator(orchestrator == null ? null : orchestrator.toString());
            return this;
        }

        public HyperPodPropertiesOutput build() {
            return new HyperPodPropertiesOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, HyperPodPropertiesOutput> {
        public Builder clusterArn(String var1);

        public Builder clusterName(String var1);

        public Builder orchestrator(String var1);

        public Builder orchestrator(HyperPodOrchestrator var1);
    }
}

