/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AwsLocation
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AwsLocation> {
    private static final SdkField<String> ACCESS_ROLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accessRole").getter(AwsLocation.getter(AwsLocation::accessRole)).setter(AwsLocation.setter(Builder::accessRole)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accessRole").build()}).build();
    private static final SdkField<String> AWS_ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsAccountId").getter(AwsLocation.getter(AwsLocation::awsAccountId)).setter(AwsLocation.setter(Builder::awsAccountId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsAccountId").build()}).build();
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("awsRegion").getter(AwsLocation.getter(AwsLocation::awsRegion)).setter(AwsLocation.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()}).build();
    private static final SdkField<String> IAM_CONNECTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("iamConnectionId").getter(AwsLocation.getter(AwsLocation::iamConnectionId)).setter(AwsLocation.setter(Builder::iamConnectionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iamConnectionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESS_ROLE_FIELD, AWS_ACCOUNT_ID_FIELD, AWS_REGION_FIELD, IAM_CONNECTION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AwsLocation.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String accessRole;
    private final String awsAccountId;
    private final String awsRegion;
    private final String iamConnectionId;

    private AwsLocation(BuilderImpl builder) {
        this.accessRole = builder.accessRole;
        this.awsAccountId = builder.awsAccountId;
        this.awsRegion = builder.awsRegion;
        this.iamConnectionId = builder.iamConnectionId;
    }

    public final String accessRole() {
        return this.accessRole;
    }

    public final String awsAccountId() {
        return this.awsAccountId;
    }

    public final String awsRegion() {
        return this.awsRegion;
    }

    public final String iamConnectionId() {
        return this.iamConnectionId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.accessRole());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsAccountId());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.iamConnectionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AwsLocation)) {
            return false;
        }
        AwsLocation other = (AwsLocation)obj;
        return Objects.equals(this.accessRole(), other.accessRole()) && Objects.equals(this.awsAccountId(), other.awsAccountId()) && Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.iamConnectionId(), other.iamConnectionId());
    }

    public final String toString() {
        return ToString.builder((String)"AwsLocation").add("AccessRole", (Object)this.accessRole()).add("AwsAccountId", (Object)this.awsAccountId()).add("AwsRegion", (Object)this.awsRegion()).add("IamConnectionId", (Object)this.iamConnectionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accessRole": {
                return Optional.ofNullable(clazz.cast(this.accessRole()));
            }
            case "awsAccountId": {
                return Optional.ofNullable(clazz.cast(this.awsAccountId()));
            }
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "iamConnectionId": {
                return Optional.ofNullable(clazz.cast(this.iamConnectionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("accessRole", ACCESS_ROLE_FIELD);
        map.put("awsAccountId", AWS_ACCOUNT_ID_FIELD);
        map.put("awsRegion", AWS_REGION_FIELD);
        map.put("iamConnectionId", IAM_CONNECTION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AwsLocation, T> g) {
        return obj -> g.apply((AwsLocation)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String accessRole;
        private String awsAccountId;
        private String awsRegion;
        private String iamConnectionId;

        private BuilderImpl() {
        }

        private BuilderImpl(AwsLocation model) {
            this.accessRole(model.accessRole);
            this.awsAccountId(model.awsAccountId);
            this.awsRegion(model.awsRegion);
            this.iamConnectionId(model.iamConnectionId);
        }

        public final String getAccessRole() {
            return this.accessRole;
        }

        public final void setAccessRole(String accessRole) {
            this.accessRole = accessRole;
        }

        @Override
        public final Builder accessRole(String accessRole) {
            this.accessRole = accessRole;
            return this;
        }

        public final String getAwsAccountId() {
            return this.awsAccountId;
        }

        public final void setAwsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
        }

        @Override
        public final Builder awsAccountId(String awsAccountId) {
            this.awsAccountId = awsAccountId;
            return this;
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final String getIamConnectionId() {
            return this.iamConnectionId;
        }

        public final void setIamConnectionId(String iamConnectionId) {
            this.iamConnectionId = iamConnectionId;
        }

        @Override
        public final Builder iamConnectionId(String iamConnectionId) {
            this.iamConnectionId = iamConnectionId;
            return this;
        }

        public AwsLocation build() {
            return new AwsLocation(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AwsLocation> {
        public Builder accessRole(String var1);

        public Builder awsAccountId(String var1);

        public Builder awsRegion(String var1);

        public Builder iamConnectionId(String var1);
    }
}

