/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListingRevisionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ListingRevisionInput> {
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(ListingRevisionInput.getter(ListingRevisionInput::identifier)).setter(ListingRevisionInput.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifier").build()}).build();
    private static final SdkField<String> REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("revision").getter(ListingRevisionInput.getter(ListingRevisionInput::revision)).setter(ListingRevisionInput.setter(Builder::revision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("revision").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IDENTIFIER_FIELD, REVISION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListingRevisionInput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String identifier;
    private final String revision;

    private ListingRevisionInput(BuilderImpl builder) {
        this.identifier = builder.identifier;
        this.revision = builder.revision;
    }

    public final String identifier() {
        return this.identifier;
    }

    public final String revision() {
        return this.revision;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.revision());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListingRevisionInput)) {
            return false;
        }
        ListingRevisionInput other = (ListingRevisionInput)obj;
        return Objects.equals(this.identifier(), other.identifier()) && Objects.equals(this.revision(), other.revision());
    }

    public final String toString() {
        return ToString.builder((String)"ListingRevisionInput").add("Identifier", (Object)this.identifier()).add("Revision", (Object)this.revision()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
            case "revision": {
                return Optional.ofNullable(clazz.cast(this.revision()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("identifier", IDENTIFIER_FIELD);
        map.put("revision", REVISION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListingRevisionInput, T> g) {
        return obj -> g.apply((ListingRevisionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String identifier;
        private String revision;

        private BuilderImpl() {
        }

        private BuilderImpl(ListingRevisionInput model) {
            this.identifier(model.identifier);
            this.revision(model.revision);
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public final String getRevision() {
            return this.revision;
        }

        public final void setRevision(String revision) {
            this.revision = revision;
        }

        @Override
        public final Builder revision(String revision) {
            this.revision = revision;
            return this;
        }

        public ListingRevisionInput build() {
            return new ListingRevisionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ListingRevisionInput> {
        public Builder identifier(String var1);

        public Builder revision(String var1);
    }
}

