/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.NameIdentifier;
import software.amazon.awssdk.services.datazone.model.NameIdentifiersCopier;
import software.amazon.awssdk.services.datazone.model.OpenLineageRunState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class OpenLineageRunEventSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, OpenLineageRunEventSummary> {
    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventType").getter(OpenLineageRunEventSummary.getter(OpenLineageRunEventSummary::eventTypeAsString)).setter(OpenLineageRunEventSummary.setter(Builder::eventType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()}).build();
    private static final SdkField<List<NameIdentifier>> INPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputs").getter(OpenLineageRunEventSummary.getter(OpenLineageRunEventSummary::inputs)).setter(OpenLineageRunEventSummary.setter(Builder::inputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NameIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<NameIdentifier> JOB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("job").getter(OpenLineageRunEventSummary.getter(OpenLineageRunEventSummary::job)).setter(OpenLineageRunEventSummary.setter(Builder::job)).constructor(NameIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("job").build()}).build();
    private static final SdkField<List<NameIdentifier>> OUTPUTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outputs").getter(OpenLineageRunEventSummary.getter(OpenLineageRunEventSummary::outputs)).setter(OpenLineageRunEventSummary.setter(Builder::outputs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(NameIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("runId").getter(OpenLineageRunEventSummary.getter(OpenLineageRunEventSummary::runId)).setter(OpenLineageRunEventSummary.setter(Builder::runId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_TYPE_FIELD, INPUTS_FIELD, JOB_FIELD, OUTPUTS_FIELD, RUN_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("eventType", EVENT_TYPE_FIELD);
            this.put("inputs", INPUTS_FIELD);
            this.put("job", JOB_FIELD);
            this.put("outputs", OUTPUTS_FIELD);
            this.put("runId", RUN_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String eventType;
    private final List<NameIdentifier> inputs;
    private final NameIdentifier job;
    private final List<NameIdentifier> outputs;
    private final String runId;

    private OpenLineageRunEventSummary(BuilderImpl builder) {
        this.eventType = builder.eventType;
        this.inputs = builder.inputs;
        this.job = builder.job;
        this.outputs = builder.outputs;
        this.runId = builder.runId;
    }

    public final OpenLineageRunState eventType() {
        return OpenLineageRunState.fromValue(this.eventType);
    }

    public final String eventTypeAsString() {
        return this.eventType;
    }

    public final boolean hasInputs() {
        return this.inputs != null && !(this.inputs instanceof SdkAutoConstructList);
    }

    public final List<NameIdentifier> inputs() {
        return this.inputs;
    }

    public final NameIdentifier job() {
        return this.job;
    }

    public final boolean hasOutputs() {
        return this.outputs != null && !(this.outputs instanceof SdkAutoConstructList);
    }

    public final List<NameIdentifier> outputs() {
        return this.outputs;
    }

    public final String runId() {
        return this.runId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputs() ? this.inputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.job());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutputs() ? this.outputs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.runId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenLineageRunEventSummary)) {
            return false;
        }
        OpenLineageRunEventSummary other = (OpenLineageRunEventSummary)obj;
        return Objects.equals(this.eventTypeAsString(), other.eventTypeAsString()) && this.hasInputs() == other.hasInputs() && Objects.equals(this.inputs(), other.inputs()) && Objects.equals(this.job(), other.job()) && this.hasOutputs() == other.hasOutputs() && Objects.equals(this.outputs(), other.outputs()) && Objects.equals(this.runId(), other.runId());
    }

    public final String toString() {
        return ToString.builder((String)"OpenLineageRunEventSummary").add("EventType", (Object)this.eventTypeAsString()).add("Inputs", this.hasInputs() ? this.inputs() : null).add("Job", (Object)this.job()).add("Outputs", this.hasOutputs() ? this.outputs() : null).add("RunId", (Object)this.runId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "eventType": {
                return Optional.ofNullable(clazz.cast(this.eventTypeAsString()));
            }
            case "inputs": {
                return Optional.ofNullable(clazz.cast(this.inputs()));
            }
            case "job": {
                return Optional.ofNullable(clazz.cast(this.job()));
            }
            case "outputs": {
                return Optional.ofNullable(clazz.cast(this.outputs()));
            }
            case "runId": {
                return Optional.ofNullable(clazz.cast(this.runId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<OpenLineageRunEventSummary, T> g) {
        return obj -> g.apply((OpenLineageRunEventSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String eventType;
        private List<NameIdentifier> inputs = DefaultSdkAutoConstructList.getInstance();
        private NameIdentifier job;
        private List<NameIdentifier> outputs = DefaultSdkAutoConstructList.getInstance();
        private String runId;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenLineageRunEventSummary model) {
            this.eventType(model.eventType);
            this.inputs(model.inputs);
            this.job(model.job);
            this.outputs(model.outputs);
            this.runId(model.runId);
        }

        public final String getEventType() {
            return this.eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(OpenLineageRunState eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final List<NameIdentifier.Builder> getInputs() {
            List<NameIdentifier.Builder> result = NameIdentifiersCopier.copyToBuilder(this.inputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInputs(Collection<NameIdentifier.BuilderImpl> inputs) {
            this.inputs = NameIdentifiersCopier.copyFromBuilder(inputs);
        }

        @Override
        public final Builder inputs(Collection<NameIdentifier> inputs) {
            this.inputs = NameIdentifiersCopier.copy(inputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(NameIdentifier ... inputs) {
            this.inputs(Arrays.asList(inputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputs(Consumer<NameIdentifier.Builder> ... inputs) {
            this.inputs(Stream.of(inputs).map(c -> (NameIdentifier)((NameIdentifier.Builder)NameIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final NameIdentifier.Builder getJob() {
            return this.job != null ? this.job.toBuilder() : null;
        }

        public final void setJob(NameIdentifier.BuilderImpl job) {
            this.job = job != null ? job.build() : null;
        }

        @Override
        public final Builder job(NameIdentifier job) {
            this.job = job;
            return this;
        }

        public final List<NameIdentifier.Builder> getOutputs() {
            List<NameIdentifier.Builder> result = NameIdentifiersCopier.copyToBuilder(this.outputs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutputs(Collection<NameIdentifier.BuilderImpl> outputs) {
            this.outputs = NameIdentifiersCopier.copyFromBuilder(outputs);
        }

        @Override
        public final Builder outputs(Collection<NameIdentifier> outputs) {
            this.outputs = NameIdentifiersCopier.copy(outputs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(NameIdentifier ... outputs) {
            this.outputs(Arrays.asList(outputs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outputs(Consumer<NameIdentifier.Builder> ... outputs) {
            this.outputs(Stream.of(outputs).map(c -> (NameIdentifier)((NameIdentifier.Builder)NameIdentifier.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getRunId() {
            return this.runId;
        }

        public final void setRunId(String runId) {
            this.runId = runId;
        }

        @Override
        public final Builder runId(String runId) {
            this.runId = runId;
            return this;
        }

        public OpenLineageRunEventSummary build() {
            return new OpenLineageRunEventSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, OpenLineageRunEventSummary> {
        public Builder eventType(String var1);

        public Builder eventType(OpenLineageRunState var1);

        public Builder inputs(Collection<NameIdentifier> var1);

        public Builder inputs(NameIdentifier ... var1);

        public Builder inputs(Consumer<NameIdentifier.Builder> ... var1);

        public Builder job(NameIdentifier var1);

        default public Builder job(Consumer<NameIdentifier.Builder> job) {
            return this.job((NameIdentifier)((NameIdentifier.Builder)NameIdentifier.builder().applyMutation(job)).build());
        }

        public Builder outputs(Collection<NameIdentifier> var1);

        public Builder outputs(NameIdentifier ... var1);

        public Builder outputs(Consumer<NameIdentifier.Builder> ... var1);

        public Builder runId(String var1);
    }
}

