/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.LineageEventProcessingStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LineageInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LineageInfo> {
    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("errorMessage").getter(LineageInfo.getter(LineageInfo::errorMessage)).setter(LineageInfo.setter(Builder::errorMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> EVENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventId").getter(LineageInfo.getter(LineageInfo::eventId)).setter(LineageInfo.setter(Builder::eventId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventId").build()}).build();
    private static final SdkField<String> EVENT_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("eventStatus").getter(LineageInfo.getter(LineageInfo::eventStatusAsString)).setter(LineageInfo.setter(Builder::eventStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_MESSAGE_FIELD, EVENT_ID_FIELD, EVENT_STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("errorMessage", ERROR_MESSAGE_FIELD);
            this.put("eventId", EVENT_ID_FIELD);
            this.put("eventStatus", EVENT_STATUS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String errorMessage;
    private final String eventId;
    private final String eventStatus;

    private LineageInfo(BuilderImpl builder) {
        this.errorMessage = builder.errorMessage;
        this.eventId = builder.eventId;
        this.eventStatus = builder.eventStatus;
    }

    public final String errorMessage() {
        return this.errorMessage;
    }

    public final String eventId() {
        return this.eventId;
    }

    public final LineageEventProcessingStatus eventStatus() {
        return LineageEventProcessingStatus.fromValue(this.eventStatus);
    }

    public final String eventStatusAsString() {
        return this.eventStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventId());
        hashCode = 31 * hashCode + Objects.hashCode(this.eventStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LineageInfo)) {
            return false;
        }
        LineageInfo other = (LineageInfo)obj;
        return Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.eventId(), other.eventId()) && Objects.equals(this.eventStatusAsString(), other.eventStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LineageInfo").add("ErrorMessage", (Object)this.errorMessage()).add("EventId", (Object)this.eventId()).add("EventStatus", (Object)this.eventStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "eventId": {
                return Optional.ofNullable(clazz.cast(this.eventId()));
            }
            case "eventStatus": {
                return Optional.ofNullable(clazz.cast(this.eventStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<LineageInfo, T> g) {
        return obj -> g.apply((LineageInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String errorMessage;
        private String eventId;
        private String eventStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(LineageInfo model) {
            this.errorMessage(model.errorMessage);
            this.eventId(model.eventId);
            this.eventStatus(model.eventStatus);
        }

        public final String getErrorMessage() {
            return this.errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getEventId() {
            return this.eventId;
        }

        public final void setEventId(String eventId) {
            this.eventId = eventId;
        }

        @Override
        public final Builder eventId(String eventId) {
            this.eventId = eventId;
            return this;
        }

        public final String getEventStatus() {
            return this.eventStatus;
        }

        public final void setEventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
        }

        @Override
        public final Builder eventStatus(String eventStatus) {
            this.eventStatus = eventStatus;
            return this;
        }

        @Override
        public final Builder eventStatus(LineageEventProcessingStatus eventStatus) {
            this.eventStatus(eventStatus == null ? null : eventStatus.toString());
            return this;
        }

        public LineageInfo build() {
            return new LineageInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LineageInfo> {
        public Builder errorMessage(String var1);

        public Builder eventId(String var1);

        public Builder eventStatus(String var1);

        public Builder eventStatus(LineageEventProcessingStatus var1);
    }
}

