/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AuthenticationConfigurationInput;
import software.amazon.awssdk.services.datazone.model.ComputeEnvironments;
import software.amazon.awssdk.services.datazone.model.ComputeEnvironmentsListCopier;
import software.amazon.awssdk.services.datazone.model.ConnectionPropertiesCopier;
import software.amazon.awssdk.services.datazone.model.GlueConnectionType;
import software.amazon.awssdk.services.datazone.model.PhysicalConnectionRequirements;
import software.amazon.awssdk.services.datazone.model.PropertyMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GlueConnectionInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GlueConnectionInput> {
    private static final SdkField<Map<String, String>> ATHENA_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("athenaProperties").getter(GlueConnectionInput.getter(GlueConnectionInput::athenaProperties)).setter(GlueConnectionInput.setter(Builder::athenaProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("athenaProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AuthenticationConfigurationInput> AUTHENTICATION_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authenticationConfiguration").getter(GlueConnectionInput.getter(GlueConnectionInput::authenticationConfiguration)).setter(GlueConnectionInput.setter(Builder::authenticationConfiguration)).constructor(AuthenticationConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> CONNECTION_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("connectionProperties").getter(GlueConnectionInput.getter(GlueConnectionInput::connectionProperties)).setter(GlueConnectionInput.setter(Builder::connectionProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<String> CONNECTION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionType").getter(GlueConnectionInput.getter(GlueConnectionInput::connectionTypeAsString)).setter(GlueConnectionInput.setter(Builder::connectionType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionType").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GlueConnectionInput.getter(GlueConnectionInput::description)).setter(GlueConnectionInput.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> MATCH_CRITERIA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("matchCriteria").getter(GlueConnectionInput.getter(GlueConnectionInput::matchCriteria)).setter(GlueConnectionInput.setter(Builder::matchCriteria)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("matchCriteria").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GlueConnectionInput.getter(GlueConnectionInput::name)).setter(GlueConnectionInput.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<PhysicalConnectionRequirements> PHYSICAL_CONNECTION_REQUIREMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("physicalConnectionRequirements").getter(GlueConnectionInput.getter(GlueConnectionInput::physicalConnectionRequirements)).setter(GlueConnectionInput.setter(Builder::physicalConnectionRequirements)).constructor(PhysicalConnectionRequirements::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("physicalConnectionRequirements").build()}).build();
    private static final SdkField<Map<String, String>> PYTHON_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("pythonProperties").getter(GlueConnectionInput.getter(GlueConnectionInput::pythonProperties)).setter(GlueConnectionInput.setter(Builder::pythonProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pythonProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Map<String, String>> SPARK_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("sparkProperties").getter(GlueConnectionInput.getter(GlueConnectionInput::sparkProperties)).setter(GlueConnectionInput.setter(Builder::sparkProperties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sparkProperties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> VALIDATE_CREDENTIALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("validateCredentials").getter(GlueConnectionInput.getter(GlueConnectionInput::validateCredentials)).setter(GlueConnectionInput.setter(Builder::validateCredentials)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validateCredentials").build()}).build();
    private static final SdkField<List<String>> VALIDATE_FOR_COMPUTE_ENVIRONMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("validateForComputeEnvironments").getter(GlueConnectionInput.getter(GlueConnectionInput::validateForComputeEnvironmentsAsStrings)).setter(GlueConnectionInput.setter(Builder::validateForComputeEnvironmentsWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("validateForComputeEnvironments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATHENA_PROPERTIES_FIELD, AUTHENTICATION_CONFIGURATION_FIELD, CONNECTION_PROPERTIES_FIELD, CONNECTION_TYPE_FIELD, DESCRIPTION_FIELD, MATCH_CRITERIA_FIELD, NAME_FIELD, PHYSICAL_CONNECTION_REQUIREMENTS_FIELD, PYTHON_PROPERTIES_FIELD, SPARK_PROPERTIES_FIELD, VALIDATE_CREDENTIALS_FIELD, VALIDATE_FOR_COMPUTE_ENVIRONMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("athenaProperties", ATHENA_PROPERTIES_FIELD);
            this.put("authenticationConfiguration", AUTHENTICATION_CONFIGURATION_FIELD);
            this.put("connectionProperties", CONNECTION_PROPERTIES_FIELD);
            this.put("connectionType", CONNECTION_TYPE_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("matchCriteria", MATCH_CRITERIA_FIELD);
            this.put("name", NAME_FIELD);
            this.put("physicalConnectionRequirements", PHYSICAL_CONNECTION_REQUIREMENTS_FIELD);
            this.put("pythonProperties", PYTHON_PROPERTIES_FIELD);
            this.put("sparkProperties", SPARK_PROPERTIES_FIELD);
            this.put("validateCredentials", VALIDATE_CREDENTIALS_FIELD);
            this.put("validateForComputeEnvironments", VALIDATE_FOR_COMPUTE_ENVIRONMENTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Map<String, String> athenaProperties;
    private final AuthenticationConfigurationInput authenticationConfiguration;
    private final Map<String, String> connectionProperties;
    private final String connectionType;
    private final String description;
    private final String matchCriteria;
    private final String name;
    private final PhysicalConnectionRequirements physicalConnectionRequirements;
    private final Map<String, String> pythonProperties;
    private final Map<String, String> sparkProperties;
    private final Boolean validateCredentials;
    private final List<String> validateForComputeEnvironments;

    private GlueConnectionInput(BuilderImpl builder) {
        this.athenaProperties = builder.athenaProperties;
        this.authenticationConfiguration = builder.authenticationConfiguration;
        this.connectionProperties = builder.connectionProperties;
        this.connectionType = builder.connectionType;
        this.description = builder.description;
        this.matchCriteria = builder.matchCriteria;
        this.name = builder.name;
        this.physicalConnectionRequirements = builder.physicalConnectionRequirements;
        this.pythonProperties = builder.pythonProperties;
        this.sparkProperties = builder.sparkProperties;
        this.validateCredentials = builder.validateCredentials;
        this.validateForComputeEnvironments = builder.validateForComputeEnvironments;
    }

    public final boolean hasAthenaProperties() {
        return this.athenaProperties != null && !(this.athenaProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> athenaProperties() {
        return this.athenaProperties;
    }

    public final AuthenticationConfigurationInput authenticationConfiguration() {
        return this.authenticationConfiguration;
    }

    public final boolean hasConnectionProperties() {
        return this.connectionProperties != null && !(this.connectionProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> connectionProperties() {
        return this.connectionProperties;
    }

    public final GlueConnectionType connectionType() {
        return GlueConnectionType.fromValue(this.connectionType);
    }

    public final String connectionTypeAsString() {
        return this.connectionType;
    }

    public final String description() {
        return this.description;
    }

    public final String matchCriteria() {
        return this.matchCriteria;
    }

    public final String name() {
        return this.name;
    }

    public final PhysicalConnectionRequirements physicalConnectionRequirements() {
        return this.physicalConnectionRequirements;
    }

    public final boolean hasPythonProperties() {
        return this.pythonProperties != null && !(this.pythonProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> pythonProperties() {
        return this.pythonProperties;
    }

    public final boolean hasSparkProperties() {
        return this.sparkProperties != null && !(this.sparkProperties instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> sparkProperties() {
        return this.sparkProperties;
    }

    public final Boolean validateCredentials() {
        return this.validateCredentials;
    }

    public final List<ComputeEnvironments> validateForComputeEnvironments() {
        return ComputeEnvironmentsListCopier.copyStringToEnum(this.validateForComputeEnvironments);
    }

    public final boolean hasValidateForComputeEnvironments() {
        return this.validateForComputeEnvironments != null && !(this.validateForComputeEnvironments instanceof SdkAutoConstructList);
    }

    public final List<String> validateForComputeEnvironmentsAsStrings() {
        return this.validateForComputeEnvironments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAthenaProperties() ? this.athenaProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authenticationConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasConnectionProperties() ? this.connectionProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.matchCriteria());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.physicalConnectionRequirements());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPythonProperties() ? this.pythonProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSparkProperties() ? this.sparkProperties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.validateCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasValidateForComputeEnvironments() ? this.validateForComputeEnvironmentsAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GlueConnectionInput)) {
            return false;
        }
        GlueConnectionInput other = (GlueConnectionInput)obj;
        return this.hasAthenaProperties() == other.hasAthenaProperties() && Objects.equals(this.athenaProperties(), other.athenaProperties()) && Objects.equals(this.authenticationConfiguration(), other.authenticationConfiguration()) && this.hasConnectionProperties() == other.hasConnectionProperties() && Objects.equals(this.connectionProperties(), other.connectionProperties()) && Objects.equals(this.connectionTypeAsString(), other.connectionTypeAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.matchCriteria(), other.matchCriteria()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.physicalConnectionRequirements(), other.physicalConnectionRequirements()) && this.hasPythonProperties() == other.hasPythonProperties() && Objects.equals(this.pythonProperties(), other.pythonProperties()) && this.hasSparkProperties() == other.hasSparkProperties() && Objects.equals(this.sparkProperties(), other.sparkProperties()) && Objects.equals(this.validateCredentials(), other.validateCredentials()) && this.hasValidateForComputeEnvironments() == other.hasValidateForComputeEnvironments() && Objects.equals(this.validateForComputeEnvironmentsAsStrings(), other.validateForComputeEnvironmentsAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"GlueConnectionInput").add("AthenaProperties", this.hasAthenaProperties() ? this.athenaProperties() : null).add("AuthenticationConfiguration", (Object)this.authenticationConfiguration()).add("ConnectionProperties", this.hasConnectionProperties() ? this.connectionProperties() : null).add("ConnectionType", (Object)this.connectionTypeAsString()).add("Description", (Object)this.description()).add("MatchCriteria", (Object)this.matchCriteria()).add("Name", (Object)this.name()).add("PhysicalConnectionRequirements", (Object)this.physicalConnectionRequirements()).add("PythonProperties", this.hasPythonProperties() ? this.pythonProperties() : null).add("SparkProperties", this.hasSparkProperties() ? this.sparkProperties() : null).add("ValidateCredentials", (Object)this.validateCredentials()).add("ValidateForComputeEnvironments", this.hasValidateForComputeEnvironments() ? this.validateForComputeEnvironmentsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "athenaProperties": {
                return Optional.ofNullable(clazz.cast(this.athenaProperties()));
            }
            case "authenticationConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authenticationConfiguration()));
            }
            case "connectionProperties": {
                return Optional.ofNullable(clazz.cast(this.connectionProperties()));
            }
            case "connectionType": {
                return Optional.ofNullable(clazz.cast(this.connectionTypeAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "matchCriteria": {
                return Optional.ofNullable(clazz.cast(this.matchCriteria()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "physicalConnectionRequirements": {
                return Optional.ofNullable(clazz.cast(this.physicalConnectionRequirements()));
            }
            case "pythonProperties": {
                return Optional.ofNullable(clazz.cast(this.pythonProperties()));
            }
            case "sparkProperties": {
                return Optional.ofNullable(clazz.cast(this.sparkProperties()));
            }
            case "validateCredentials": {
                return Optional.ofNullable(clazz.cast(this.validateCredentials()));
            }
            case "validateForComputeEnvironments": {
                return Optional.ofNullable(clazz.cast(this.validateForComputeEnvironmentsAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GlueConnectionInput, T> g) {
        return obj -> g.apply((GlueConnectionInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Map<String, String> athenaProperties = DefaultSdkAutoConstructMap.getInstance();
        private AuthenticationConfigurationInput authenticationConfiguration;
        private Map<String, String> connectionProperties = DefaultSdkAutoConstructMap.getInstance();
        private String connectionType;
        private String description;
        private String matchCriteria;
        private String name;
        private PhysicalConnectionRequirements physicalConnectionRequirements;
        private Map<String, String> pythonProperties = DefaultSdkAutoConstructMap.getInstance();
        private Map<String, String> sparkProperties = DefaultSdkAutoConstructMap.getInstance();
        private Boolean validateCredentials;
        private List<String> validateForComputeEnvironments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GlueConnectionInput model) {
            this.athenaProperties(model.athenaProperties);
            this.authenticationConfiguration(model.authenticationConfiguration);
            this.connectionProperties(model.connectionProperties);
            this.connectionType(model.connectionType);
            this.description(model.description);
            this.matchCriteria(model.matchCriteria);
            this.name(model.name);
            this.physicalConnectionRequirements(model.physicalConnectionRequirements);
            this.pythonProperties(model.pythonProperties);
            this.sparkProperties(model.sparkProperties);
            this.validateCredentials(model.validateCredentials);
            this.validateForComputeEnvironmentsWithStrings(model.validateForComputeEnvironments);
        }

        public final Map<String, String> getAthenaProperties() {
            if (this.athenaProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.athenaProperties;
        }

        public final void setAthenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
        }

        @Override
        public final Builder athenaProperties(Map<String, String> athenaProperties) {
            this.athenaProperties = PropertyMapCopier.copy(athenaProperties);
            return this;
        }

        public final AuthenticationConfigurationInput.Builder getAuthenticationConfiguration() {
            return this.authenticationConfiguration != null ? this.authenticationConfiguration.toBuilder() : null;
        }

        public final void setAuthenticationConfiguration(AuthenticationConfigurationInput.BuilderImpl authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration != null ? authenticationConfiguration.build() : null;
        }

        @Override
        public final Builder authenticationConfiguration(AuthenticationConfigurationInput authenticationConfiguration) {
            this.authenticationConfiguration = authenticationConfiguration;
            return this;
        }

        public final Map<String, String> getConnectionProperties() {
            if (this.connectionProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.connectionProperties;
        }

        public final void setConnectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
        }

        @Override
        public final Builder connectionProperties(Map<String, String> connectionProperties) {
            this.connectionProperties = ConnectionPropertiesCopier.copy(connectionProperties);
            return this;
        }

        public final String getConnectionType() {
            return this.connectionType;
        }

        public final void setConnectionType(String connectionType) {
            this.connectionType = connectionType;
        }

        @Override
        public final Builder connectionType(String connectionType) {
            this.connectionType = connectionType;
            return this;
        }

        @Override
        public final Builder connectionType(GlueConnectionType connectionType) {
            this.connectionType(connectionType == null ? null : connectionType.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getMatchCriteria() {
            return this.matchCriteria;
        }

        public final void setMatchCriteria(String matchCriteria) {
            this.matchCriteria = matchCriteria;
        }

        @Override
        public final Builder matchCriteria(String matchCriteria) {
            this.matchCriteria = matchCriteria;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final PhysicalConnectionRequirements.Builder getPhysicalConnectionRequirements() {
            return this.physicalConnectionRequirements != null ? this.physicalConnectionRequirements.toBuilder() : null;
        }

        public final void setPhysicalConnectionRequirements(PhysicalConnectionRequirements.BuilderImpl physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements != null ? physicalConnectionRequirements.build() : null;
        }

        @Override
        public final Builder physicalConnectionRequirements(PhysicalConnectionRequirements physicalConnectionRequirements) {
            this.physicalConnectionRequirements = physicalConnectionRequirements;
            return this;
        }

        public final Map<String, String> getPythonProperties() {
            if (this.pythonProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.pythonProperties;
        }

        public final void setPythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
        }

        @Override
        public final Builder pythonProperties(Map<String, String> pythonProperties) {
            this.pythonProperties = PropertyMapCopier.copy(pythonProperties);
            return this;
        }

        public final Map<String, String> getSparkProperties() {
            if (this.sparkProperties instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.sparkProperties;
        }

        public final void setSparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
        }

        @Override
        public final Builder sparkProperties(Map<String, String> sparkProperties) {
            this.sparkProperties = PropertyMapCopier.copy(sparkProperties);
            return this;
        }

        public final Boolean getValidateCredentials() {
            return this.validateCredentials;
        }

        public final void setValidateCredentials(Boolean validateCredentials) {
            this.validateCredentials = validateCredentials;
        }

        @Override
        public final Builder validateCredentials(Boolean validateCredentials) {
            this.validateCredentials = validateCredentials;
            return this;
        }

        public final Collection<String> getValidateForComputeEnvironments() {
            if (this.validateForComputeEnvironments instanceof SdkAutoConstructList) {
                return null;
            }
            return this.validateForComputeEnvironments;
        }

        public final void setValidateForComputeEnvironments(Collection<String> validateForComputeEnvironments) {
            this.validateForComputeEnvironments = ComputeEnvironmentsListCopier.copy(validateForComputeEnvironments);
        }

        @Override
        public final Builder validateForComputeEnvironmentsWithStrings(Collection<String> validateForComputeEnvironments) {
            this.validateForComputeEnvironments = ComputeEnvironmentsListCopier.copy(validateForComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validateForComputeEnvironmentsWithStrings(String ... validateForComputeEnvironments) {
            this.validateForComputeEnvironmentsWithStrings(Arrays.asList(validateForComputeEnvironments));
            return this;
        }

        @Override
        public final Builder validateForComputeEnvironments(Collection<ComputeEnvironments> validateForComputeEnvironments) {
            this.validateForComputeEnvironments = ComputeEnvironmentsListCopier.copyEnumToString(validateForComputeEnvironments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder validateForComputeEnvironments(ComputeEnvironments ... validateForComputeEnvironments) {
            this.validateForComputeEnvironments(Arrays.asList(validateForComputeEnvironments));
            return this;
        }

        public GlueConnectionInput build() {
            return new GlueConnectionInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GlueConnectionInput> {
        public Builder athenaProperties(Map<String, String> var1);

        public Builder authenticationConfiguration(AuthenticationConfigurationInput var1);

        default public Builder authenticationConfiguration(Consumer<AuthenticationConfigurationInput.Builder> authenticationConfiguration) {
            return this.authenticationConfiguration((AuthenticationConfigurationInput)((AuthenticationConfigurationInput.Builder)AuthenticationConfigurationInput.builder().applyMutation(authenticationConfiguration)).build());
        }

        public Builder connectionProperties(Map<String, String> var1);

        public Builder connectionType(String var1);

        public Builder connectionType(GlueConnectionType var1);

        public Builder description(String var1);

        public Builder matchCriteria(String var1);

        public Builder name(String var1);

        public Builder physicalConnectionRequirements(PhysicalConnectionRequirements var1);

        default public Builder physicalConnectionRequirements(Consumer<PhysicalConnectionRequirements.Builder> physicalConnectionRequirements) {
            return this.physicalConnectionRequirements((PhysicalConnectionRequirements)((PhysicalConnectionRequirements.Builder)PhysicalConnectionRequirements.builder().applyMutation(physicalConnectionRequirements)).build());
        }

        public Builder pythonProperties(Map<String, String> var1);

        public Builder sparkProperties(Map<String, String> var1);

        public Builder validateCredentials(Boolean var1);

        public Builder validateForComputeEnvironmentsWithStrings(Collection<String> var1);

        public Builder validateForComputeEnvironmentsWithStrings(String ... var1);

        public Builder validateForComputeEnvironments(Collection<ComputeEnvironments> var1);

        public Builder validateForComputeEnvironments(ComputeEnvironments ... var1);
    }
}

