/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataSourceStatus;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataSourcesRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, ListDataSourcesRequest> {
    private static final SdkField<String> CONNECTION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionIdentifier").getter(ListDataSourcesRequest.getter(ListDataSourcesRequest::connectionIdentifier)).setter(ListDataSourcesRequest.setter(Builder::connectionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("connectionIdentifier").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(ListDataSourcesRequest.getter(ListDataSourcesRequest::domainIdentifier)).setter(ListDataSourcesRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentIdentifier").getter(ListDataSourcesRequest.getter(ListDataSourcesRequest::environmentIdentifier)).setter(ListDataSourcesRequest.setter(Builder::environmentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("environmentIdentifier").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListDataSourcesRequest.getter(ListDataSourcesRequest::maxResults)).setter(ListDataSourcesRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(ListDataSourcesRequest.getter(ListDataSourcesRequest::name)).setter(ListDataSourcesRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("name").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataSourcesRequest.getter(ListDataSourcesRequest::nextToken)).setter(ListDataSourcesRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()}).build();
    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectIdentifier").getter(ListDataSourcesRequest.getter(ListDataSourcesRequest::projectIdentifier)).setter(ListDataSourcesRequest.setter(Builder::projectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("projectIdentifier").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(ListDataSourcesRequest.getter(ListDataSourcesRequest::statusAsString)).setter(ListDataSourcesRequest.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ListDataSourcesRequest.getter(ListDataSourcesRequest::type)).setter(ListDataSourcesRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTION_IDENTIFIER_FIELD, DOMAIN_IDENTIFIER_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, MAX_RESULTS_FIELD, NAME_FIELD, NEXT_TOKEN_FIELD, PROJECT_IDENTIFIER_FIELD, STATUS_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("connectionIdentifier", CONNECTION_IDENTIFIER_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("projectIdentifier", PROJECT_IDENTIFIER_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private final String connectionIdentifier;
    private final String domainIdentifier;
    private final String environmentIdentifier;
    private final Integer maxResults;
    private final String name;
    private final String nextToken;
    private final String projectIdentifier;
    private final String status;
    private final String type;

    private ListDataSourcesRequest(BuilderImpl builder) {
        super(builder);
        this.connectionIdentifier = builder.connectionIdentifier;
        this.domainIdentifier = builder.domainIdentifier;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.maxResults = builder.maxResults;
        this.name = builder.name;
        this.nextToken = builder.nextToken;
        this.projectIdentifier = builder.projectIdentifier;
        this.status = builder.status;
        this.type = builder.type;
    }

    public final String connectionIdentifier() {
        return this.connectionIdentifier;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String environmentIdentifier() {
        return this.environmentIdentifier;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String name() {
        return this.name;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final String projectIdentifier() {
        return this.projectIdentifier;
    }

    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataSourcesRequest)) {
            return false;
        }
        ListDataSourcesRequest other = (ListDataSourcesRequest)((Object)obj);
        return Objects.equals(this.connectionIdentifier(), other.connectionIdentifier()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.projectIdentifier(), other.projectIdentifier()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataSourcesRequest").add("ConnectionIdentifier", (Object)this.connectionIdentifier()).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EnvironmentIdentifier", (Object)this.environmentIdentifier()).add("MaxResults", (Object)this.maxResults()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("NextToken", (Object)this.nextToken()).add("ProjectIdentifier", (Object)this.projectIdentifier()).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.connectionIdentifier()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "environmentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentIdentifier()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "projectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.projectIdentifier()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListDataSourcesRequest, T> g) {
        return obj -> g.apply((ListDataSourcesRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private String connectionIdentifier;
        private String domainIdentifier;
        private String environmentIdentifier;
        private Integer maxResults;
        private String name;
        private String nextToken;
        private String projectIdentifier;
        private String status;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataSourcesRequest model) {
            super(model);
            this.connectionIdentifier(model.connectionIdentifier);
            this.domainIdentifier(model.domainIdentifier);
            this.environmentIdentifier(model.environmentIdentifier);
            this.maxResults(model.maxResults);
            this.name(model.name);
            this.nextToken(model.nextToken);
            this.projectIdentifier(model.projectIdentifier);
            this.status(model.status);
            this.type(model.type);
        }

        public final String getConnectionIdentifier() {
            return this.connectionIdentifier;
        }

        public final void setConnectionIdentifier(String connectionIdentifier) {
            this.connectionIdentifier = connectionIdentifier;
        }

        @Override
        public final Builder connectionIdentifier(String connectionIdentifier) {
            this.connectionIdentifier = connectionIdentifier;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataSourcesRequest build() {
            return new ListDataSourcesRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataSourcesRequest> {
        public Builder connectionIdentifier(String var1);

        public Builder domainIdentifier(String var1);

        public Builder environmentIdentifier(String var1);

        public Builder maxResults(Integer var1);

        public Builder name(String var1);

        public Builder nextToken(String var1);

        public Builder projectIdentifier(String var1);

        public Builder status(String var1);

        public Builder status(DataSourceStatus var1);

        public Builder type(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

