/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataSourceConfigurationInput;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.EnableSetting;
import software.amazon.awssdk.services.datazone.model.FormInput;
import software.amazon.awssdk.services.datazone.model.FormInputListCopier;
import software.amazon.awssdk.services.datazone.model.RecommendationConfiguration;
import software.amazon.awssdk.services.datazone.model.ScheduleConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateDataSourceRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, CreateDataSourceRequest> {
    private static final SdkField<List<FormInput>> ASSET_FORMS_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetFormsInput").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::assetFormsInput)).setter(CreateDataSourceRequest.setter(Builder::assetFormsInput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetFormsInput").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FormInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::clientToken)).setter(CreateDataSourceRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<DataSourceConfigurationInput> CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("configuration").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::configuration)).setter(CreateDataSourceRequest.setter(Builder::configuration)).constructor(DataSourceConfigurationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("configuration").build()}).build();
    private static final SdkField<String> CONNECTION_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectionIdentifier").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::connectionIdentifier)).setter(CreateDataSourceRequest.setter(Builder::connectionIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectionIdentifier").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::description)).setter(CreateDataSourceRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::domainIdentifier)).setter(CreateDataSourceRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> ENABLE_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enableSetting").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::enableSettingAsString)).setter(CreateDataSourceRequest.setter(Builder::enableSetting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSetting").build()}).build();
    private static final SdkField<String> ENVIRONMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentIdentifier").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::environmentIdentifier)).setter(CreateDataSourceRequest.setter(Builder::environmentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentIdentifier").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::name)).setter(CreateDataSourceRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROJECT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectIdentifier").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::projectIdentifier)).setter(CreateDataSourceRequest.setter(Builder::projectIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectIdentifier").build()}).build();
    private static final SdkField<Boolean> PUBLISH_ON_IMPORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("publishOnImport").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::publishOnImport)).setter(CreateDataSourceRequest.setter(Builder::publishOnImport)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("publishOnImport").build()}).build();
    private static final SdkField<RecommendationConfiguration> RECOMMENDATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("recommendation").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::recommendation)).setter(CreateDataSourceRequest.setter(Builder::recommendation)).constructor(RecommendationConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recommendation").build()}).build();
    private static final SdkField<ScheduleConfiguration> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::schedule)).setter(CreateDataSourceRequest.setter(Builder::schedule)).constructor(ScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(CreateDataSourceRequest.getter(CreateDataSourceRequest::type)).setter(CreateDataSourceRequest.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_FORMS_INPUT_FIELD, CLIENT_TOKEN_FIELD, CONFIGURATION_FIELD, CONNECTION_IDENTIFIER_FIELD, DESCRIPTION_FIELD, DOMAIN_IDENTIFIER_FIELD, ENABLE_SETTING_FIELD, ENVIRONMENT_IDENTIFIER_FIELD, NAME_FIELD, PROJECT_IDENTIFIER_FIELD, PUBLISH_ON_IMPORT_FIELD, RECOMMENDATION_FIELD, SCHEDULE_FIELD, TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assetFormsInput", ASSET_FORMS_INPUT_FIELD);
            this.put("clientToken", CLIENT_TOKEN_FIELD);
            this.put("configuration", CONFIGURATION_FIELD);
            this.put("connectionIdentifier", CONNECTION_IDENTIFIER_FIELD);
            this.put("description", DESCRIPTION_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("enableSetting", ENABLE_SETTING_FIELD);
            this.put("environmentIdentifier", ENVIRONMENT_IDENTIFIER_FIELD);
            this.put("name", NAME_FIELD);
            this.put("projectIdentifier", PROJECT_IDENTIFIER_FIELD);
            this.put("publishOnImport", PUBLISH_ON_IMPORT_FIELD);
            this.put("recommendation", RECOMMENDATION_FIELD);
            this.put("schedule", SCHEDULE_FIELD);
            this.put("type", TYPE_FIELD);
        }
    });
    private final List<FormInput> assetFormsInput;
    private final String clientToken;
    private final DataSourceConfigurationInput configuration;
    private final String connectionIdentifier;
    private final String description;
    private final String domainIdentifier;
    private final String enableSetting;
    private final String environmentIdentifier;
    private final String name;
    private final String projectIdentifier;
    private final Boolean publishOnImport;
    private final RecommendationConfiguration recommendation;
    private final ScheduleConfiguration schedule;
    private final String type;

    private CreateDataSourceRequest(BuilderImpl builder) {
        super(builder);
        this.assetFormsInput = builder.assetFormsInput;
        this.clientToken = builder.clientToken;
        this.configuration = builder.configuration;
        this.connectionIdentifier = builder.connectionIdentifier;
        this.description = builder.description;
        this.domainIdentifier = builder.domainIdentifier;
        this.enableSetting = builder.enableSetting;
        this.environmentIdentifier = builder.environmentIdentifier;
        this.name = builder.name;
        this.projectIdentifier = builder.projectIdentifier;
        this.publishOnImport = builder.publishOnImport;
        this.recommendation = builder.recommendation;
        this.schedule = builder.schedule;
        this.type = builder.type;
    }

    public final boolean hasAssetFormsInput() {
        return this.assetFormsInput != null && !(this.assetFormsInput instanceof SdkAutoConstructList);
    }

    public final List<FormInput> assetFormsInput() {
        return this.assetFormsInput;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final DataSourceConfigurationInput configuration() {
        return this.configuration;
    }

    public final String connectionIdentifier() {
        return this.connectionIdentifier;
    }

    public final String description() {
        return this.description;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final EnableSetting enableSetting() {
        return EnableSetting.fromValue(this.enableSetting);
    }

    public final String enableSettingAsString() {
        return this.enableSetting;
    }

    public final String environmentIdentifier() {
        return this.environmentIdentifier;
    }

    public final String name() {
        return this.name;
    }

    public final String projectIdentifier() {
        return this.projectIdentifier;
    }

    public final Boolean publishOnImport() {
        return this.publishOnImport;
    }

    public final RecommendationConfiguration recommendation() {
        return this.recommendation;
    }

    public final ScheduleConfiguration schedule() {
        return this.schedule;
    }

    public final String type() {
        return this.type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetFormsInput() ? this.assetFormsInput() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.configuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.connectionIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.publishOnImport());
        hashCode = 31 * hashCode + Objects.hashCode(this.recommendation());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDataSourceRequest)) {
            return false;
        }
        CreateDataSourceRequest other = (CreateDataSourceRequest)((Object)obj);
        return this.hasAssetFormsInput() == other.hasAssetFormsInput() && Objects.equals(this.assetFormsInput(), other.assetFormsInput()) && Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.configuration(), other.configuration()) && Objects.equals(this.connectionIdentifier(), other.connectionIdentifier()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.enableSettingAsString(), other.enableSettingAsString()) && Objects.equals(this.environmentIdentifier(), other.environmentIdentifier()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.projectIdentifier(), other.projectIdentifier()) && Objects.equals(this.publishOnImport(), other.publishOnImport()) && Objects.equals(this.recommendation(), other.recommendation()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.type(), other.type());
    }

    public final String toString() {
        return ToString.builder((String)"CreateDataSourceRequest").add("AssetFormsInput", (Object)(this.assetFormsInput() == null ? null : "*** Sensitive Data Redacted ***")).add("ClientToken", (Object)this.clientToken()).add("Configuration", (Object)this.configuration()).add("ConnectionIdentifier", (Object)this.connectionIdentifier()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("EnableSetting", (Object)this.enableSettingAsString()).add("EnvironmentIdentifier", (Object)this.environmentIdentifier()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("ProjectIdentifier", (Object)this.projectIdentifier()).add("PublishOnImport", (Object)this.publishOnImport()).add("Recommendation", (Object)this.recommendation()).add("Schedule", (Object)(this.schedule() == null ? null : "*** Sensitive Data Redacted ***")).add("Type", (Object)this.type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetFormsInput": {
                return Optional.ofNullable(clazz.cast(this.assetFormsInput()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "configuration": {
                return Optional.ofNullable(clazz.cast(this.configuration()));
            }
            case "connectionIdentifier": {
                return Optional.ofNullable(clazz.cast(this.connectionIdentifier()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "enableSetting": {
                return Optional.ofNullable(clazz.cast(this.enableSettingAsString()));
            }
            case "environmentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.environmentIdentifier()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "projectIdentifier": {
                return Optional.ofNullable(clazz.cast(this.projectIdentifier()));
            }
            case "publishOnImport": {
                return Optional.ofNullable(clazz.cast(this.publishOnImport()));
            }
            case "recommendation": {
                return Optional.ofNullable(clazz.cast(this.recommendation()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<CreateDataSourceRequest, T> g) {
        return obj -> g.apply((CreateDataSourceRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private List<FormInput> assetFormsInput = DefaultSdkAutoConstructList.getInstance();
        private String clientToken;
        private DataSourceConfigurationInput configuration;
        private String connectionIdentifier;
        private String description;
        private String domainIdentifier;
        private String enableSetting;
        private String environmentIdentifier;
        private String name;
        private String projectIdentifier;
        private Boolean publishOnImport;
        private RecommendationConfiguration recommendation;
        private ScheduleConfiguration schedule;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDataSourceRequest model) {
            super(model);
            this.assetFormsInput(model.assetFormsInput);
            this.clientToken(model.clientToken);
            this.configuration(model.configuration);
            this.connectionIdentifier(model.connectionIdentifier);
            this.description(model.description);
            this.domainIdentifier(model.domainIdentifier);
            this.enableSetting(model.enableSetting);
            this.environmentIdentifier(model.environmentIdentifier);
            this.name(model.name);
            this.projectIdentifier(model.projectIdentifier);
            this.publishOnImport(model.publishOnImport);
            this.recommendation(model.recommendation);
            this.schedule(model.schedule);
            this.type(model.type);
        }

        public final List<FormInput.Builder> getAssetFormsInput() {
            List<FormInput.Builder> result = FormInputListCopier.copyToBuilder(this.assetFormsInput);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetFormsInput(Collection<FormInput.BuilderImpl> assetFormsInput) {
            this.assetFormsInput = FormInputListCopier.copyFromBuilder(assetFormsInput);
        }

        @Override
        public final Builder assetFormsInput(Collection<FormInput> assetFormsInput) {
            this.assetFormsInput = FormInputListCopier.copy(assetFormsInput);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsInput(FormInput ... assetFormsInput) {
            this.assetFormsInput(Arrays.asList(assetFormsInput));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetFormsInput(Consumer<FormInput.Builder> ... assetFormsInput) {
            this.assetFormsInput(Stream.of(assetFormsInput).map(c -> (FormInput)((FormInput.Builder)FormInput.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final DataSourceConfigurationInput.Builder getConfiguration() {
            return this.configuration != null ? this.configuration.toBuilder() : null;
        }

        public final void setConfiguration(DataSourceConfigurationInput.BuilderImpl configuration) {
            this.configuration = configuration != null ? configuration.build() : null;
        }

        @Override
        public final Builder configuration(DataSourceConfigurationInput configuration) {
            this.configuration = configuration;
            return this;
        }

        public final String getConnectionIdentifier() {
            return this.connectionIdentifier;
        }

        public final void setConnectionIdentifier(String connectionIdentifier) {
            this.connectionIdentifier = connectionIdentifier;
        }

        @Override
        public final Builder connectionIdentifier(String connectionIdentifier) {
            this.connectionIdentifier = connectionIdentifier;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getEnableSetting() {
            return this.enableSetting;
        }

        public final void setEnableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
        }

        @Override
        public final Builder enableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
            return this;
        }

        @Override
        public final Builder enableSetting(EnableSetting enableSetting) {
            this.enableSetting(enableSetting == null ? null : enableSetting.toString());
            return this;
        }

        public final String getEnvironmentIdentifier() {
            return this.environmentIdentifier;
        }

        public final void setEnvironmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
        }

        @Override
        public final Builder environmentIdentifier(String environmentIdentifier) {
            this.environmentIdentifier = environmentIdentifier;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProjectIdentifier() {
            return this.projectIdentifier;
        }

        public final void setProjectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
        }

        @Override
        public final Builder projectIdentifier(String projectIdentifier) {
            this.projectIdentifier = projectIdentifier;
            return this;
        }

        public final Boolean getPublishOnImport() {
            return this.publishOnImport;
        }

        public final void setPublishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
        }

        @Override
        public final Builder publishOnImport(Boolean publishOnImport) {
            this.publishOnImport = publishOnImport;
            return this;
        }

        public final RecommendationConfiguration.Builder getRecommendation() {
            return this.recommendation != null ? this.recommendation.toBuilder() : null;
        }

        public final void setRecommendation(RecommendationConfiguration.BuilderImpl recommendation) {
            this.recommendation = recommendation != null ? recommendation.build() : null;
        }

        @Override
        public final Builder recommendation(RecommendationConfiguration recommendation) {
            this.recommendation = recommendation;
            return this;
        }

        public final ScheduleConfiguration.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(ScheduleConfiguration.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(ScheduleConfiguration schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDataSourceRequest build() {
            return new CreateDataSourceRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateDataSourceRequest> {
        public Builder assetFormsInput(Collection<FormInput> var1);

        public Builder assetFormsInput(FormInput ... var1);

        public Builder assetFormsInput(Consumer<FormInput.Builder> ... var1);

        public Builder clientToken(String var1);

        public Builder configuration(DataSourceConfigurationInput var1);

        default public Builder configuration(Consumer<DataSourceConfigurationInput.Builder> configuration) {
            return this.configuration((DataSourceConfigurationInput)((DataSourceConfigurationInput.Builder)DataSourceConfigurationInput.builder().applyMutation(configuration)).build());
        }

        public Builder connectionIdentifier(String var1);

        public Builder description(String var1);

        public Builder domainIdentifier(String var1);

        public Builder enableSetting(String var1);

        public Builder enableSetting(EnableSetting var1);

        public Builder environmentIdentifier(String var1);

        public Builder name(String var1);

        public Builder projectIdentifier(String var1);

        public Builder publishOnImport(Boolean var1);

        public Builder recommendation(RecommendationConfiguration var1);

        default public Builder recommendation(Consumer<RecommendationConfiguration.Builder> recommendation) {
            return this.recommendation((RecommendationConfiguration)((RecommendationConfiguration.Builder)RecommendationConfiguration.builder().applyMutation(recommendation)).build());
        }

        public Builder schedule(ScheduleConfiguration var1);

        default public Builder schedule(Consumer<ScheduleConfiguration.Builder> schedule) {
            return this.schedule((ScheduleConfiguration)((ScheduleConfiguration.Builder)ScheduleConfiguration.builder().applyMutation(schedule)).build());
        }

        public Builder type(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

