/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.services.datazone.model.FilterClause;
import software.amazon.awssdk.services.datazone.model.SearchInItem;
import software.amazon.awssdk.services.datazone.model.SearchInListCopier;
import software.amazon.awssdk.services.datazone.model.SearchOutputAdditionalAttribute;
import software.amazon.awssdk.services.datazone.model.SearchOutputAdditionalAttributesCopier;
import software.amazon.awssdk.services.datazone.model.SearchSort;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchListingsRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, SearchListingsRequest> {
    private static final SdkField<List<String>> ADDITIONAL_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("additionalAttributes").getter(SearchListingsRequest.getter(SearchListingsRequest::additionalAttributesAsStrings)).setter(SearchListingsRequest.setter(Builder::additionalAttributesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(SearchListingsRequest.getter(SearchListingsRequest::domainIdentifier)).setter(SearchListingsRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<FilterClause> FILTERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("filters").getter(SearchListingsRequest.getter(SearchListingsRequest::filters)).setter(SearchListingsRequest.setter(Builder::filters)).constructor(FilterClause::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filters").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(SearchListingsRequest.getter(SearchListingsRequest::maxResults)).setter(SearchListingsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(SearchListingsRequest.getter(SearchListingsRequest::nextToken)).setter(SearchListingsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<SearchInItem>> SEARCH_IN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("searchIn").getter(SearchListingsRequest.getter(SearchListingsRequest::searchIn)).setter(SearchListingsRequest.setter(Builder::searchIn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchIn").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SearchInItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SEARCH_TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("searchText").getter(SearchListingsRequest.getter(SearchListingsRequest::searchText)).setter(SearchListingsRequest.setter(Builder::searchText)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("searchText").build()}).build();
    private static final SdkField<SearchSort> SORT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sort").getter(SearchListingsRequest.getter(SearchListingsRequest::sort)).setter(SearchListingsRequest.setter(Builder::sort)).constructor(SearchSort::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDITIONAL_ATTRIBUTES_FIELD, DOMAIN_IDENTIFIER_FIELD, FILTERS_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, SEARCH_IN_FIELD, SEARCH_TEXT_FIELD, SORT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("additionalAttributes", ADDITIONAL_ATTRIBUTES_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("filters", FILTERS_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("searchIn", SEARCH_IN_FIELD);
            this.put("searchText", SEARCH_TEXT_FIELD);
            this.put("sort", SORT_FIELD);
        }
    });
    private final List<String> additionalAttributes;
    private final String domainIdentifier;
    private final FilterClause filters;
    private final Integer maxResults;
    private final String nextToken;
    private final List<SearchInItem> searchIn;
    private final String searchText;
    private final SearchSort sort;

    private SearchListingsRequest(BuilderImpl builder) {
        super(builder);
        this.additionalAttributes = builder.additionalAttributes;
        this.domainIdentifier = builder.domainIdentifier;
        this.filters = builder.filters;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.searchIn = builder.searchIn;
        this.searchText = builder.searchText;
        this.sort = builder.sort;
    }

    public final List<SearchOutputAdditionalAttribute> additionalAttributes() {
        return SearchOutputAdditionalAttributesCopier.copyStringToEnum(this.additionalAttributes);
    }

    public final boolean hasAdditionalAttributes() {
        return this.additionalAttributes != null && !(this.additionalAttributes instanceof SdkAutoConstructList);
    }

    public final List<String> additionalAttributesAsStrings() {
        return this.additionalAttributes;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final FilterClause filters() {
        return this.filters;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasSearchIn() {
        return this.searchIn != null && !(this.searchIn instanceof SdkAutoConstructList);
    }

    public final List<SearchInItem> searchIn() {
        return this.searchIn;
    }

    public final String searchText() {
        return this.searchText;
    }

    public final SearchSort sort() {
        return this.sort;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAdditionalAttributes() ? this.additionalAttributesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.filters());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSearchIn() ? this.searchIn() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.searchText());
        hashCode = 31 * hashCode + Objects.hashCode(this.sort());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchListingsRequest)) {
            return false;
        }
        SearchListingsRequest other = (SearchListingsRequest)((Object)obj);
        return this.hasAdditionalAttributes() == other.hasAdditionalAttributes() && Objects.equals(this.additionalAttributesAsStrings(), other.additionalAttributesAsStrings()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.filters(), other.filters()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasSearchIn() == other.hasSearchIn() && Objects.equals(this.searchIn(), other.searchIn()) && Objects.equals(this.searchText(), other.searchText()) && Objects.equals(this.sort(), other.sort());
    }

    public final String toString() {
        return ToString.builder((String)"SearchListingsRequest").add("AdditionalAttributes", this.hasAdditionalAttributes() ? this.additionalAttributesAsStrings() : null).add("DomainIdentifier", (Object)this.domainIdentifier()).add("Filters", (Object)this.filters()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("SearchIn", this.hasSearchIn() ? this.searchIn() : null).add("SearchText", (Object)this.searchText()).add("Sort", (Object)this.sort()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "additionalAttributes": {
                return Optional.ofNullable(clazz.cast(this.additionalAttributesAsStrings()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "filters": {
                return Optional.ofNullable(clazz.cast(this.filters()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "searchIn": {
                return Optional.ofNullable(clazz.cast(this.searchIn()));
            }
            case "searchText": {
                return Optional.ofNullable(clazz.cast(this.searchText()));
            }
            case "sort": {
                return Optional.ofNullable(clazz.cast(this.sort()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchListingsRequest, T> g) {
        return obj -> g.apply((SearchListingsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private List<String> additionalAttributes = DefaultSdkAutoConstructList.getInstance();
        private String domainIdentifier;
        private FilterClause filters;
        private Integer maxResults;
        private String nextToken;
        private List<SearchInItem> searchIn = DefaultSdkAutoConstructList.getInstance();
        private String searchText;
        private SearchSort sort;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchListingsRequest model) {
            super(model);
            this.additionalAttributesWithStrings(model.additionalAttributes);
            this.domainIdentifier(model.domainIdentifier);
            this.filters(model.filters);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.searchIn(model.searchIn);
            this.searchText(model.searchText);
            this.sort(model.sort);
        }

        public final Collection<String> getAdditionalAttributes() {
            if (this.additionalAttributes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.additionalAttributes;
        }

        public final void setAdditionalAttributes(Collection<String> additionalAttributes) {
            this.additionalAttributes = SearchOutputAdditionalAttributesCopier.copy(additionalAttributes);
        }

        @Override
        public final Builder additionalAttributesWithStrings(Collection<String> additionalAttributes) {
            this.additionalAttributes = SearchOutputAdditionalAttributesCopier.copy(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributesWithStrings(String ... additionalAttributes) {
            this.additionalAttributesWithStrings(Arrays.asList(additionalAttributes));
            return this;
        }

        @Override
        public final Builder additionalAttributes(Collection<SearchOutputAdditionalAttribute> additionalAttributes) {
            this.additionalAttributes = SearchOutputAdditionalAttributesCopier.copyEnumToString(additionalAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder additionalAttributes(SearchOutputAdditionalAttribute ... additionalAttributes) {
            this.additionalAttributes(Arrays.asList(additionalAttributes));
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final FilterClause.Builder getFilters() {
            return this.filters != null ? this.filters.toBuilder() : null;
        }

        public final void setFilters(FilterClause.BuilderImpl filters) {
            this.filters = filters != null ? filters.build() : null;
        }

        @Override
        public final Builder filters(FilterClause filters) {
            this.filters = filters;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<SearchInItem.Builder> getSearchIn() {
            List<SearchInItem.Builder> result = SearchInListCopier.copyToBuilder(this.searchIn);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSearchIn(Collection<SearchInItem.BuilderImpl> searchIn) {
            this.searchIn = SearchInListCopier.copyFromBuilder(searchIn);
        }

        @Override
        public final Builder searchIn(Collection<SearchInItem> searchIn) {
            this.searchIn = SearchInListCopier.copy(searchIn);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchIn(SearchInItem ... searchIn) {
            this.searchIn(Arrays.asList(searchIn));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder searchIn(Consumer<SearchInItem.Builder> ... searchIn) {
            this.searchIn(Stream.of(searchIn).map(c -> (SearchInItem)((SearchInItem.Builder)SearchInItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSearchText() {
            return this.searchText;
        }

        public final void setSearchText(String searchText) {
            this.searchText = searchText;
        }

        @Override
        public final Builder searchText(String searchText) {
            this.searchText = searchText;
            return this;
        }

        public final SearchSort.Builder getSort() {
            return this.sort != null ? this.sort.toBuilder() : null;
        }

        public final void setSort(SearchSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(SearchSort sort) {
            this.sort = sort;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchListingsRequest build() {
            return new SearchListingsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, SearchListingsRequest> {
        public Builder additionalAttributesWithStrings(Collection<String> var1);

        public Builder additionalAttributesWithStrings(String ... var1);

        public Builder additionalAttributes(Collection<SearchOutputAdditionalAttribute> var1);

        public Builder additionalAttributes(SearchOutputAdditionalAttribute ... var1);

        public Builder domainIdentifier(String var1);

        public Builder filters(FilterClause var1);

        default public Builder filters(Consumer<FilterClause.Builder> filters) {
            return this.filters((FilterClause)((FilterClause.Builder)FilterClause.builder().applyMutation(filters)).build());
        }

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder searchIn(Collection<SearchInItem> var1);

        public Builder searchIn(SearchInItem ... var1);

        public Builder searchIn(Consumer<SearchInItem.Builder> ... var1);

        public Builder searchText(String var1);

        public Builder sort(SearchSort var1);

        default public Builder sort(Consumer<SearchSort.Builder> sort) {
            return this.sort((SearchSort)((SearchSort.Builder)SearchSort.builder().applyMutation(sort)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

