/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.LineageNodeSummariesCopier;
import software.amazon.awssdk.services.datazone.model.LineageNodeSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListLineageNodeHistoryResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, ListLineageNodeHistoryResponse> {
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListLineageNodeHistoryResponse.getter(ListLineageNodeHistoryResponse::nextToken)).setter(ListLineageNodeHistoryResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<LineageNodeSummary>> NODES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("nodes").getter(ListLineageNodeHistoryResponse.getter(ListLineageNodeHistoryResponse::nodes)).setter(ListLineageNodeHistoryResponse.setter(Builder::nodes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(LineageNodeSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NEXT_TOKEN_FIELD, NODES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("nodes", NODES_FIELD);
        }
    });
    private final String nextToken;
    private final List<LineageNodeSummary> nodes;

    private ListLineageNodeHistoryResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.nodes = builder.nodes;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasNodes() {
        return this.nodes != null && !(this.nodes instanceof SdkAutoConstructList);
    }

    public final List<LineageNodeSummary> nodes() {
        return this.nodes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasNodes() ? this.nodes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListLineageNodeHistoryResponse)) {
            return false;
        }
        ListLineageNodeHistoryResponse other = (ListLineageNodeHistoryResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && this.hasNodes() == other.hasNodes() && Objects.equals(this.nodes(), other.nodes());
    }

    public final String toString() {
        return ToString.builder((String)"ListLineageNodeHistoryResponse").add("NextToken", (Object)this.nextToken()).add("Nodes", this.hasNodes() ? this.nodes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "nodes": {
                return Optional.ofNullable(clazz.cast(this.nodes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListLineageNodeHistoryResponse, T> g) {
        return obj -> g.apply((ListLineageNodeHistoryResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<LineageNodeSummary> nodes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListLineageNodeHistoryResponse model) {
            super(model);
            this.nextToken(model.nextToken);
            this.nodes(model.nodes);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<LineageNodeSummary.Builder> getNodes() {
            List<LineageNodeSummary.Builder> result = LineageNodeSummariesCopier.copyToBuilder(this.nodes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNodes(Collection<LineageNodeSummary.BuilderImpl> nodes) {
            this.nodes = LineageNodeSummariesCopier.copyFromBuilder(nodes);
        }

        @Override
        public final Builder nodes(Collection<LineageNodeSummary> nodes) {
            this.nodes = LineageNodeSummariesCopier.copy(nodes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(LineageNodeSummary ... nodes) {
            this.nodes(Arrays.asList(nodes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder nodes(Consumer<LineageNodeSummary.Builder> ... nodes) {
            this.nodes(Stream.of(nodes).map(c -> (LineageNodeSummary)((LineageNodeSummary.Builder)LineageNodeSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ListLineageNodeHistoryResponse build() {
            return new ListLineageNodeHistoryResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListLineageNodeHistoryResponse> {
        public Builder nextToken(String var1);

        public Builder nodes(Collection<LineageNodeSummary> var1);

        public Builder nodes(LineageNodeSummary ... var1);

        public Builder nodes(Consumer<LineageNodeSummary.Builder> ... var1);
    }
}

