/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.datazone.DataZoneAsyncClient;
import software.amazon.awssdk.services.datazone.internal.UserAgentUtils;
import software.amazon.awssdk.services.datazone.model.AssetRevision;
import software.amazon.awssdk.services.datazone.model.ListAssetRevisionsRequest;
import software.amazon.awssdk.services.datazone.model.ListAssetRevisionsResponse;

public class ListAssetRevisionsPublisher
implements SdkPublisher<ListAssetRevisionsResponse> {
    private final DataZoneAsyncClient client;
    private final ListAssetRevisionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAssetRevisionsPublisher(DataZoneAsyncClient client, ListAssetRevisionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAssetRevisionsPublisher(DataZoneAsyncClient client, ListAssetRevisionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAssetRevisionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAssetRevisionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AssetRevision> items() {
        Function<ListAssetRevisionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAssetRevisionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAssetRevisionsResponseFetcher
    implements AsyncPageFetcher<ListAssetRevisionsResponse> {
        private ListAssetRevisionsResponseFetcher() {
        }

        public boolean hasNextPage(ListAssetRevisionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAssetRevisionsResponse> nextPage(ListAssetRevisionsResponse previousPage) {
            if (previousPage == null) {
                return ListAssetRevisionsPublisher.this.client.listAssetRevisions(ListAssetRevisionsPublisher.this.firstRequest);
            }
            return ListAssetRevisionsPublisher.this.client.listAssetRevisions((ListAssetRevisionsRequest)((Object)ListAssetRevisionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

