/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.SubscribedAssetListing;
import software.amazon.awssdk.services.datazone.model.SubscribedProductListing;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribedListingItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscribedListingItem> {
    private static final SdkField<SubscribedAssetListing> ASSET_LISTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetListing").getter(SubscribedListingItem.getter(SubscribedListingItem::assetListing)).setter(SubscribedListingItem.setter(Builder::assetListing)).constructor(SubscribedAssetListing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetListing").build()}).build();
    private static final SdkField<SubscribedProductListing> PRODUCT_LISTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("productListing").getter(SubscribedListingItem.getter(SubscribedListingItem::productListing)).setter(SubscribedListingItem.setter(Builder::productListing)).constructor(SubscribedProductListing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("productListing").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_LISTING_FIELD, PRODUCT_LISTING_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assetListing", ASSET_LISTING_FIELD);
            this.put("productListing", PRODUCT_LISTING_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final SubscribedAssetListing assetListing;
    private final SubscribedProductListing productListing;
    private final Type type;

    private SubscribedListingItem(BuilderImpl builder) {
        this.assetListing = builder.assetListing;
        this.productListing = builder.productListing;
        this.type = builder.type;
    }

    public final SubscribedAssetListing assetListing() {
        return this.assetListing;
    }

    public final SubscribedProductListing productListing() {
        return this.productListing;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetListing());
        hashCode = 31 * hashCode + Objects.hashCode(this.productListing());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedListingItem)) {
            return false;
        }
        SubscribedListingItem other = (SubscribedListingItem)obj;
        return Objects.equals(this.assetListing(), other.assetListing()) && Objects.equals(this.productListing(), other.productListing());
    }

    public final String toString() {
        return ToString.builder((String)"SubscribedListingItem").add("AssetListing", (Object)this.assetListing()).add("ProductListing", (Object)this.productListing()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetListing": {
                return Optional.ofNullable(clazz.cast(this.assetListing()));
            }
            case "productListing": {
                return Optional.ofNullable(clazz.cast(this.productListing()));
            }
        }
        return Optional.empty();
    }

    public static SubscribedListingItem fromAssetListing(SubscribedAssetListing assetListing) {
        return (SubscribedListingItem)SubscribedListingItem.builder().assetListing(assetListing).build();
    }

    public static SubscribedListingItem fromAssetListing(Consumer<SubscribedAssetListing.Builder> assetListing) {
        SubscribedAssetListing.Builder builder = SubscribedAssetListing.builder();
        assetListing.accept(builder);
        return SubscribedListingItem.fromAssetListing((SubscribedAssetListing)builder.build());
    }

    public static SubscribedListingItem fromProductListing(SubscribedProductListing productListing) {
        return (SubscribedListingItem)SubscribedListingItem.builder().productListing(productListing).build();
    }

    public static SubscribedListingItem fromProductListing(Consumer<SubscribedProductListing.Builder> productListing) {
        SubscribedProductListing.Builder builder = SubscribedProductListing.builder();
        productListing.accept(builder);
        return SubscribedListingItem.fromProductListing((SubscribedProductListing)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SubscribedListingItem, T> g) {
        return obj -> g.apply((SubscribedListingItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ASSET_LISTING,
        PRODUCT_LISTING,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private SubscribedAssetListing assetListing;
        private SubscribedProductListing productListing;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedListingItem model) {
            this.assetListing(model.assetListing);
            this.productListing(model.productListing);
        }

        public final SubscribedAssetListing.Builder getAssetListing() {
            return this.assetListing != null ? this.assetListing.toBuilder() : null;
        }

        public final void setAssetListing(SubscribedAssetListing.BuilderImpl assetListing) {
            SubscribedAssetListing oldValue = this.assetListing;
            this.assetListing = assetListing != null ? assetListing.build() : null;
            this.handleUnionValueChange(Type.ASSET_LISTING, oldValue, this.assetListing);
        }

        @Override
        public final Builder assetListing(SubscribedAssetListing assetListing) {
            SubscribedAssetListing oldValue = this.assetListing;
            this.assetListing = assetListing;
            this.handleUnionValueChange(Type.ASSET_LISTING, oldValue, this.assetListing);
            return this;
        }

        public final SubscribedProductListing.Builder getProductListing() {
            return this.productListing != null ? this.productListing.toBuilder() : null;
        }

        public final void setProductListing(SubscribedProductListing.BuilderImpl productListing) {
            SubscribedProductListing oldValue = this.productListing;
            this.productListing = productListing != null ? productListing.build() : null;
            this.handleUnionValueChange(Type.PRODUCT_LISTING, oldValue, this.productListing);
        }

        @Override
        public final Builder productListing(SubscribedProductListing productListing) {
            SubscribedProductListing oldValue = this.productListing;
            this.productListing = productListing;
            this.handleUnionValueChange(Type.PRODUCT_LISTING, oldValue, this.productListing);
            return this;
        }

        public SubscribedListingItem build() {
            return new SubscribedListingItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscribedListingItem> {
        public Builder assetListing(SubscribedAssetListing var1);

        default public Builder assetListing(Consumer<SubscribedAssetListing.Builder> assetListing) {
            return this.assetListing((SubscribedAssetListing)((SubscribedAssetListing.Builder)SubscribedAssetListing.builder().applyMutation(assetListing)).build());
        }

        public Builder productListing(SubscribedProductListing var1);

        default public Builder productListing(Consumer<SubscribedProductListing.Builder> productListing) {
            return this.productListing((SubscribedProductListing)((SubscribedProductListing.Builder)SubscribedProductListing.builder().applyMutation(productListing)).build());
        }
    }
}

