/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataAssetActivityStatus;
import software.amazon.awssdk.services.datazone.model.DataSourceErrorMessage;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceRunActivity
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceRunActivity> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DataSourceRunActivity.getter(DataSourceRunActivity::createdAt)).setter(DataSourceRunActivity.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataAssetId").getter(DataSourceRunActivity.getter(DataSourceRunActivity::dataAssetId)).setter(DataSourceRunActivity.setter(Builder::dataAssetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAssetId").build()}).build();
    private static final SdkField<String> DATA_ASSET_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataAssetStatus").getter(DataSourceRunActivity.getter(DataSourceRunActivity::dataAssetStatusAsString)).setter(DataSourceRunActivity.setter(Builder::dataAssetStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataAssetStatus").build()}).build();
    private static final SdkField<String> DATA_SOURCE_RUN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceRunId").getter(DataSourceRunActivity.getter(DataSourceRunActivity::dataSourceRunId)).setter(DataSourceRunActivity.setter(Builder::dataSourceRunId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceRunId").build()}).build();
    private static final SdkField<String> DATABASE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("database").getter(DataSourceRunActivity.getter(DataSourceRunActivity::database)).setter(DataSourceRunActivity.setter(Builder::database)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("database").build()}).build();
    private static final SdkField<DataSourceErrorMessage> ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("errorMessage").getter(DataSourceRunActivity.getter(DataSourceRunActivity::errorMessage)).setter(DataSourceRunActivity.setter(Builder::errorMessage)).constructor(DataSourceErrorMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()}).build();
    private static final SdkField<String> PROJECT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectId").getter(DataSourceRunActivity.getter(DataSourceRunActivity::projectId)).setter(DataSourceRunActivity.setter(Builder::projectId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectId").build()}).build();
    private static final SdkField<String> TECHNICAL_DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("technicalDescription").getter(DataSourceRunActivity.getter(DataSourceRunActivity::technicalDescription)).setter(DataSourceRunActivity.setter(Builder::technicalDescription)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("technicalDescription").build()}).build();
    private static final SdkField<String> TECHNICAL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("technicalName").getter(DataSourceRunActivity.getter(DataSourceRunActivity::technicalName)).setter(DataSourceRunActivity.setter(Builder::technicalName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("technicalName").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(DataSourceRunActivity.getter(DataSourceRunActivity::updatedAt)).setter(DataSourceRunActivity.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DATA_ASSET_ID_FIELD, DATA_ASSET_STATUS_FIELD, DATA_SOURCE_RUN_ID_FIELD, DATABASE_FIELD, ERROR_MESSAGE_FIELD, PROJECT_ID_FIELD, TECHNICAL_DESCRIPTION_FIELD, TECHNICAL_NAME_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("dataAssetId", DATA_ASSET_ID_FIELD);
            this.put("dataAssetStatus", DATA_ASSET_STATUS_FIELD);
            this.put("dataSourceRunId", DATA_SOURCE_RUN_ID_FIELD);
            this.put("database", DATABASE_FIELD);
            this.put("errorMessage", ERROR_MESSAGE_FIELD);
            this.put("projectId", PROJECT_ID_FIELD);
            this.put("technicalDescription", TECHNICAL_DESCRIPTION_FIELD);
            this.put("technicalName", TECHNICAL_NAME_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String dataAssetId;
    private final String dataAssetStatus;
    private final String dataSourceRunId;
    private final String database;
    private final DataSourceErrorMessage errorMessage;
    private final String projectId;
    private final String technicalDescription;
    private final String technicalName;
    private final Instant updatedAt;

    private DataSourceRunActivity(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.dataAssetId = builder.dataAssetId;
        this.dataAssetStatus = builder.dataAssetStatus;
        this.dataSourceRunId = builder.dataSourceRunId;
        this.database = builder.database;
        this.errorMessage = builder.errorMessage;
        this.projectId = builder.projectId;
        this.technicalDescription = builder.technicalDescription;
        this.technicalName = builder.technicalName;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String dataAssetId() {
        return this.dataAssetId;
    }

    public final DataAssetActivityStatus dataAssetStatus() {
        return DataAssetActivityStatus.fromValue(this.dataAssetStatus);
    }

    public final String dataAssetStatusAsString() {
        return this.dataAssetStatus;
    }

    public final String dataSourceRunId() {
        return this.dataSourceRunId;
    }

    public final String database() {
        return this.database;
    }

    public final DataSourceErrorMessage errorMessage() {
        return this.errorMessage;
    }

    public final String projectId() {
        return this.projectId;
    }

    public final String technicalDescription() {
        return this.technicalDescription;
    }

    public final String technicalName() {
        return this.technicalName;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAssetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataAssetStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceRunId());
        hashCode = 31 * hashCode + Objects.hashCode(this.database());
        hashCode = 31 * hashCode + Objects.hashCode(this.errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectId());
        hashCode = 31 * hashCode + Objects.hashCode(this.technicalDescription());
        hashCode = 31 * hashCode + Objects.hashCode(this.technicalName());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceRunActivity)) {
            return false;
        }
        DataSourceRunActivity other = (DataSourceRunActivity)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dataAssetId(), other.dataAssetId()) && Objects.equals(this.dataAssetStatusAsString(), other.dataAssetStatusAsString()) && Objects.equals(this.dataSourceRunId(), other.dataSourceRunId()) && Objects.equals(this.database(), other.database()) && Objects.equals(this.errorMessage(), other.errorMessage()) && Objects.equals(this.projectId(), other.projectId()) && Objects.equals(this.technicalDescription(), other.technicalDescription()) && Objects.equals(this.technicalName(), other.technicalName()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceRunActivity").add("CreatedAt", (Object)this.createdAt()).add("DataAssetId", (Object)this.dataAssetId()).add("DataAssetStatus", (Object)this.dataAssetStatusAsString()).add("DataSourceRunId", (Object)this.dataSourceRunId()).add("Database", (Object)(this.database() == null ? null : "*** Sensitive Data Redacted ***")).add("ErrorMessage", (Object)this.errorMessage()).add("ProjectId", (Object)this.projectId()).add("TechnicalDescription", (Object)(this.technicalDescription() == null ? null : "*** Sensitive Data Redacted ***")).add("TechnicalName", (Object)(this.technicalName() == null ? null : "*** Sensitive Data Redacted ***")).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "dataAssetId": {
                return Optional.ofNullable(clazz.cast(this.dataAssetId()));
            }
            case "dataAssetStatus": {
                return Optional.ofNullable(clazz.cast(this.dataAssetStatusAsString()));
            }
            case "dataSourceRunId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceRunId()));
            }
            case "database": {
                return Optional.ofNullable(clazz.cast(this.database()));
            }
            case "errorMessage": {
                return Optional.ofNullable(clazz.cast(this.errorMessage()));
            }
            case "projectId": {
                return Optional.ofNullable(clazz.cast(this.projectId()));
            }
            case "technicalDescription": {
                return Optional.ofNullable(clazz.cast(this.technicalDescription()));
            }
            case "technicalName": {
                return Optional.ofNullable(clazz.cast(this.technicalName()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceRunActivity, T> g) {
        return obj -> g.apply((DataSourceRunActivity)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String dataAssetId;
        private String dataAssetStatus;
        private String dataSourceRunId;
        private String database;
        private DataSourceErrorMessage errorMessage;
        private String projectId;
        private String technicalDescription;
        private String technicalName;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceRunActivity model) {
            this.createdAt(model.createdAt);
            this.dataAssetId(model.dataAssetId);
            this.dataAssetStatus(model.dataAssetStatus);
            this.dataSourceRunId(model.dataSourceRunId);
            this.database(model.database);
            this.errorMessage(model.errorMessage);
            this.projectId(model.projectId);
            this.technicalDescription(model.technicalDescription);
            this.technicalName(model.technicalName);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataAssetId() {
            return this.dataAssetId;
        }

        public final void setDataAssetId(String dataAssetId) {
            this.dataAssetId = dataAssetId;
        }

        @Override
        public final Builder dataAssetId(String dataAssetId) {
            this.dataAssetId = dataAssetId;
            return this;
        }

        public final String getDataAssetStatus() {
            return this.dataAssetStatus;
        }

        public final void setDataAssetStatus(String dataAssetStatus) {
            this.dataAssetStatus = dataAssetStatus;
        }

        @Override
        public final Builder dataAssetStatus(String dataAssetStatus) {
            this.dataAssetStatus = dataAssetStatus;
            return this;
        }

        @Override
        public final Builder dataAssetStatus(DataAssetActivityStatus dataAssetStatus) {
            this.dataAssetStatus(dataAssetStatus == null ? null : dataAssetStatus.toString());
            return this;
        }

        public final String getDataSourceRunId() {
            return this.dataSourceRunId;
        }

        public final void setDataSourceRunId(String dataSourceRunId) {
            this.dataSourceRunId = dataSourceRunId;
        }

        @Override
        public final Builder dataSourceRunId(String dataSourceRunId) {
            this.dataSourceRunId = dataSourceRunId;
            return this;
        }

        public final String getDatabase() {
            return this.database;
        }

        public final void setDatabase(String database) {
            this.database = database;
        }

        @Override
        public final Builder database(String database) {
            this.database = database;
            return this;
        }

        public final DataSourceErrorMessage.Builder getErrorMessage() {
            return this.errorMessage != null ? this.errorMessage.toBuilder() : null;
        }

        public final void setErrorMessage(DataSourceErrorMessage.BuilderImpl errorMessage) {
            this.errorMessage = errorMessage != null ? errorMessage.build() : null;
        }

        @Override
        public final Builder errorMessage(DataSourceErrorMessage errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getProjectId() {
            return this.projectId;
        }

        public final void setProjectId(String projectId) {
            this.projectId = projectId;
        }

        @Override
        public final Builder projectId(String projectId) {
            this.projectId = projectId;
            return this;
        }

        public final String getTechnicalDescription() {
            return this.technicalDescription;
        }

        public final void setTechnicalDescription(String technicalDescription) {
            this.technicalDescription = technicalDescription;
        }

        @Override
        public final Builder technicalDescription(String technicalDescription) {
            this.technicalDescription = technicalDescription;
            return this;
        }

        public final String getTechnicalName() {
            return this.technicalName;
        }

        public final void setTechnicalName(String technicalName) {
            this.technicalName = technicalName;
        }

        @Override
        public final Builder technicalName(String technicalName) {
            this.technicalName = technicalName;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public DataSourceRunActivity build() {
            return new DataSourceRunActivity(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceRunActivity> {
        public Builder createdAt(Instant var1);

        public Builder dataAssetId(String var1);

        public Builder dataAssetStatus(String var1);

        public Builder dataAssetStatus(DataAssetActivityStatus var1);

        public Builder dataSourceRunId(String var1);

        public Builder database(String var1);

        public Builder errorMessage(DataSourceErrorMessage var1);

        default public Builder errorMessage(Consumer<DataSourceErrorMessage.Builder> errorMessage) {
            return this.errorMessage((DataSourceErrorMessage)((DataSourceErrorMessage.Builder)DataSourceErrorMessage.builder().applyMutation(errorMessage)).build());
        }

        public Builder projectId(String var1);

        public Builder technicalDescription(String var1);

        public Builder technicalName(String var1);

        public Builder updatedAt(Instant var1);
    }
}

