/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.DataSourceErrorMessage;
import software.amazon.awssdk.services.datazone.model.DataSourceRunStatus;
import software.amazon.awssdk.services.datazone.model.DataSourceStatus;
import software.amazon.awssdk.services.datazone.model.EnableSetting;
import software.amazon.awssdk.services.datazone.model.ScheduleConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(DataSourceSummary.getter(DataSourceSummary::createdAt)).setter(DataSourceSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DATA_SOURCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataSourceId").getter(DataSourceSummary.getter(DataSourceSummary::dataSourceId)).setter(DataSourceSummary.setter(Builder::dataSourceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceId").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(DataSourceSummary.getter(DataSourceSummary::domainId)).setter(DataSourceSummary.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> ENABLE_SETTING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("enableSetting").getter(DataSourceSummary.getter(DataSourceSummary::enableSettingAsString)).setter(DataSourceSummary.setter(Builder::enableSetting)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableSetting").build()}).build();
    private static final SdkField<String> ENVIRONMENT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentId").getter(DataSourceSummary.getter(DataSourceSummary::environmentId)).setter(DataSourceSummary.setter(Builder::environmentId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentId").build()}).build();
    private static final SdkField<Integer> LAST_RUN_ASSET_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("lastRunAssetCount").getter(DataSourceSummary.getter(DataSourceSummary::lastRunAssetCount)).setter(DataSourceSummary.setter(Builder::lastRunAssetCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunAssetCount").build()}).build();
    private static final SdkField<Instant> LAST_RUN_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastRunAt").getter(DataSourceSummary.getter(DataSourceSummary::lastRunAt)).setter(DataSourceSummary.setter(Builder::lastRunAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<DataSourceErrorMessage> LAST_RUN_ERROR_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastRunErrorMessage").getter(DataSourceSummary.getter(DataSourceSummary::lastRunErrorMessage)).setter(DataSourceSummary.setter(Builder::lastRunErrorMessage)).constructor(DataSourceErrorMessage::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunErrorMessage").build()}).build();
    private static final SdkField<String> LAST_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastRunStatus").getter(DataSourceSummary.getter(DataSourceSummary::lastRunStatusAsString)).setter(DataSourceSummary.setter(Builder::lastRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastRunStatus").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(DataSourceSummary.getter(DataSourceSummary::name)).setter(DataSourceSummary.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ScheduleConfiguration> SCHEDULE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("schedule").getter(DataSourceSummary.getter(DataSourceSummary::schedule)).setter(DataSourceSummary.setter(Builder::schedule)).constructor(ScheduleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schedule").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DataSourceSummary.getter(DataSourceSummary::statusAsString)).setter(DataSourceSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(DataSourceSummary.getter(DataSourceSummary::type)).setter(DataSourceSummary.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(DataSourceSummary.getter(DataSourceSummary::updatedAt)).setter(DataSourceSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DATA_SOURCE_ID_FIELD, DOMAIN_ID_FIELD, ENABLE_SETTING_FIELD, ENVIRONMENT_ID_FIELD, LAST_RUN_ASSET_COUNT_FIELD, LAST_RUN_AT_FIELD, LAST_RUN_ERROR_MESSAGE_FIELD, LAST_RUN_STATUS_FIELD, NAME_FIELD, SCHEDULE_FIELD, STATUS_FIELD, TYPE_FIELD, UPDATED_AT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("dataSourceId", DATA_SOURCE_ID_FIELD);
            this.put("domainId", DOMAIN_ID_FIELD);
            this.put("enableSetting", ENABLE_SETTING_FIELD);
            this.put("environmentId", ENVIRONMENT_ID_FIELD);
            this.put("lastRunAssetCount", LAST_RUN_ASSET_COUNT_FIELD);
            this.put("lastRunAt", LAST_RUN_AT_FIELD);
            this.put("lastRunErrorMessage", LAST_RUN_ERROR_MESSAGE_FIELD);
            this.put("lastRunStatus", LAST_RUN_STATUS_FIELD);
            this.put("name", NAME_FIELD);
            this.put("schedule", SCHEDULE_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("type", TYPE_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String dataSourceId;
    private final String domainId;
    private final String enableSetting;
    private final String environmentId;
    private final Integer lastRunAssetCount;
    private final Instant lastRunAt;
    private final DataSourceErrorMessage lastRunErrorMessage;
    private final String lastRunStatus;
    private final String name;
    private final ScheduleConfiguration schedule;
    private final String status;
    private final String type;
    private final Instant updatedAt;

    private DataSourceSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.dataSourceId = builder.dataSourceId;
        this.domainId = builder.domainId;
        this.enableSetting = builder.enableSetting;
        this.environmentId = builder.environmentId;
        this.lastRunAssetCount = builder.lastRunAssetCount;
        this.lastRunAt = builder.lastRunAt;
        this.lastRunErrorMessage = builder.lastRunErrorMessage;
        this.lastRunStatus = builder.lastRunStatus;
        this.name = builder.name;
        this.schedule = builder.schedule;
        this.status = builder.status;
        this.type = builder.type;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String dataSourceId() {
        return this.dataSourceId;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final EnableSetting enableSetting() {
        return EnableSetting.fromValue(this.enableSetting);
    }

    public final String enableSettingAsString() {
        return this.enableSetting;
    }

    public final String environmentId() {
        return this.environmentId;
    }

    public final Integer lastRunAssetCount() {
        return this.lastRunAssetCount;
    }

    public final Instant lastRunAt() {
        return this.lastRunAt;
    }

    public final DataSourceErrorMessage lastRunErrorMessage() {
        return this.lastRunErrorMessage;
    }

    public final DataSourceRunStatus lastRunStatus() {
        return DataSourceRunStatus.fromValue(this.lastRunStatus);
    }

    public final String lastRunStatusAsString() {
        return this.lastRunStatus;
    }

    public final String name() {
        return this.name;
    }

    public final ScheduleConfiguration schedule() {
        return this.schedule;
    }

    public final DataSourceStatus status() {
        return DataSourceStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String type() {
        return this.type;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataSourceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableSettingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentId());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunAssetCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunErrorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.schedule());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.type());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceSummary)) {
            return false;
        }
        DataSourceSummary other = (DataSourceSummary)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.dataSourceId(), other.dataSourceId()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.enableSettingAsString(), other.enableSettingAsString()) && Objects.equals(this.environmentId(), other.environmentId()) && Objects.equals(this.lastRunAssetCount(), other.lastRunAssetCount()) && Objects.equals(this.lastRunAt(), other.lastRunAt()) && Objects.equals(this.lastRunErrorMessage(), other.lastRunErrorMessage()) && Objects.equals(this.lastRunStatusAsString(), other.lastRunStatusAsString()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.schedule(), other.schedule()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.type(), other.type()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceSummary").add("CreatedAt", (Object)this.createdAt()).add("DataSourceId", (Object)this.dataSourceId()).add("DomainId", (Object)this.domainId()).add("EnableSetting", (Object)this.enableSettingAsString()).add("EnvironmentId", (Object)this.environmentId()).add("LastRunAssetCount", (Object)this.lastRunAssetCount()).add("LastRunAt", (Object)this.lastRunAt()).add("LastRunErrorMessage", (Object)this.lastRunErrorMessage()).add("LastRunStatus", (Object)this.lastRunStatusAsString()).add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Schedule", (Object)(this.schedule() == null ? null : "*** Sensitive Data Redacted ***")).add("Status", (Object)this.statusAsString()).add("Type", (Object)this.type()).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "dataSourceId": {
                return Optional.ofNullable(clazz.cast(this.dataSourceId()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "enableSetting": {
                return Optional.ofNullable(clazz.cast(this.enableSettingAsString()));
            }
            case "environmentId": {
                return Optional.ofNullable(clazz.cast(this.environmentId()));
            }
            case "lastRunAssetCount": {
                return Optional.ofNullable(clazz.cast(this.lastRunAssetCount()));
            }
            case "lastRunAt": {
                return Optional.ofNullable(clazz.cast(this.lastRunAt()));
            }
            case "lastRunErrorMessage": {
                return Optional.ofNullable(clazz.cast(this.lastRunErrorMessage()));
            }
            case "lastRunStatus": {
                return Optional.ofNullable(clazz.cast(this.lastRunStatusAsString()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "schedule": {
                return Optional.ofNullable(clazz.cast(this.schedule()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.type()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceSummary, T> g) {
        return obj -> g.apply((DataSourceSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String dataSourceId;
        private String domainId;
        private String enableSetting;
        private String environmentId;
        private Integer lastRunAssetCount;
        private Instant lastRunAt;
        private DataSourceErrorMessage lastRunErrorMessage;
        private String lastRunStatus;
        private String name;
        private ScheduleConfiguration schedule;
        private String status;
        private String type;
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceSummary model) {
            this.createdAt(model.createdAt);
            this.dataSourceId(model.dataSourceId);
            this.domainId(model.domainId);
            this.enableSetting(model.enableSetting);
            this.environmentId(model.environmentId);
            this.lastRunAssetCount(model.lastRunAssetCount);
            this.lastRunAt(model.lastRunAt);
            this.lastRunErrorMessage(model.lastRunErrorMessage);
            this.lastRunStatus(model.lastRunStatus);
            this.name(model.name);
            this.schedule(model.schedule);
            this.status(model.status);
            this.type(model.type);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDataSourceId() {
            return this.dataSourceId;
        }

        public final void setDataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
        }

        @Override
        public final Builder dataSourceId(String dataSourceId) {
            this.dataSourceId = dataSourceId;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getEnableSetting() {
            return this.enableSetting;
        }

        public final void setEnableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
        }

        @Override
        public final Builder enableSetting(String enableSetting) {
            this.enableSetting = enableSetting;
            return this;
        }

        @Override
        public final Builder enableSetting(EnableSetting enableSetting) {
            this.enableSetting(enableSetting == null ? null : enableSetting.toString());
            return this;
        }

        public final String getEnvironmentId() {
            return this.environmentId;
        }

        public final void setEnvironmentId(String environmentId) {
            this.environmentId = environmentId;
        }

        @Override
        public final Builder environmentId(String environmentId) {
            this.environmentId = environmentId;
            return this;
        }

        public final Integer getLastRunAssetCount() {
            return this.lastRunAssetCount;
        }

        public final void setLastRunAssetCount(Integer lastRunAssetCount) {
            this.lastRunAssetCount = lastRunAssetCount;
        }

        @Override
        public final Builder lastRunAssetCount(Integer lastRunAssetCount) {
            this.lastRunAssetCount = lastRunAssetCount;
            return this;
        }

        public final Instant getLastRunAt() {
            return this.lastRunAt;
        }

        public final void setLastRunAt(Instant lastRunAt) {
            this.lastRunAt = lastRunAt;
        }

        @Override
        public final Builder lastRunAt(Instant lastRunAt) {
            this.lastRunAt = lastRunAt;
            return this;
        }

        public final DataSourceErrorMessage.Builder getLastRunErrorMessage() {
            return this.lastRunErrorMessage != null ? this.lastRunErrorMessage.toBuilder() : null;
        }

        public final void setLastRunErrorMessage(DataSourceErrorMessage.BuilderImpl lastRunErrorMessage) {
            this.lastRunErrorMessage = lastRunErrorMessage != null ? lastRunErrorMessage.build() : null;
        }

        @Override
        public final Builder lastRunErrorMessage(DataSourceErrorMessage lastRunErrorMessage) {
            this.lastRunErrorMessage = lastRunErrorMessage;
            return this;
        }

        public final String getLastRunStatus() {
            return this.lastRunStatus;
        }

        public final void setLastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
        }

        @Override
        public final Builder lastRunStatus(String lastRunStatus) {
            this.lastRunStatus = lastRunStatus;
            return this;
        }

        @Override
        public final Builder lastRunStatus(DataSourceRunStatus lastRunStatus) {
            this.lastRunStatus(lastRunStatus == null ? null : lastRunStatus.toString());
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ScheduleConfiguration.Builder getSchedule() {
            return this.schedule != null ? this.schedule.toBuilder() : null;
        }

        public final void setSchedule(ScheduleConfiguration.BuilderImpl schedule) {
            this.schedule = schedule != null ? schedule.build() : null;
        }

        @Override
        public final Builder schedule(ScheduleConfiguration schedule) {
            this.schedule = schedule;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(DataSourceStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public DataSourceSummary build() {
            return new DataSourceSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceSummary> {
        public Builder createdAt(Instant var1);

        public Builder dataSourceId(String var1);

        public Builder domainId(String var1);

        public Builder enableSetting(String var1);

        public Builder enableSetting(EnableSetting var1);

        public Builder environmentId(String var1);

        public Builder lastRunAssetCount(Integer var1);

        public Builder lastRunAt(Instant var1);

        public Builder lastRunErrorMessage(DataSourceErrorMessage var1);

        default public Builder lastRunErrorMessage(Consumer<DataSourceErrorMessage.Builder> lastRunErrorMessage) {
            return this.lastRunErrorMessage((DataSourceErrorMessage)((DataSourceErrorMessage.Builder)DataSourceErrorMessage.builder().applyMutation(lastRunErrorMessage)).build());
        }

        public Builder lastRunStatus(String var1);

        public Builder lastRunStatus(DataSourceRunStatus var1);

        public Builder name(String var1);

        public Builder schedule(ScheduleConfiguration var1);

        default public Builder schedule(Consumer<ScheduleConfiguration.Builder> schedule) {
            return this.schedule((ScheduleConfiguration)((ScheduleConfiguration.Builder)ScheduleConfiguration.builder().applyMutation(schedule)).build());
        }

        public Builder status(String var1);

        public Builder status(DataSourceStatus var1);

        public Builder type(String var1);

        public Builder updatedAt(Instant var1);
    }
}

