/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.datazone.model.AssetScope;
import software.amazon.awssdk.services.datazone.model.FailureCause;
import software.amazon.awssdk.services.datazone.model.SubscriptionGrantStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribedAsset
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscribedAsset> {
    private static final SdkField<String> ASSET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetId").getter(SubscribedAsset.getter(SubscribedAsset::assetId)).setter(SubscribedAsset.setter(Builder::assetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetId").build()}).build();
    private static final SdkField<String> ASSET_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("assetRevision").getter(SubscribedAsset.getter(SubscribedAsset::assetRevision)).setter(SubscribedAsset.setter(Builder::assetRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetRevision").build()}).build();
    private static final SdkField<AssetScope> ASSET_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetScope").getter(SubscribedAsset.getter(SubscribedAsset::assetScope)).setter(SubscribedAsset.setter(Builder::assetScope)).constructor(AssetScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetScope").build()}).build();
    private static final SdkField<FailureCause> FAILURE_CAUSE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("failureCause").getter(SubscribedAsset.getter(SubscribedAsset::failureCause)).setter(SubscribedAsset.setter(Builder::failureCause)).constructor(FailureCause::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureCause").build()}).build();
    private static final SdkField<Instant> FAILURE_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("failureTimestamp").getter(SubscribedAsset.getter(SubscribedAsset::failureTimestamp)).setter(SubscribedAsset.setter(Builder::failureTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureTimestamp").build()}).build();
    private static final SdkField<Instant> GRANTED_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("grantedTimestamp").getter(SubscribedAsset.getter(SubscribedAsset::grantedTimestamp)).setter(SubscribedAsset.setter(Builder::grantedTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("grantedTimestamp").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(SubscribedAsset.getter(SubscribedAsset::statusAsString)).setter(SubscribedAsset.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> TARGET_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetName").getter(SubscribedAsset.getter(SubscribedAsset::targetName)).setter(SubscribedAsset.setter(Builder::targetName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_ID_FIELD, ASSET_REVISION_FIELD, ASSET_SCOPE_FIELD, FAILURE_CAUSE_FIELD, FAILURE_TIMESTAMP_FIELD, GRANTED_TIMESTAMP_FIELD, STATUS_FIELD, TARGET_NAME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assetId", ASSET_ID_FIELD);
            this.put("assetRevision", ASSET_REVISION_FIELD);
            this.put("assetScope", ASSET_SCOPE_FIELD);
            this.put("failureCause", FAILURE_CAUSE_FIELD);
            this.put("failureTimestamp", FAILURE_TIMESTAMP_FIELD);
            this.put("grantedTimestamp", GRANTED_TIMESTAMP_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("targetName", TARGET_NAME_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String assetId;
    private final String assetRevision;
    private final AssetScope assetScope;
    private final FailureCause failureCause;
    private final Instant failureTimestamp;
    private final Instant grantedTimestamp;
    private final String status;
    private final String targetName;

    private SubscribedAsset(BuilderImpl builder) {
        this.assetId = builder.assetId;
        this.assetRevision = builder.assetRevision;
        this.assetScope = builder.assetScope;
        this.failureCause = builder.failureCause;
        this.failureTimestamp = builder.failureTimestamp;
        this.grantedTimestamp = builder.grantedTimestamp;
        this.status = builder.status;
        this.targetName = builder.targetName;
    }

    public final String assetId() {
        return this.assetId;
    }

    public final String assetRevision() {
        return this.assetRevision;
    }

    public final AssetScope assetScope() {
        return this.assetScope;
    }

    public final FailureCause failureCause() {
        return this.failureCause;
    }

    public final Instant failureTimestamp() {
        return this.failureTimestamp;
    }

    public final Instant grantedTimestamp() {
        return this.grantedTimestamp;
    }

    public final SubscriptionGrantStatus status() {
        return SubscriptionGrantStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final String targetName() {
        return this.targetName;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.assetScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureCause());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.grantedTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedAsset)) {
            return false;
        }
        SubscribedAsset other = (SubscribedAsset)obj;
        return Objects.equals(this.assetId(), other.assetId()) && Objects.equals(this.assetRevision(), other.assetRevision()) && Objects.equals(this.assetScope(), other.assetScope()) && Objects.equals(this.failureCause(), other.failureCause()) && Objects.equals(this.failureTimestamp(), other.failureTimestamp()) && Objects.equals(this.grantedTimestamp(), other.grantedTimestamp()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.targetName(), other.targetName());
    }

    public final String toString() {
        return ToString.builder((String)"SubscribedAsset").add("AssetId", (Object)this.assetId()).add("AssetRevision", (Object)this.assetRevision()).add("AssetScope", (Object)this.assetScope()).add("FailureCause", (Object)this.failureCause()).add("FailureTimestamp", (Object)this.failureTimestamp()).add("GrantedTimestamp", (Object)this.grantedTimestamp()).add("Status", (Object)this.statusAsString()).add("TargetName", (Object)this.targetName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetId": {
                return Optional.ofNullable(clazz.cast(this.assetId()));
            }
            case "assetRevision": {
                return Optional.ofNullable(clazz.cast(this.assetRevision()));
            }
            case "assetScope": {
                return Optional.ofNullable(clazz.cast(this.assetScope()));
            }
            case "failureCause": {
                return Optional.ofNullable(clazz.cast(this.failureCause()));
            }
            case "failureTimestamp": {
                return Optional.ofNullable(clazz.cast(this.failureTimestamp()));
            }
            case "grantedTimestamp": {
                return Optional.ofNullable(clazz.cast(this.grantedTimestamp()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "targetName": {
                return Optional.ofNullable(clazz.cast(this.targetName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SubscribedAsset, T> g) {
        return obj -> g.apply((SubscribedAsset)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String assetId;
        private String assetRevision;
        private AssetScope assetScope;
        private FailureCause failureCause;
        private Instant failureTimestamp;
        private Instant grantedTimestamp;
        private String status;
        private String targetName;

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedAsset model) {
            this.assetId(model.assetId);
            this.assetRevision(model.assetRevision);
            this.assetScope(model.assetScope);
            this.failureCause(model.failureCause);
            this.failureTimestamp(model.failureTimestamp);
            this.grantedTimestamp(model.grantedTimestamp);
            this.status(model.status);
            this.targetName(model.targetName);
        }

        public final String getAssetId() {
            return this.assetId;
        }

        public final void setAssetId(String assetId) {
            this.assetId = assetId;
        }

        @Override
        public final Builder assetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public final String getAssetRevision() {
            return this.assetRevision;
        }

        public final void setAssetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
        }

        @Override
        public final Builder assetRevision(String assetRevision) {
            this.assetRevision = assetRevision;
            return this;
        }

        public final AssetScope.Builder getAssetScope() {
            return this.assetScope != null ? this.assetScope.toBuilder() : null;
        }

        public final void setAssetScope(AssetScope.BuilderImpl assetScope) {
            this.assetScope = assetScope != null ? assetScope.build() : null;
        }

        @Override
        public final Builder assetScope(AssetScope assetScope) {
            this.assetScope = assetScope;
            return this;
        }

        public final FailureCause.Builder getFailureCause() {
            return this.failureCause != null ? this.failureCause.toBuilder() : null;
        }

        public final void setFailureCause(FailureCause.BuilderImpl failureCause) {
            this.failureCause = failureCause != null ? failureCause.build() : null;
        }

        @Override
        public final Builder failureCause(FailureCause failureCause) {
            this.failureCause = failureCause;
            return this;
        }

        public final Instant getFailureTimestamp() {
            return this.failureTimestamp;
        }

        public final void setFailureTimestamp(Instant failureTimestamp) {
            this.failureTimestamp = failureTimestamp;
        }

        @Override
        public final Builder failureTimestamp(Instant failureTimestamp) {
            this.failureTimestamp = failureTimestamp;
            return this;
        }

        public final Instant getGrantedTimestamp() {
            return this.grantedTimestamp;
        }

        public final void setGrantedTimestamp(Instant grantedTimestamp) {
            this.grantedTimestamp = grantedTimestamp;
        }

        @Override
        public final Builder grantedTimestamp(Instant grantedTimestamp) {
            this.grantedTimestamp = grantedTimestamp;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionGrantStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getTargetName() {
            return this.targetName;
        }

        public final void setTargetName(String targetName) {
            this.targetName = targetName;
        }

        @Override
        public final Builder targetName(String targetName) {
            this.targetName = targetName;
            return this;
        }

        public SubscribedAsset build() {
            return new SubscribedAsset(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscribedAsset> {
        public Builder assetId(String var1);

        public Builder assetRevision(String var1);

        public Builder assetScope(AssetScope var1);

        default public Builder assetScope(Consumer<AssetScope.Builder> assetScope) {
            return this.assetScope((AssetScope)((AssetScope.Builder)AssetScope.builder().applyMutation(assetScope)).build());
        }

        public Builder failureCause(FailureCause var1);

        default public Builder failureCause(Consumer<FailureCause.Builder> failureCause) {
            return this.failureCause((FailureCause)((FailureCause.Builder)FailureCause.builder().applyMutation(failureCause)).build());
        }

        public Builder failureTimestamp(Instant var1);

        public Builder grantedTimestamp(Instant var1);

        public Builder status(String var1);

        public Builder status(SubscriptionGrantStatus var1);

        public Builder targetName(String var1);
    }
}

