/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.AssetTypeItem;
import software.amazon.awssdk.services.datazone.model.FormTypeData;
import software.amazon.awssdk.services.datazone.model.LineageNodeTypeItem;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SearchTypesResultItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SearchTypesResultItem> {
    private static final SdkField<AssetTypeItem> ASSET_TYPE_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetTypeItem").getter(SearchTypesResultItem.getter(SearchTypesResultItem::assetTypeItem)).setter(SearchTypesResultItem.setter(Builder::assetTypeItem)).constructor(AssetTypeItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetTypeItem").build()}).build();
    private static final SdkField<FormTypeData> FORM_TYPE_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("formTypeItem").getter(SearchTypesResultItem.getter(SearchTypesResultItem::formTypeItem)).setter(SearchTypesResultItem.setter(Builder::formTypeItem)).constructor(FormTypeData::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("formTypeItem").build()}).build();
    private static final SdkField<LineageNodeTypeItem> LINEAGE_NODE_TYPE_ITEM_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lineageNodeTypeItem").getter(SearchTypesResultItem.getter(SearchTypesResultItem::lineageNodeTypeItem)).setter(SearchTypesResultItem.setter(Builder::lineageNodeTypeItem)).constructor(LineageNodeTypeItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lineageNodeTypeItem").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_TYPE_ITEM_FIELD, FORM_TYPE_ITEM_FIELD, LINEAGE_NODE_TYPE_ITEM_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assetTypeItem", ASSET_TYPE_ITEM_FIELD);
            this.put("formTypeItem", FORM_TYPE_ITEM_FIELD);
            this.put("lineageNodeTypeItem", LINEAGE_NODE_TYPE_ITEM_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AssetTypeItem assetTypeItem;
    private final FormTypeData formTypeItem;
    private final LineageNodeTypeItem lineageNodeTypeItem;
    private final Type type;

    private SearchTypesResultItem(BuilderImpl builder) {
        this.assetTypeItem = builder.assetTypeItem;
        this.formTypeItem = builder.formTypeItem;
        this.lineageNodeTypeItem = builder.lineageNodeTypeItem;
        this.type = builder.type;
    }

    public final AssetTypeItem assetTypeItem() {
        return this.assetTypeItem;
    }

    public final FormTypeData formTypeItem() {
        return this.formTypeItem;
    }

    public final LineageNodeTypeItem lineageNodeTypeItem() {
        return this.lineageNodeTypeItem;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetTypeItem());
        hashCode = 31 * hashCode + Objects.hashCode(this.formTypeItem());
        hashCode = 31 * hashCode + Objects.hashCode(this.lineageNodeTypeItem());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchTypesResultItem)) {
            return false;
        }
        SearchTypesResultItem other = (SearchTypesResultItem)obj;
        return Objects.equals(this.assetTypeItem(), other.assetTypeItem()) && Objects.equals(this.formTypeItem(), other.formTypeItem()) && Objects.equals(this.lineageNodeTypeItem(), other.lineageNodeTypeItem());
    }

    public final String toString() {
        return ToString.builder((String)"SearchTypesResultItem").add("AssetTypeItem", (Object)this.assetTypeItem()).add("FormTypeItem", (Object)this.formTypeItem()).add("LineageNodeTypeItem", (Object)this.lineageNodeTypeItem()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetTypeItem": {
                return Optional.ofNullable(clazz.cast(this.assetTypeItem()));
            }
            case "formTypeItem": {
                return Optional.ofNullable(clazz.cast(this.formTypeItem()));
            }
            case "lineageNodeTypeItem": {
                return Optional.ofNullable(clazz.cast(this.lineageNodeTypeItem()));
            }
        }
        return Optional.empty();
    }

    public static SearchTypesResultItem fromAssetTypeItem(AssetTypeItem assetTypeItem) {
        return (SearchTypesResultItem)SearchTypesResultItem.builder().assetTypeItem(assetTypeItem).build();
    }

    public static SearchTypesResultItem fromAssetTypeItem(Consumer<AssetTypeItem.Builder> assetTypeItem) {
        AssetTypeItem.Builder builder = AssetTypeItem.builder();
        assetTypeItem.accept(builder);
        return SearchTypesResultItem.fromAssetTypeItem((AssetTypeItem)builder.build());
    }

    public static SearchTypesResultItem fromFormTypeItem(FormTypeData formTypeItem) {
        return (SearchTypesResultItem)SearchTypesResultItem.builder().formTypeItem(formTypeItem).build();
    }

    public static SearchTypesResultItem fromFormTypeItem(Consumer<FormTypeData.Builder> formTypeItem) {
        FormTypeData.Builder builder = FormTypeData.builder();
        formTypeItem.accept(builder);
        return SearchTypesResultItem.fromFormTypeItem((FormTypeData)builder.build());
    }

    public static SearchTypesResultItem fromLineageNodeTypeItem(LineageNodeTypeItem lineageNodeTypeItem) {
        return (SearchTypesResultItem)SearchTypesResultItem.builder().lineageNodeTypeItem(lineageNodeTypeItem).build();
    }

    public static SearchTypesResultItem fromLineageNodeTypeItem(Consumer<LineageNodeTypeItem.Builder> lineageNodeTypeItem) {
        LineageNodeTypeItem.Builder builder = LineageNodeTypeItem.builder();
        lineageNodeTypeItem.accept(builder);
        return SearchTypesResultItem.fromLineageNodeTypeItem((LineageNodeTypeItem)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<SearchTypesResultItem, T> g) {
        return obj -> g.apply((SearchTypesResultItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        ASSET_TYPE_ITEM,
        FORM_TYPE_ITEM,
        LINEAGE_NODE_TYPE_ITEM,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private AssetTypeItem assetTypeItem;
        private FormTypeData formTypeItem;
        private LineageNodeTypeItem lineageNodeTypeItem;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SearchTypesResultItem model) {
            this.assetTypeItem(model.assetTypeItem);
            this.formTypeItem(model.formTypeItem);
            this.lineageNodeTypeItem(model.lineageNodeTypeItem);
        }

        public final AssetTypeItem.Builder getAssetTypeItem() {
            return this.assetTypeItem != null ? this.assetTypeItem.toBuilder() : null;
        }

        public final void setAssetTypeItem(AssetTypeItem.BuilderImpl assetTypeItem) {
            AssetTypeItem oldValue = this.assetTypeItem;
            this.assetTypeItem = assetTypeItem != null ? assetTypeItem.build() : null;
            this.handleUnionValueChange(Type.ASSET_TYPE_ITEM, oldValue, this.assetTypeItem);
        }

        @Override
        public final Builder assetTypeItem(AssetTypeItem assetTypeItem) {
            AssetTypeItem oldValue = this.assetTypeItem;
            this.assetTypeItem = assetTypeItem;
            this.handleUnionValueChange(Type.ASSET_TYPE_ITEM, oldValue, this.assetTypeItem);
            return this;
        }

        public final FormTypeData.Builder getFormTypeItem() {
            return this.formTypeItem != null ? this.formTypeItem.toBuilder() : null;
        }

        public final void setFormTypeItem(FormTypeData.BuilderImpl formTypeItem) {
            FormTypeData oldValue = this.formTypeItem;
            this.formTypeItem = formTypeItem != null ? formTypeItem.build() : null;
            this.handleUnionValueChange(Type.FORM_TYPE_ITEM, oldValue, this.formTypeItem);
        }

        @Override
        public final Builder formTypeItem(FormTypeData formTypeItem) {
            FormTypeData oldValue = this.formTypeItem;
            this.formTypeItem = formTypeItem;
            this.handleUnionValueChange(Type.FORM_TYPE_ITEM, oldValue, this.formTypeItem);
            return this;
        }

        public final LineageNodeTypeItem.Builder getLineageNodeTypeItem() {
            return this.lineageNodeTypeItem != null ? this.lineageNodeTypeItem.toBuilder() : null;
        }

        public final void setLineageNodeTypeItem(LineageNodeTypeItem.BuilderImpl lineageNodeTypeItem) {
            LineageNodeTypeItem oldValue = this.lineageNodeTypeItem;
            this.lineageNodeTypeItem = lineageNodeTypeItem != null ? lineageNodeTypeItem.build() : null;
            this.handleUnionValueChange(Type.LINEAGE_NODE_TYPE_ITEM, oldValue, this.lineageNodeTypeItem);
        }

        @Override
        public final Builder lineageNodeTypeItem(LineageNodeTypeItem lineageNodeTypeItem) {
            LineageNodeTypeItem oldValue = this.lineageNodeTypeItem;
            this.lineageNodeTypeItem = lineageNodeTypeItem;
            this.handleUnionValueChange(Type.LINEAGE_NODE_TYPE_ITEM, oldValue, this.lineageNodeTypeItem);
            return this;
        }

        public SearchTypesResultItem build() {
            return new SearchTypesResultItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SearchTypesResultItem> {
        public Builder assetTypeItem(AssetTypeItem var1);

        default public Builder assetTypeItem(Consumer<AssetTypeItem.Builder> assetTypeItem) {
            return this.assetTypeItem((AssetTypeItem)((AssetTypeItem.Builder)AssetTypeItem.builder().applyMutation(assetTypeItem)).build());
        }

        public Builder formTypeItem(FormTypeData var1);

        default public Builder formTypeItem(Consumer<FormTypeData.Builder> formTypeItem) {
            return this.formTypeItem((FormTypeData)((FormTypeData.Builder)FormTypeData.builder().applyMutation(formTypeItem)).build());
        }

        public Builder lineageNodeTypeItem(LineageNodeTypeItem var1);

        default public Builder lineageNodeTypeItem(Consumer<LineageNodeTypeItem.Builder> lineageNodeTypeItem) {
            return this.lineageNodeTypeItem((LineageNodeTypeItem)((LineageNodeTypeItem.Builder)LineageNodeTypeItem.builder().applyMutation(lineageNodeTypeItem)).build());
        }
    }
}

