/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestOutputSubscribedListingsListCopier;
import software.amazon.awssdk.services.datazone.model.AcceptSubscriptionRequestOutputSubscribedPrincipalsListCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.SubscribedListing;
import software.amazon.awssdk.services.datazone.model.SubscribedPrincipal;
import software.amazon.awssdk.services.datazone.model.SubscriptionRequestStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptSubscriptionRequestResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, AcceptSubscriptionRequestResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::createdAt)).setter(AcceptSubscriptionRequestResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::createdBy)).setter(AcceptSubscriptionRequestResponse.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<String> DECISION_COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decisionComment").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::decisionComment)).setter(AcceptSubscriptionRequestResponse.setter(Builder::decisionComment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionComment").build()}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::domainId)).setter(AcceptSubscriptionRequestResponse.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::id)).setter(AcceptSubscriptionRequestResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> REQUEST_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("requestReason").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::requestReason)).setter(AcceptSubscriptionRequestResponse.setter(Builder::requestReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestReason").build()}).build();
    private static final SdkField<String> REVIEWER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("reviewerId").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::reviewerId)).setter(AcceptSubscriptionRequestResponse.setter(Builder::reviewerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reviewerId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::statusAsString)).setter(AcceptSubscriptionRequestResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<List<SubscribedListing>> SUBSCRIBED_LISTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subscribedListings").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::subscribedListings)).setter(AcceptSubscriptionRequestResponse.setter(Builder::subscribedListings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedListings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubscribedListing::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<SubscribedPrincipal>> SUBSCRIBED_PRINCIPALS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("subscribedPrincipals").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::subscribedPrincipals)).setter(AcceptSubscriptionRequestResponse.setter(Builder::subscribedPrincipals)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("subscribedPrincipals").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SubscribedPrincipal::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::updatedAt)).setter(AcceptSubscriptionRequestResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build()}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(AcceptSubscriptionRequestResponse.getter(AcceptSubscriptionRequestResponse::updatedBy)).setter(AcceptSubscriptionRequestResponse.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, CREATED_BY_FIELD, DECISION_COMMENT_FIELD, DOMAIN_ID_FIELD, ID_FIELD, REQUEST_REASON_FIELD, REVIEWER_ID_FIELD, STATUS_FIELD, SUBSCRIBED_LISTINGS_FIELD, SUBSCRIBED_PRINCIPALS_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("createdAt", CREATED_AT_FIELD);
            this.put("createdBy", CREATED_BY_FIELD);
            this.put("decisionComment", DECISION_COMMENT_FIELD);
            this.put("domainId", DOMAIN_ID_FIELD);
            this.put("id", ID_FIELD);
            this.put("requestReason", REQUEST_REASON_FIELD);
            this.put("reviewerId", REVIEWER_ID_FIELD);
            this.put("status", STATUS_FIELD);
            this.put("subscribedListings", SUBSCRIBED_LISTINGS_FIELD);
            this.put("subscribedPrincipals", SUBSCRIBED_PRINCIPALS_FIELD);
            this.put("updatedAt", UPDATED_AT_FIELD);
            this.put("updatedBy", UPDATED_BY_FIELD);
        }
    });
    private final Instant createdAt;
    private final String createdBy;
    private final String decisionComment;
    private final String domainId;
    private final String id;
    private final String requestReason;
    private final String reviewerId;
    private final String status;
    private final List<SubscribedListing> subscribedListings;
    private final List<SubscribedPrincipal> subscribedPrincipals;
    private final Instant updatedAt;
    private final String updatedBy;

    private AcceptSubscriptionRequestResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.decisionComment = builder.decisionComment;
        this.domainId = builder.domainId;
        this.id = builder.id;
        this.requestReason = builder.requestReason;
        this.reviewerId = builder.reviewerId;
        this.status = builder.status;
        this.subscribedListings = builder.subscribedListings;
        this.subscribedPrincipals = builder.subscribedPrincipals;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final String decisionComment() {
        return this.decisionComment;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final String id() {
        return this.id;
    }

    public final String requestReason() {
        return this.requestReason;
    }

    public final String reviewerId() {
        return this.reviewerId;
    }

    public final SubscriptionRequestStatus status() {
        return SubscriptionRequestStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final boolean hasSubscribedListings() {
        return this.subscribedListings != null && !(this.subscribedListings instanceof SdkAutoConstructList);
    }

    public final List<SubscribedListing> subscribedListings() {
        return this.subscribedListings;
    }

    public final boolean hasSubscribedPrincipals() {
        return this.subscribedPrincipals != null && !(this.subscribedPrincipals instanceof SdkAutoConstructList);
    }

    public final List<SubscribedPrincipal> subscribedPrincipals() {
        return this.subscribedPrincipals;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.decisionComment());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.reviewerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribedListings() ? this.subscribedListings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubscribedPrincipals() ? this.subscribedPrincipals() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptSubscriptionRequestResponse)) {
            return false;
        }
        AcceptSubscriptionRequestResponse other = (AcceptSubscriptionRequestResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.decisionComment(), other.decisionComment()) && Objects.equals(this.domainId(), other.domainId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.requestReason(), other.requestReason()) && Objects.equals(this.reviewerId(), other.reviewerId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && this.hasSubscribedListings() == other.hasSubscribedListings() && Objects.equals(this.subscribedListings(), other.subscribedListings()) && this.hasSubscribedPrincipals() == other.hasSubscribedPrincipals() && Objects.equals(this.subscribedPrincipals(), other.subscribedPrincipals()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptSubscriptionRequestResponse").add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("DecisionComment", (Object)(this.decisionComment() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainId", (Object)this.domainId()).add("Id", (Object)this.id()).add("RequestReason", (Object)(this.requestReason() == null ? null : "*** Sensitive Data Redacted ***")).add("ReviewerId", (Object)this.reviewerId()).add("Status", (Object)this.statusAsString()).add("SubscribedListings", this.hasSubscribedListings() ? this.subscribedListings() : null).add("SubscribedPrincipals", this.hasSubscribedPrincipals() ? this.subscribedPrincipals() : null).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "decisionComment": {
                return Optional.ofNullable(clazz.cast(this.decisionComment()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "requestReason": {
                return Optional.ofNullable(clazz.cast(this.requestReason()));
            }
            case "reviewerId": {
                return Optional.ofNullable(clazz.cast(this.reviewerId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "subscribedListings": {
                return Optional.ofNullable(clazz.cast(this.subscribedListings()));
            }
            case "subscribedPrincipals": {
                return Optional.ofNullable(clazz.cast(this.subscribedPrincipals()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AcceptSubscriptionRequestResponse, T> g) {
        return obj -> g.apply((AcceptSubscriptionRequestResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String createdBy;
        private String decisionComment;
        private String domainId;
        private String id;
        private String requestReason;
        private String reviewerId;
        private String status;
        private List<SubscribedListing> subscribedListings = DefaultSdkAutoConstructList.getInstance();
        private List<SubscribedPrincipal> subscribedPrincipals = DefaultSdkAutoConstructList.getInstance();
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptSubscriptionRequestResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.decisionComment(model.decisionComment);
            this.domainId(model.domainId);
            this.id(model.id);
            this.requestReason(model.requestReason);
            this.reviewerId(model.reviewerId);
            this.status(model.status);
            this.subscribedListings(model.subscribedListings);
            this.subscribedPrincipals(model.subscribedPrincipals);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final String getDecisionComment() {
            return this.decisionComment;
        }

        public final void setDecisionComment(String decisionComment) {
            this.decisionComment = decisionComment;
        }

        @Override
        public final Builder decisionComment(String decisionComment) {
            this.decisionComment = decisionComment;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getRequestReason() {
            return this.requestReason;
        }

        public final void setRequestReason(String requestReason) {
            this.requestReason = requestReason;
        }

        @Override
        public final Builder requestReason(String requestReason) {
            this.requestReason = requestReason;
            return this;
        }

        public final String getReviewerId() {
            return this.reviewerId;
        }

        public final void setReviewerId(String reviewerId) {
            this.reviewerId = reviewerId;
        }

        @Override
        public final Builder reviewerId(String reviewerId) {
            this.reviewerId = reviewerId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(SubscriptionRequestStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final List<SubscribedListing.Builder> getSubscribedListings() {
            List<SubscribedListing.Builder> result = AcceptSubscriptionRequestOutputSubscribedListingsListCopier.copyToBuilder(this.subscribedListings);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedListings(Collection<SubscribedListing.BuilderImpl> subscribedListings) {
            this.subscribedListings = AcceptSubscriptionRequestOutputSubscribedListingsListCopier.copyFromBuilder(subscribedListings);
        }

        @Override
        public final Builder subscribedListings(Collection<SubscribedListing> subscribedListings) {
            this.subscribedListings = AcceptSubscriptionRequestOutputSubscribedListingsListCopier.copy(subscribedListings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedListings(SubscribedListing ... subscribedListings) {
            this.subscribedListings(Arrays.asList(subscribedListings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedListings(Consumer<SubscribedListing.Builder> ... subscribedListings) {
            this.subscribedListings(Stream.of(subscribedListings).map(c -> (SubscribedListing)((SubscribedListing.Builder)SubscribedListing.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<SubscribedPrincipal.Builder> getSubscribedPrincipals() {
            List<SubscribedPrincipal.Builder> result = AcceptSubscriptionRequestOutputSubscribedPrincipalsListCopier.copyToBuilder(this.subscribedPrincipals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubscribedPrincipals(Collection<SubscribedPrincipal.BuilderImpl> subscribedPrincipals) {
            this.subscribedPrincipals = AcceptSubscriptionRequestOutputSubscribedPrincipalsListCopier.copyFromBuilder(subscribedPrincipals);
        }

        @Override
        public final Builder subscribedPrincipals(Collection<SubscribedPrincipal> subscribedPrincipals) {
            this.subscribedPrincipals = AcceptSubscriptionRequestOutputSubscribedPrincipalsListCopier.copy(subscribedPrincipals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedPrincipals(SubscribedPrincipal ... subscribedPrincipals) {
            this.subscribedPrincipals(Arrays.asList(subscribedPrincipals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subscribedPrincipals(Consumer<SubscribedPrincipal.Builder> ... subscribedPrincipals) {
            this.subscribedPrincipals(Stream.of(subscribedPrincipals).map(c -> (SubscribedPrincipal)((SubscribedPrincipal.Builder)SubscribedPrincipal.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public AcceptSubscriptionRequestResponse build() {
            return new AcceptSubscriptionRequestResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptSubscriptionRequestResponse> {
        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder decisionComment(String var1);

        public Builder domainId(String var1);

        public Builder id(String var1);

        public Builder requestReason(String var1);

        public Builder reviewerId(String var1);

        public Builder status(String var1);

        public Builder status(SubscriptionRequestStatus var1);

        public Builder subscribedListings(Collection<SubscribedListing> var1);

        public Builder subscribedListings(SubscribedListing ... var1);

        public Builder subscribedListings(Consumer<SubscribedListing.Builder> ... var1);

        public Builder subscribedPrincipals(Collection<SubscribedPrincipal> var1);

        public Builder subscribedPrincipals(SubscribedPrincipal ... var1);

        public Builder subscribedPrincipals(Consumer<SubscribedPrincipal.Builder> ... var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

