/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AcceptedAssetScope;
import software.amazon.awssdk.services.datazone.model.AcceptedAssetScopesCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AcceptSubscriptionRequestRequest
extends DataZoneRequest
implements ToCopyableBuilder<Builder, AcceptSubscriptionRequestRequest> {
    private static final SdkField<List<AcceptedAssetScope>> ASSET_SCOPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("assetScopes").getter(AcceptSubscriptionRequestRequest.getter(AcceptSubscriptionRequestRequest::assetScopes)).setter(AcceptSubscriptionRequestRequest.setter(Builder::assetScopes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetScopes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AcceptedAssetScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DECISION_COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("decisionComment").getter(AcceptSubscriptionRequestRequest.getter(AcceptSubscriptionRequestRequest::decisionComment)).setter(AcceptSubscriptionRequestRequest.setter(Builder::decisionComment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("decisionComment").build()}).build();
    private static final SdkField<String> DOMAIN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainIdentifier").getter(AcceptSubscriptionRequestRequest.getter(AcceptSubscriptionRequestRequest::domainIdentifier)).setter(AcceptSubscriptionRequestRequest.setter(Builder::domainIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("domainIdentifier").build()}).build();
    private static final SdkField<String> IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("identifier").getter(AcceptSubscriptionRequestRequest.getter(AcceptSubscriptionRequestRequest::identifier)).setter(AcceptSubscriptionRequestRequest.setter(Builder::identifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("identifier").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_SCOPES_FIELD, DECISION_COMMENT_FIELD, DOMAIN_IDENTIFIER_FIELD, IDENTIFIER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("assetScopes", ASSET_SCOPES_FIELD);
            this.put("decisionComment", DECISION_COMMENT_FIELD);
            this.put("domainIdentifier", DOMAIN_IDENTIFIER_FIELD);
            this.put("identifier", IDENTIFIER_FIELD);
        }
    });
    private final List<AcceptedAssetScope> assetScopes;
    private final String decisionComment;
    private final String domainIdentifier;
    private final String identifier;

    private AcceptSubscriptionRequestRequest(BuilderImpl builder) {
        super(builder);
        this.assetScopes = builder.assetScopes;
        this.decisionComment = builder.decisionComment;
        this.domainIdentifier = builder.domainIdentifier;
        this.identifier = builder.identifier;
    }

    public final boolean hasAssetScopes() {
        return this.assetScopes != null && !(this.assetScopes instanceof SdkAutoConstructList);
    }

    public final List<AcceptedAssetScope> assetScopes() {
        return this.assetScopes;
    }

    public final String decisionComment() {
        return this.decisionComment;
    }

    public final String domainIdentifier() {
        return this.domainIdentifier;
    }

    public final String identifier() {
        return this.identifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAssetScopes() ? this.assetScopes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.decisionComment());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifier());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceptSubscriptionRequestRequest)) {
            return false;
        }
        AcceptSubscriptionRequestRequest other = (AcceptSubscriptionRequestRequest)((Object)obj);
        return this.hasAssetScopes() == other.hasAssetScopes() && Objects.equals(this.assetScopes(), other.assetScopes()) && Objects.equals(this.decisionComment(), other.decisionComment()) && Objects.equals(this.domainIdentifier(), other.domainIdentifier()) && Objects.equals(this.identifier(), other.identifier());
    }

    public final String toString() {
        return ToString.builder((String)"AcceptSubscriptionRequestRequest").add("AssetScopes", this.hasAssetScopes() ? this.assetScopes() : null).add("DecisionComment", (Object)(this.decisionComment() == null ? null : "*** Sensitive Data Redacted ***")).add("DomainIdentifier", (Object)this.domainIdentifier()).add("Identifier", (Object)this.identifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetScopes": {
                return Optional.ofNullable(clazz.cast(this.assetScopes()));
            }
            case "decisionComment": {
                return Optional.ofNullable(clazz.cast(this.decisionComment()));
            }
            case "domainIdentifier": {
                return Optional.ofNullable(clazz.cast(this.domainIdentifier()));
            }
            case "identifier": {
                return Optional.ofNullable(clazz.cast(this.identifier()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AcceptSubscriptionRequestRequest, T> g) {
        return obj -> g.apply((AcceptSubscriptionRequestRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneRequest.BuilderImpl
    implements Builder {
        private List<AcceptedAssetScope> assetScopes = DefaultSdkAutoConstructList.getInstance();
        private String decisionComment;
        private String domainIdentifier;
        private String identifier;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceptSubscriptionRequestRequest model) {
            super(model);
            this.assetScopes(model.assetScopes);
            this.decisionComment(model.decisionComment);
            this.domainIdentifier(model.domainIdentifier);
            this.identifier(model.identifier);
        }

        public final List<AcceptedAssetScope.Builder> getAssetScopes() {
            List<AcceptedAssetScope.Builder> result = AcceptedAssetScopesCopier.copyToBuilder(this.assetScopes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAssetScopes(Collection<AcceptedAssetScope.BuilderImpl> assetScopes) {
            this.assetScopes = AcceptedAssetScopesCopier.copyFromBuilder(assetScopes);
        }

        @Override
        public final Builder assetScopes(Collection<AcceptedAssetScope> assetScopes) {
            this.assetScopes = AcceptedAssetScopesCopier.copy(assetScopes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetScopes(AcceptedAssetScope ... assetScopes) {
            this.assetScopes(Arrays.asList(assetScopes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder assetScopes(Consumer<AcceptedAssetScope.Builder> ... assetScopes) {
            this.assetScopes(Stream.of(assetScopes).map(c -> (AcceptedAssetScope)((AcceptedAssetScope.Builder)AcceptedAssetScope.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDecisionComment() {
            return this.decisionComment;
        }

        public final void setDecisionComment(String decisionComment) {
            this.decisionComment = decisionComment;
        }

        @Override
        public final Builder decisionComment(String decisionComment) {
            this.decisionComment = decisionComment;
            return this;
        }

        public final String getDomainIdentifier() {
            return this.domainIdentifier;
        }

        public final void setDomainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
        }

        @Override
        public final Builder domainIdentifier(String domainIdentifier) {
            this.domainIdentifier = domainIdentifier;
            return this;
        }

        public final String getIdentifier() {
            return this.identifier;
        }

        public final void setIdentifier(String identifier) {
            this.identifier = identifier;
        }

        @Override
        public final Builder identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AcceptSubscriptionRequestRequest build() {
            return new AcceptSubscriptionRequestRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DataZoneRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, AcceptSubscriptionRequestRequest> {
        public Builder assetScopes(Collection<AcceptedAssetScope> var1);

        public Builder assetScopes(AcceptedAssetScope ... var1);

        public Builder assetScopes(Consumer<AcceptedAssetScope.Builder> ... var1);

        public Builder decisionComment(String var1);

        public Builder domainIdentifier(String var1);

        public Builder identifier(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

