/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.datazone.model.EnabledRegionListCopier;
import software.amazon.awssdk.services.datazone.model.ProvisioningConfiguration;
import software.amazon.awssdk.services.datazone.model.ProvisioningConfigurationListCopier;
import software.amazon.awssdk.services.datazone.model.RegionalParameterMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EnvironmentBlueprintConfigurationItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EnvironmentBlueprintConfigurationItem> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(EnvironmentBlueprintConfigurationItem.getter(EnvironmentBlueprintConfigurationItem::createdAt)).setter(EnvironmentBlueprintConfigurationItem.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> DOMAIN_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("domainId").getter(EnvironmentBlueprintConfigurationItem.getter(EnvironmentBlueprintConfigurationItem::domainId)).setter(EnvironmentBlueprintConfigurationItem.setter(Builder::domainId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainId").build()}).build();
    private static final SdkField<List<String>> ENABLED_REGIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("enabledRegions").getter(EnvironmentBlueprintConfigurationItem.getter(EnvironmentBlueprintConfigurationItem::enabledRegions)).setter(EnvironmentBlueprintConfigurationItem.setter(Builder::enabledRegions)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enabledRegions").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ENVIRONMENT_BLUEPRINT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("environmentBlueprintId").getter(EnvironmentBlueprintConfigurationItem.getter(EnvironmentBlueprintConfigurationItem::environmentBlueprintId)).setter(EnvironmentBlueprintConfigurationItem.setter(Builder::environmentBlueprintId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentBlueprintId").build()}).build();
    private static final SdkField<String> MANAGE_ACCESS_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("manageAccessRoleArn").getter(EnvironmentBlueprintConfigurationItem.getter(EnvironmentBlueprintConfigurationItem::manageAccessRoleArn)).setter(EnvironmentBlueprintConfigurationItem.setter(Builder::manageAccessRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manageAccessRoleArn").build()}).build();
    private static final SdkField<List<ProvisioningConfiguration>> PROVISIONING_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("provisioningConfigurations").getter(EnvironmentBlueprintConfigurationItem.getter(EnvironmentBlueprintConfigurationItem::provisioningConfigurations)).setter(EnvironmentBlueprintConfigurationItem.setter(Builder::provisioningConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ProvisioningConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> PROVISIONING_ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provisioningRoleArn").getter(EnvironmentBlueprintConfigurationItem.getter(EnvironmentBlueprintConfigurationItem::provisioningRoleArn)).setter(EnvironmentBlueprintConfigurationItem.setter(Builder::provisioningRoleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningRoleArn").build()}).build();
    private static final SdkField<Map<String, Map<String, String>>> REGIONAL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("regionalParameters").getter(EnvironmentBlueprintConfigurationItem.getter(EnvironmentBlueprintConfigurationItem::regionalParameters)).setter(EnvironmentBlueprintConfigurationItem.setter(Builder::regionalParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionalParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.MAP).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(EnvironmentBlueprintConfigurationItem.getter(EnvironmentBlueprintConfigurationItem::updatedAt)).setter(EnvironmentBlueprintConfigurationItem.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DOMAIN_ID_FIELD, ENABLED_REGIONS_FIELD, ENVIRONMENT_BLUEPRINT_ID_FIELD, MANAGE_ACCESS_ROLE_ARN_FIELD, PROVISIONING_CONFIGURATIONS_FIELD, PROVISIONING_ROLE_ARN_FIELD, REGIONAL_PARAMETERS_FIELD, UPDATED_AT_FIELD));
    private static final long serialVersionUID = 1L;
    private final Instant createdAt;
    private final String domainId;
    private final List<String> enabledRegions;
    private final String environmentBlueprintId;
    private final String manageAccessRoleArn;
    private final List<ProvisioningConfiguration> provisioningConfigurations;
    private final String provisioningRoleArn;
    private final Map<String, Map<String, String>> regionalParameters;
    private final Instant updatedAt;

    private EnvironmentBlueprintConfigurationItem(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.domainId = builder.domainId;
        this.enabledRegions = builder.enabledRegions;
        this.environmentBlueprintId = builder.environmentBlueprintId;
        this.manageAccessRoleArn = builder.manageAccessRoleArn;
        this.provisioningConfigurations = builder.provisioningConfigurations;
        this.provisioningRoleArn = builder.provisioningRoleArn;
        this.regionalParameters = builder.regionalParameters;
        this.updatedAt = builder.updatedAt;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String domainId() {
        return this.domainId;
    }

    public final boolean hasEnabledRegions() {
        return this.enabledRegions != null && !(this.enabledRegions instanceof SdkAutoConstructList);
    }

    public final List<String> enabledRegions() {
        return this.enabledRegions;
    }

    public final String environmentBlueprintId() {
        return this.environmentBlueprintId;
    }

    public final String manageAccessRoleArn() {
        return this.manageAccessRoleArn;
    }

    public final boolean hasProvisioningConfigurations() {
        return this.provisioningConfigurations != null && !(this.provisioningConfigurations instanceof SdkAutoConstructList);
    }

    public final List<ProvisioningConfiguration> provisioningConfigurations() {
        return this.provisioningConfigurations;
    }

    public final String provisioningRoleArn() {
        return this.provisioningRoleArn;
    }

    public final boolean hasRegionalParameters() {
        return this.regionalParameters != null && !(this.regionalParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, Map<String, String>> regionalParameters() {
        return this.regionalParameters;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnabledRegions() ? this.enabledRegions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.environmentBlueprintId());
        hashCode = 31 * hashCode + Objects.hashCode(this.manageAccessRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProvisioningConfigurations() ? this.provisioningConfigurations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRegionalParameters() ? this.regionalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EnvironmentBlueprintConfigurationItem)) {
            return false;
        }
        EnvironmentBlueprintConfigurationItem other = (EnvironmentBlueprintConfigurationItem)obj;
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.domainId(), other.domainId()) && this.hasEnabledRegions() == other.hasEnabledRegions() && Objects.equals(this.enabledRegions(), other.enabledRegions()) && Objects.equals(this.environmentBlueprintId(), other.environmentBlueprintId()) && Objects.equals(this.manageAccessRoleArn(), other.manageAccessRoleArn()) && this.hasProvisioningConfigurations() == other.hasProvisioningConfigurations() && Objects.equals(this.provisioningConfigurations(), other.provisioningConfigurations()) && Objects.equals(this.provisioningRoleArn(), other.provisioningRoleArn()) && this.hasRegionalParameters() == other.hasRegionalParameters() && Objects.equals(this.regionalParameters(), other.regionalParameters()) && Objects.equals(this.updatedAt(), other.updatedAt());
    }

    public final String toString() {
        return ToString.builder((String)"EnvironmentBlueprintConfigurationItem").add("CreatedAt", (Object)this.createdAt()).add("DomainId", (Object)this.domainId()).add("EnabledRegions", this.hasEnabledRegions() ? this.enabledRegions() : null).add("EnvironmentBlueprintId", (Object)this.environmentBlueprintId()).add("ManageAccessRoleArn", (Object)this.manageAccessRoleArn()).add("ProvisioningConfigurations", this.hasProvisioningConfigurations() ? this.provisioningConfigurations() : null).add("ProvisioningRoleArn", (Object)this.provisioningRoleArn()).add("RegionalParameters", this.hasRegionalParameters() ? this.regionalParameters() : null).add("UpdatedAt", (Object)this.updatedAt()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "domainId": {
                return Optional.ofNullable(clazz.cast(this.domainId()));
            }
            case "enabledRegions": {
                return Optional.ofNullable(clazz.cast(this.enabledRegions()));
            }
            case "environmentBlueprintId": {
                return Optional.ofNullable(clazz.cast(this.environmentBlueprintId()));
            }
            case "manageAccessRoleArn": {
                return Optional.ofNullable(clazz.cast(this.manageAccessRoleArn()));
            }
            case "provisioningConfigurations": {
                return Optional.ofNullable(clazz.cast(this.provisioningConfigurations()));
            }
            case "provisioningRoleArn": {
                return Optional.ofNullable(clazz.cast(this.provisioningRoleArn()));
            }
            case "regionalParameters": {
                return Optional.ofNullable(clazz.cast(this.regionalParameters()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EnvironmentBlueprintConfigurationItem, T> g) {
        return obj -> g.apply((EnvironmentBlueprintConfigurationItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Instant createdAt;
        private String domainId;
        private List<String> enabledRegions = DefaultSdkAutoConstructList.getInstance();
        private String environmentBlueprintId;
        private String manageAccessRoleArn;
        private List<ProvisioningConfiguration> provisioningConfigurations = DefaultSdkAutoConstructList.getInstance();
        private String provisioningRoleArn;
        private Map<String, Map<String, String>> regionalParameters = DefaultSdkAutoConstructMap.getInstance();
        private Instant updatedAt;

        private BuilderImpl() {
        }

        private BuilderImpl(EnvironmentBlueprintConfigurationItem model) {
            this.createdAt(model.createdAt);
            this.domainId(model.domainId);
            this.enabledRegions(model.enabledRegions);
            this.environmentBlueprintId(model.environmentBlueprintId);
            this.manageAccessRoleArn(model.manageAccessRoleArn);
            this.provisioningConfigurations(model.provisioningConfigurations);
            this.provisioningRoleArn(model.provisioningRoleArn);
            this.regionalParameters(model.regionalParameters);
            this.updatedAt(model.updatedAt);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getDomainId() {
            return this.domainId;
        }

        public final void setDomainId(String domainId) {
            this.domainId = domainId;
        }

        @Override
        public final Builder domainId(String domainId) {
            this.domainId = domainId;
            return this;
        }

        public final Collection<String> getEnabledRegions() {
            if (this.enabledRegions instanceof SdkAutoConstructList) {
                return null;
            }
            return this.enabledRegions;
        }

        public final void setEnabledRegions(Collection<String> enabledRegions) {
            this.enabledRegions = EnabledRegionListCopier.copy(enabledRegions);
        }

        @Override
        public final Builder enabledRegions(Collection<String> enabledRegions) {
            this.enabledRegions = EnabledRegionListCopier.copy(enabledRegions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder enabledRegions(String ... enabledRegions) {
            this.enabledRegions(Arrays.asList(enabledRegions));
            return this;
        }

        public final String getEnvironmentBlueprintId() {
            return this.environmentBlueprintId;
        }

        public final void setEnvironmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
        }

        @Override
        public final Builder environmentBlueprintId(String environmentBlueprintId) {
            this.environmentBlueprintId = environmentBlueprintId;
            return this;
        }

        public final String getManageAccessRoleArn() {
            return this.manageAccessRoleArn;
        }

        public final void setManageAccessRoleArn(String manageAccessRoleArn) {
            this.manageAccessRoleArn = manageAccessRoleArn;
        }

        @Override
        public final Builder manageAccessRoleArn(String manageAccessRoleArn) {
            this.manageAccessRoleArn = manageAccessRoleArn;
            return this;
        }

        public final List<ProvisioningConfiguration.Builder> getProvisioningConfigurations() {
            List<ProvisioningConfiguration.Builder> result = ProvisioningConfigurationListCopier.copyToBuilder(this.provisioningConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setProvisioningConfigurations(Collection<ProvisioningConfiguration.BuilderImpl> provisioningConfigurations) {
            this.provisioningConfigurations = ProvisioningConfigurationListCopier.copyFromBuilder(provisioningConfigurations);
        }

        @Override
        public final Builder provisioningConfigurations(Collection<ProvisioningConfiguration> provisioningConfigurations) {
            this.provisioningConfigurations = ProvisioningConfigurationListCopier.copy(provisioningConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningConfigurations(ProvisioningConfiguration ... provisioningConfigurations) {
            this.provisioningConfigurations(Arrays.asList(provisioningConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder provisioningConfigurations(Consumer<ProvisioningConfiguration.Builder> ... provisioningConfigurations) {
            this.provisioningConfigurations(Stream.of(provisioningConfigurations).map(c -> (ProvisioningConfiguration)((ProvisioningConfiguration.Builder)ProvisioningConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getProvisioningRoleArn() {
            return this.provisioningRoleArn;
        }

        public final void setProvisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
        }

        @Override
        public final Builder provisioningRoleArn(String provisioningRoleArn) {
            this.provisioningRoleArn = provisioningRoleArn;
            return this;
        }

        public final Map<String, ? extends Map<String, String>> getRegionalParameters() {
            if (this.regionalParameters instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.regionalParameters;
        }

        public final void setRegionalParameters(Map<String, ? extends Map<String, String>> regionalParameters) {
            this.regionalParameters = RegionalParameterMapCopier.copy(regionalParameters);
        }

        @Override
        public final Builder regionalParameters(Map<String, ? extends Map<String, String>> regionalParameters) {
            this.regionalParameters = RegionalParameterMapCopier.copy(regionalParameters);
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public EnvironmentBlueprintConfigurationItem build() {
            return new EnvironmentBlueprintConfigurationItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EnvironmentBlueprintConfigurationItem> {
        public Builder createdAt(Instant var1);

        public Builder domainId(String var1);

        public Builder enabledRegions(Collection<String> var1);

        public Builder enabledRegions(String ... var1);

        public Builder environmentBlueprintId(String var1);

        public Builder manageAccessRoleArn(String var1);

        public Builder provisioningConfigurations(Collection<ProvisioningConfiguration> var1);

        public Builder provisioningConfigurations(ProvisioningConfiguration ... var1);

        public Builder provisioningConfigurations(Consumer<ProvisioningConfiguration.Builder> ... var1);

        public Builder provisioningRoleArn(String var1);

        public Builder regionalParameters(Map<String, ? extends Map<String, String>> var1);

        public Builder updatedAt(Instant var1);
    }
}

