/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.AssetScope;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTerm;
import software.amazon.awssdk.services.datazone.model.DetailedGlossaryTermsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubscribedAssetListing
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubscribedAssetListing> {
    private static final SdkField<AssetScope> ASSET_SCOPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("assetScope").getter(SubscribedAssetListing.getter(SubscribedAssetListing::assetScope)).setter(SubscribedAssetListing.setter(Builder::assetScope)).constructor(AssetScope::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assetScope").build()}).build();
    private static final SdkField<String> ENTITY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityId").getter(SubscribedAssetListing.getter(SubscribedAssetListing::entityId)).setter(SubscribedAssetListing.setter(Builder::entityId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityId").build()}).build();
    private static final SdkField<String> ENTITY_REVISION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityRevision").getter(SubscribedAssetListing.getter(SubscribedAssetListing::entityRevision)).setter(SubscribedAssetListing.setter(Builder::entityRevision)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityRevision").build()}).build();
    private static final SdkField<String> ENTITY_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("entityType").getter(SubscribedAssetListing.getter(SubscribedAssetListing::entityType)).setter(SubscribedAssetListing.setter(Builder::entityType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("entityType").build()}).build();
    private static final SdkField<String> FORMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("forms").getter(SubscribedAssetListing.getter(SubscribedAssetListing::forms)).setter(SubscribedAssetListing.setter(Builder::forms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("forms").build()}).build();
    private static final SdkField<List<DetailedGlossaryTerm>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(SubscribedAssetListing.getter(SubscribedAssetListing::glossaryTerms)).setter(SubscribedAssetListing.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DetailedGlossaryTerm::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSET_SCOPE_FIELD, ENTITY_ID_FIELD, ENTITY_REVISION_FIELD, ENTITY_TYPE_FIELD, FORMS_FIELD, GLOSSARY_TERMS_FIELD));
    private static final long serialVersionUID = 1L;
    private final AssetScope assetScope;
    private final String entityId;
    private final String entityRevision;
    private final String entityType;
    private final String forms;
    private final List<DetailedGlossaryTerm> glossaryTerms;

    private SubscribedAssetListing(BuilderImpl builder) {
        this.assetScope = builder.assetScope;
        this.entityId = builder.entityId;
        this.entityRevision = builder.entityRevision;
        this.entityType = builder.entityType;
        this.forms = builder.forms;
        this.glossaryTerms = builder.glossaryTerms;
    }

    public final AssetScope assetScope() {
        return this.assetScope;
    }

    public final String entityId() {
        return this.entityId;
    }

    public final String entityRevision() {
        return this.entityRevision;
    }

    public final String entityType() {
        return this.entityType;
    }

    public final String forms() {
        return this.forms;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<DetailedGlossaryTerm> glossaryTerms() {
        return this.glossaryTerms;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.assetScope());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityId());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityRevision());
        hashCode = 31 * hashCode + Objects.hashCode(this.entityType());
        hashCode = 31 * hashCode + Objects.hashCode(this.forms());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubscribedAssetListing)) {
            return false;
        }
        SubscribedAssetListing other = (SubscribedAssetListing)obj;
        return Objects.equals(this.assetScope(), other.assetScope()) && Objects.equals(this.entityId(), other.entityId()) && Objects.equals(this.entityRevision(), other.entityRevision()) && Objects.equals(this.entityType(), other.entityType()) && Objects.equals(this.forms(), other.forms()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms());
    }

    public final String toString() {
        return ToString.builder((String)"SubscribedAssetListing").add("AssetScope", (Object)this.assetScope()).add("EntityId", (Object)this.entityId()).add("EntityRevision", (Object)this.entityRevision()).add("EntityType", (Object)this.entityType()).add("Forms", (Object)this.forms()).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "assetScope": {
                return Optional.ofNullable(clazz.cast(this.assetScope()));
            }
            case "entityId": {
                return Optional.ofNullable(clazz.cast(this.entityId()));
            }
            case "entityRevision": {
                return Optional.ofNullable(clazz.cast(this.entityRevision()));
            }
            case "entityType": {
                return Optional.ofNullable(clazz.cast(this.entityType()));
            }
            case "forms": {
                return Optional.ofNullable(clazz.cast(this.forms()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SubscribedAssetListing, T> g) {
        return obj -> g.apply((SubscribedAssetListing)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AssetScope assetScope;
        private String entityId;
        private String entityRevision;
        private String entityType;
        private String forms;
        private List<DetailedGlossaryTerm> glossaryTerms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubscribedAssetListing model) {
            this.assetScope(model.assetScope);
            this.entityId(model.entityId);
            this.entityRevision(model.entityRevision);
            this.entityType(model.entityType);
            this.forms(model.forms);
            this.glossaryTerms(model.glossaryTerms);
        }

        public final AssetScope.Builder getAssetScope() {
            return this.assetScope != null ? this.assetScope.toBuilder() : null;
        }

        public final void setAssetScope(AssetScope.BuilderImpl assetScope) {
            this.assetScope = assetScope != null ? assetScope.build() : null;
        }

        @Override
        public final Builder assetScope(AssetScope assetScope) {
            this.assetScope = assetScope;
            return this;
        }

        public final String getEntityId() {
            return this.entityId;
        }

        public final void setEntityId(String entityId) {
            this.entityId = entityId;
        }

        @Override
        public final Builder entityId(String entityId) {
            this.entityId = entityId;
            return this;
        }

        public final String getEntityRevision() {
            return this.entityRevision;
        }

        public final void setEntityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
        }

        @Override
        public final Builder entityRevision(String entityRevision) {
            this.entityRevision = entityRevision;
            return this;
        }

        public final String getEntityType() {
            return this.entityType;
        }

        public final void setEntityType(String entityType) {
            this.entityType = entityType;
        }

        @Override
        public final Builder entityType(String entityType) {
            this.entityType = entityType;
            return this;
        }

        public final String getForms() {
            return this.forms;
        }

        public final void setForms(String forms) {
            this.forms = forms;
        }

        @Override
        public final Builder forms(String forms) {
            this.forms = forms;
            return this;
        }

        public final List<DetailedGlossaryTerm.Builder> getGlossaryTerms() {
            List<DetailedGlossaryTerm.Builder> result = DetailedGlossaryTermsCopier.copyToBuilder(this.glossaryTerms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setGlossaryTerms(Collection<DetailedGlossaryTerm.BuilderImpl> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copyFromBuilder(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<DetailedGlossaryTerm> glossaryTerms) {
            this.glossaryTerms = DetailedGlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(DetailedGlossaryTerm ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... glossaryTerms) {
            this.glossaryTerms(Stream.of(glossaryTerms).map(c -> (DetailedGlossaryTerm)((DetailedGlossaryTerm.Builder)DetailedGlossaryTerm.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public SubscribedAssetListing build() {
            return new SubscribedAssetListing(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubscribedAssetListing> {
        public Builder assetScope(AssetScope var1);

        default public Builder assetScope(Consumer<AssetScope.Builder> assetScope) {
            return this.assetScope((AssetScope)((AssetScope.Builder)AssetScope.builder().applyMutation(assetScope)).build());
        }

        public Builder entityId(String var1);

        public Builder entityRevision(String var1);

        public Builder entityType(String var1);

        public Builder forms(String var1);

        public Builder glossaryTerms(Collection<DetailedGlossaryTerm> var1);

        public Builder glossaryTerms(DetailedGlossaryTerm ... var1);

        public Builder glossaryTerms(Consumer<DetailedGlossaryTerm.Builder> ... var1);
    }
}

