/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.datazone.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.datazone.model.CustomParameter;
import software.amazon.awssdk.services.datazone.model.CustomParameterListCopier;
import software.amazon.awssdk.services.datazone.model.DataZoneResponse;
import software.amazon.awssdk.services.datazone.model.DeploymentProperties;
import software.amazon.awssdk.services.datazone.model.GlossaryTermsCopier;
import software.amazon.awssdk.services.datazone.model.ProvisioningProperties;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetEnvironmentBlueprintResponse
extends DataZoneResponse
implements ToCopyableBuilder<Builder, GetEnvironmentBlueprintResponse> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetEnvironmentBlueprintResponse.getter(GetEnvironmentBlueprintResponse::createdAt)).setter(GetEnvironmentBlueprintResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<DeploymentProperties> DEPLOYMENT_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("deploymentProperties").getter(GetEnvironmentBlueprintResponse.getter(GetEnvironmentBlueprintResponse::deploymentProperties)).setter(GetEnvironmentBlueprintResponse.setter(Builder::deploymentProperties)).constructor(DeploymentProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentProperties").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetEnvironmentBlueprintResponse.getter(GetEnvironmentBlueprintResponse::description)).setter(GetEnvironmentBlueprintResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> GLOSSARY_TERMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("glossaryTerms").getter(GetEnvironmentBlueprintResponse.getter(GetEnvironmentBlueprintResponse::glossaryTerms)).setter(GetEnvironmentBlueprintResponse.setter(Builder::glossaryTerms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("glossaryTerms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("id").getter(GetEnvironmentBlueprintResponse.getter(GetEnvironmentBlueprintResponse::id)).setter(GetEnvironmentBlueprintResponse.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(GetEnvironmentBlueprintResponse.getter(GetEnvironmentBlueprintResponse::name)).setter(GetEnvironmentBlueprintResponse.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> PROVIDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("provider").getter(GetEnvironmentBlueprintResponse.getter(GetEnvironmentBlueprintResponse::provider)).setter(GetEnvironmentBlueprintResponse.setter(Builder::provider)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provider").build()}).build();
    private static final SdkField<ProvisioningProperties> PROVISIONING_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("provisioningProperties").getter(GetEnvironmentBlueprintResponse.getter(GetEnvironmentBlueprintResponse::provisioningProperties)).setter(GetEnvironmentBlueprintResponse.setter(Builder::provisioningProperties)).constructor(ProvisioningProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("provisioningProperties").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(GetEnvironmentBlueprintResponse.getter(GetEnvironmentBlueprintResponse::updatedAt)).setter(GetEnvironmentBlueprintResponse.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<List<CustomParameter>> USER_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("userParameters").getter(GetEnvironmentBlueprintResponse.getter(GetEnvironmentBlueprintResponse::userParameters)).setter(GetEnvironmentBlueprintResponse.setter(Builder::userParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userParameters").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CustomParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD, DEPLOYMENT_PROPERTIES_FIELD, DESCRIPTION_FIELD, GLOSSARY_TERMS_FIELD, ID_FIELD, NAME_FIELD, PROVIDER_FIELD, PROVISIONING_PROPERTIES_FIELD, UPDATED_AT_FIELD, USER_PARAMETERS_FIELD));
    private final Instant createdAt;
    private final DeploymentProperties deploymentProperties;
    private final String description;
    private final List<String> glossaryTerms;
    private final String id;
    private final String name;
    private final String provider;
    private final ProvisioningProperties provisioningProperties;
    private final Instant updatedAt;
    private final List<CustomParameter> userParameters;

    private GetEnvironmentBlueprintResponse(BuilderImpl builder) {
        super(builder);
        this.createdAt = builder.createdAt;
        this.deploymentProperties = builder.deploymentProperties;
        this.description = builder.description;
        this.glossaryTerms = builder.glossaryTerms;
        this.id = builder.id;
        this.name = builder.name;
        this.provider = builder.provider;
        this.provisioningProperties = builder.provisioningProperties;
        this.updatedAt = builder.updatedAt;
        this.userParameters = builder.userParameters;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final DeploymentProperties deploymentProperties() {
        return this.deploymentProperties;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasGlossaryTerms() {
        return this.glossaryTerms != null && !(this.glossaryTerms instanceof SdkAutoConstructList);
    }

    public final List<String> glossaryTerms() {
        return this.glossaryTerms;
    }

    public final String id() {
        return this.id;
    }

    public final String name() {
        return this.name;
    }

    public final String provider() {
        return this.provider;
    }

    public final ProvisioningProperties provisioningProperties() {
        return this.provisioningProperties;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final boolean hasUserParameters() {
        return this.userParameters != null && !(this.userParameters instanceof SdkAutoConstructList);
    }

    public final List<CustomParameter> userParameters() {
        return this.userParameters;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGlossaryTerms() ? this.glossaryTerms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.provider());
        hashCode = 31 * hashCode + Objects.hashCode(this.provisioningProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasUserParameters() ? this.userParameters() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetEnvironmentBlueprintResponse)) {
            return false;
        }
        GetEnvironmentBlueprintResponse other = (GetEnvironmentBlueprintResponse)((Object)obj);
        return Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.deploymentProperties(), other.deploymentProperties()) && Objects.equals(this.description(), other.description()) && this.hasGlossaryTerms() == other.hasGlossaryTerms() && Objects.equals(this.glossaryTerms(), other.glossaryTerms()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.provider(), other.provider()) && Objects.equals(this.provisioningProperties(), other.provisioningProperties()) && Objects.equals(this.updatedAt(), other.updatedAt()) && this.hasUserParameters() == other.hasUserParameters() && Objects.equals(this.userParameters(), other.userParameters());
    }

    public final String toString() {
        return ToString.builder((String)"GetEnvironmentBlueprintResponse").add("CreatedAt", (Object)this.createdAt()).add("DeploymentProperties", (Object)this.deploymentProperties()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("GlossaryTerms", this.hasGlossaryTerms() ? this.glossaryTerms() : null).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Provider", (Object)this.provider()).add("ProvisioningProperties", (Object)this.provisioningProperties()).add("UpdatedAt", (Object)this.updatedAt()).add("UserParameters", this.hasUserParameters() ? this.userParameters() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "deploymentProperties": {
                return Optional.ofNullable(clazz.cast(this.deploymentProperties()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "glossaryTerms": {
                return Optional.ofNullable(clazz.cast(this.glossaryTerms()));
            }
            case "id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "provider": {
                return Optional.ofNullable(clazz.cast(this.provider()));
            }
            case "provisioningProperties": {
                return Optional.ofNullable(clazz.cast(this.provisioningProperties()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "userParameters": {
                return Optional.ofNullable(clazz.cast(this.userParameters()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GetEnvironmentBlueprintResponse, T> g) {
        return obj -> g.apply((GetEnvironmentBlueprintResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DataZoneResponse.BuilderImpl
    implements Builder {
        private Instant createdAt;
        private DeploymentProperties deploymentProperties;
        private String description;
        private List<String> glossaryTerms = DefaultSdkAutoConstructList.getInstance();
        private String id;
        private String name;
        private String provider;
        private ProvisioningProperties provisioningProperties;
        private Instant updatedAt;
        private List<CustomParameter> userParameters = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GetEnvironmentBlueprintResponse model) {
            super(model);
            this.createdAt(model.createdAt);
            this.deploymentProperties(model.deploymentProperties);
            this.description(model.description);
            this.glossaryTerms(model.glossaryTerms);
            this.id(model.id);
            this.name(model.name);
            this.provider(model.provider);
            this.provisioningProperties(model.provisioningProperties);
            this.updatedAt(model.updatedAt);
            this.userParameters(model.userParameters);
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final DeploymentProperties.Builder getDeploymentProperties() {
            return this.deploymentProperties != null ? this.deploymentProperties.toBuilder() : null;
        }

        public final void setDeploymentProperties(DeploymentProperties.BuilderImpl deploymentProperties) {
            this.deploymentProperties = deploymentProperties != null ? deploymentProperties.build() : null;
        }

        @Override
        public final Builder deploymentProperties(DeploymentProperties deploymentProperties) {
            this.deploymentProperties = deploymentProperties;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getGlossaryTerms() {
            if (this.glossaryTerms instanceof SdkAutoConstructList) {
                return null;
            }
            return this.glossaryTerms;
        }

        public final void setGlossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
        }

        @Override
        public final Builder glossaryTerms(Collection<String> glossaryTerms) {
            this.glossaryTerms = GlossaryTermsCopier.copy(glossaryTerms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder glossaryTerms(String ... glossaryTerms) {
            this.glossaryTerms(Arrays.asList(glossaryTerms));
            return this;
        }

        public final String getId() {
            return this.id;
        }

        public final void setId(String id) {
            this.id = id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getProvider() {
            return this.provider;
        }

        public final void setProvider(String provider) {
            this.provider = provider;
        }

        @Override
        public final Builder provider(String provider) {
            this.provider = provider;
            return this;
        }

        public final ProvisioningProperties.Builder getProvisioningProperties() {
            return this.provisioningProperties != null ? this.provisioningProperties.toBuilder() : null;
        }

        public final void setProvisioningProperties(ProvisioningProperties.BuilderImpl provisioningProperties) {
            this.provisioningProperties = provisioningProperties != null ? provisioningProperties.build() : null;
        }

        @Override
        public final Builder provisioningProperties(ProvisioningProperties provisioningProperties) {
            this.provisioningProperties = provisioningProperties;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final List<CustomParameter.Builder> getUserParameters() {
            List<CustomParameter.Builder> result = CustomParameterListCopier.copyToBuilder(this.userParameters);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserParameters(Collection<CustomParameter.BuilderImpl> userParameters) {
            this.userParameters = CustomParameterListCopier.copyFromBuilder(userParameters);
        }

        @Override
        public final Builder userParameters(Collection<CustomParameter> userParameters) {
            this.userParameters = CustomParameterListCopier.copy(userParameters);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(CustomParameter ... userParameters) {
            this.userParameters(Arrays.asList(userParameters));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userParameters(Consumer<CustomParameter.Builder> ... userParameters) {
            this.userParameters(Stream.of(userParameters).map(c -> (CustomParameter)((CustomParameter.Builder)CustomParameter.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public GetEnvironmentBlueprintResponse build() {
            return new GetEnvironmentBlueprintResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends DataZoneResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetEnvironmentBlueprintResponse> {
        public Builder createdAt(Instant var1);

        public Builder deploymentProperties(DeploymentProperties var1);

        default public Builder deploymentProperties(Consumer<DeploymentProperties.Builder> deploymentProperties) {
            return this.deploymentProperties((DeploymentProperties)((DeploymentProperties.Builder)DeploymentProperties.builder().applyMutation(deploymentProperties)).build());
        }

        public Builder description(String var1);

        public Builder glossaryTerms(Collection<String> var1);

        public Builder glossaryTerms(String ... var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder provider(String var1);

        public Builder provisioningProperties(ProvisioningProperties var1);

        default public Builder provisioningProperties(Consumer<ProvisioningProperties.Builder> provisioningProperties) {
            return this.provisioningProperties((ProvisioningProperties)((ProvisioningProperties.Builder)ProvisioningProperties.builder().applyMutation(provisioningProperties)).build());
        }

        public Builder updatedAt(Instant var1);

        public Builder userParameters(Collection<CustomParameter> var1);

        public Builder userParameters(CustomParameter ... var1);

        public Builder userParameters(Consumer<CustomParameter.Builder> ... var1);
    }
}

